/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ergoplatform.ErgoBox;
import org.ergoplatform.appkit.BoxAttachment;
import org.ergoplatform.appkit.BoxAttachmentGeneric;
import org.ergoplatform.appkit.BoxAttachmentMulti;
import org.ergoplatform.appkit.BoxAttachmentPlainText;
import org.ergoplatform.appkit.ErgoValue;
import org.ergoplatform.appkit.TransactionBox;
import org.ergoplatform.appkit.impl.Eip4TokenBuilder;
import org.ergoplatform.explorer.client.model.AdditionalRegisters;

public class BoxAttachmentBuilder {
    public static int getAttachmentRegisterIndex() {
        return ErgoBox.maxRegisters() - 1;
    }

    public static BoxAttachment buildFromHexEncodedErgoValue(String string) {
        return BoxAttachmentGeneric.createFromErgoValue(ErgoValue.fromHex(string));
    }

    @Nullable
    public static BoxAttachment buildFromAdditionalRegisters(@Nonnull AdditionalRegisters additionalRegisters) {
        try {
            return BoxAttachmentBuilder.buildFromHexEncodedErgoValue(Eip4TokenBuilder.getSerializedErgoValueForRegister(additionalRegisters, "R" + BoxAttachmentBuilder.getAttachmentRegisterIndex()));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Nullable
    public static BoxAttachment buildFromTransactionBox(@Nonnull TransactionBox transactionBox) {
        List<ErgoValue<?>> list = transactionBox.getRegisters();
        try {
            int n = BoxAttachmentBuilder.getAttachmentRegisterIndex() - ErgoBox.startingNonMandatoryIndex();
            return BoxAttachmentGeneric.createFromErgoValue(list.get(n));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static BoxAttachmentPlainText createPlainTextAttachment(String string) {
        return BoxAttachmentPlainText.buildForText(string);
    }

    public static BoxAttachmentMulti createMultiAttachment(List<BoxAttachment> list) {
        return BoxAttachmentMulti.buildForList(list);
    }
}

