/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ergoplatform.appkit.Eip4Token;
import org.ergoplatform.appkit.ErgoValue;
import org.ergoplatform.appkit.TransactionBox;
import org.ergoplatform.explorer.client.DefaultApi;
import org.ergoplatform.explorer.client.model.AdditionalRegister;
import org.ergoplatform.explorer.client.model.AdditionalRegisters;
import org.ergoplatform.explorer.client.model.AssetInstanceInfo;
import org.ergoplatform.explorer.client.model.OutputInfo;
import org.ergoplatform.explorer.client.model.TokenInfo;
import org.ergoplatform.sdk.ErgoToken;
import retrofit2.Response;
import special.collection.Coll;

public class Eip4TokenBuilder {
    @Nonnull
    public static Eip4Token buildFromHexEncodedRegisters(@Nonnull String string, long l, @Nonnull List<String> list) {
        if (list.size() < 3) {
            throw new IllegalArgumentException("EIP-4 compliant minting box additionalRegisters must contain at least R4 to R6");
        }
        ErgoValue<Coll<Object>> ergoValue = Eip4TokenBuilder.decodeCollByteValue(Objects.requireNonNull(list.get(0)));
        ErgoValue<Coll<Object>> ergoValue2 = Eip4TokenBuilder.decodeCollByteValue(Objects.requireNonNull(list.get(1)));
        ErgoValue<Coll<Object>> ergoValue3 = Eip4TokenBuilder.decodeCollByteValue(Objects.requireNonNull(list.get(2)));
        ErgoValue<?> ergoValue4 = list.size() > 3 && list.get(3) != null ? ErgoValue.fromHex(list.get(3)) : null;
        ErgoValue<?> ergoValue5 = list.size() > 4 && list.get(4) != null ? ErgoValue.fromHex(list.get(4)) : null;
        ErgoValue<?> ergoValue6 = list.size() > 5 && list.get(5) != null ? ErgoValue.fromHex(list.get(5)) : null;
        return new Eip4Token(string, l, ergoValue, ergoValue2, ergoValue3, ergoValue4, ergoValue5, ergoValue6);
    }

    private static ErgoValue<Coll<Object>> decodeCollByteValue(String string) {
        return ErgoValue.fromHex(string);
    }

    @Nonnull
    public static Eip4Token buildFromAdditionalRegisters(@Nonnull String string, long l, @Nonnull AdditionalRegisters additionalRegisters) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(Objects.requireNonNull(Eip4TokenBuilder.getSerializedErgoValueForRegister(additionalRegisters, "R4")));
        arrayList.add(Objects.requireNonNull(Eip4TokenBuilder.getSerializedErgoValueForRegister(additionalRegisters, "R5")));
        arrayList.add(Objects.requireNonNull(Eip4TokenBuilder.getSerializedErgoValueForRegister(additionalRegisters, "R6")));
        arrayList.add(Eip4TokenBuilder.getSerializedErgoValueForRegister(additionalRegisters, "R7"));
        arrayList.add(Eip4TokenBuilder.getSerializedErgoValueForRegister(additionalRegisters, "R8"));
        arrayList.add(Eip4TokenBuilder.getSerializedErgoValueForRegister(additionalRegisters, "R9"));
        return Eip4TokenBuilder.buildFromHexEncodedRegisters(string, l, arrayList);
    }

    @Nullable
    public static Eip4Token buildFromExplorerByTokenId(DefaultApi defaultApi, String string) throws IOException {
        Response response = defaultApi.getApiV1TokensP1(string).execute();
        if (!response.isSuccessful()) {
            return null;
        }
        return Eip4TokenBuilder.buildFromExplorerByIssuingBox(defaultApi, string, ((TokenInfo)response.body()).getBoxId());
    }

    @Nullable
    public static Eip4Token buildFromExplorerByIssuingBox(DefaultApi defaultApi, String string, String string2) throws IOException {
        OutputInfo outputInfo = (OutputInfo)defaultApi.getApiV1BoxesP1(string2).execute().body();
        if (outputInfo == null) {
            return null;
        }
        AssetInstanceInfo assetInstanceInfo = null;
        for (AssetInstanceInfo assetInstanceInfo2 : outputInfo.getAssets()) {
            if (!assetInstanceInfo2.getTokenId().equals(string)) continue;
            assetInstanceInfo = assetInstanceInfo2;
        }
        if (assetInstanceInfo == null) {
            throw new IllegalArgumentException("Token with id " + string + " not found in box " + string2);
        }
        return Eip4TokenBuilder.buildFromAdditionalRegisters(string, assetInstanceInfo.getAmount(), outputInfo.getAdditionalRegisters());
    }

    public static Eip4Token buildFromErgoBox(@Nonnull String string, @Nonnull TransactionBox transactionBox) {
        ErgoToken ergoToken = null;
        for (ErgoToken ergoToken2 : transactionBox.getTokens()) {
            if (!ergoToken2.getId().toString().equals(string)) continue;
            ergoToken = ergoToken2;
        }
        if (ergoToken == null) {
            throw new IllegalArgumentException("Token with id " + string + " not found in box");
        }
        List<ErgoValue<?>> list = transactionBox.getRegisters();
        return new Eip4Token(string, ergoToken.getValue(), (ErgoValue)list.get(0), (ErgoValue)list.get(1), (ErgoValue)list.get(2), list.size() > 3 ? (ErgoValue)list.get(3) : null, list.size() > 4 ? (ErgoValue)list.get(4) : null, list.size() > 5 ? (ErgoValue)list.get(5) : null);
    }

    static String getSerializedErgoValueForRegister(AdditionalRegisters additionalRegisters, String string) {
        AdditionalRegister additionalRegister = (AdditionalRegister)additionalRegisters.get(string);
        if (additionalRegister == null) {
            return null;
        }
        return additionalRegister.serializedValue;
    }

    public static Eip4Token buildNftPictureToken(@Nonnull String string, long l, @Nonnull String string2, @Nonnull String string3, int n, @Nonnull byte[] byArray, @Nullable String string4) {
        return Eip4TokenBuilder.buildNftToken(string, l, string2, string3, n, Eip4Token.AssetType.NFT_PICTURE, byArray, string4, null);
    }

    public static Eip4Token buildNftVideoToken(@Nonnull String string, long l, @Nonnull String string2, @Nonnull String string3, int n, @Nonnull byte[] byArray, @Nullable String string4) {
        return Eip4TokenBuilder.buildNftToken(string, l, string2, string3, n, Eip4Token.AssetType.NFT_VIDEO, byArray, string4, null);
    }

    public static Eip4Token buildNftAudioToken(@Nonnull String string, long l, @Nonnull String string2, @Nonnull String string3, int n, @Nonnull byte[] byArray, @Nullable String string4, @Nullable String string5) {
        return Eip4TokenBuilder.buildNftToken(string, l, string2, string3, n, Eip4Token.AssetType.NFT_AUDIO, byArray, string4, string5);
    }

    private static Eip4Token buildNftToken(@Nonnull String string, long l, @Nonnull String string2, @Nonnull String string3, int n, Eip4Token.AssetType assetType, @Nonnull byte[] byArray, @Nullable String string4, @Nullable String string5) {
        ErgoValue<Object> ergoValue;
        ErgoValue<Coll<Byte>> ergoValue2;
        ErgoValue<Coll<Byte>> ergoValue3 = ErgoValue.of(assetType.getR7ByteArrayForType());
        Eip4Token eip4Token = new Eip4Token(string, l, string2, string3, n, ergoValue3, ergoValue2 = ErgoValue.of(byArray), ergoValue = string4 != null && string5 == null ? ErgoValue.of(string4.getBytes(StandardCharsets.UTF_8)) : (string4 != null && string5 != null ? ErgoValue.pairOf(ErgoValue.of(string4.getBytes(StandardCharsets.UTF_8)), ErgoValue.of(string5.getBytes(StandardCharsets.UTF_8))) : null));
        if (!eip4Token.isNftAssetType()) {
            throw new IllegalArgumentException("Constructed token is no NFT type");
        }
        return eip4Token;
    }

    public static Eip4Token buildNftArtworkCollectionToken(@Nonnull String string, long l, @Nonnull String string2, @Nonnull String string3, int n) {
        return new Eip4Token(string, l, string2, string3, n, ErgoValue.of(Eip4Token.AssetType.ARTWORK_COLLECTION.getR7ByteArrayForType()), null, null);
    }
}

