/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import java.util.ArrayList;
import java.util.List;
import okhttp3.OkHttpClient;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.ErgoClientException;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.impl.InputBoxImpl;
import org.ergoplatform.appkit.impl.NodeDataSourceImpl;
import org.ergoplatform.explorer.client.DefaultApi;
import org.ergoplatform.explorer.client.ExplorerApiClient;
import org.ergoplatform.explorer.client.model.OutputInfo;
import org.ergoplatform.restapi.client.ApiClient;
import retrofit2.Retrofit;

public class NodeAndExplorerDataSourceImpl
extends NodeDataSourceImpl {
    private final DefaultApi explorerApi;

    public NodeAndExplorerDataSourceImpl(ApiClient apiClient, ExplorerApiClient explorerApiClient) {
        super(apiClient);
        if (explorerApiClient == null) {
            throw new IllegalArgumentException("For node-only use, use NodeDataSourceImpl");
        }
        OkHttpClient okHttpClient = explorerApiClient.getOkBuilder().build();
        Retrofit retrofit = explorerApiClient.getAdapterBuilder().client(okHttpClient).build();
        this.explorerApi = (DefaultApi)retrofit.create(DefaultApi.class);
    }

    @Override
    protected InputBox getBoxByIdIncludingSpent(String string) {
        if (this.isBlockchainApiEnabled()) {
            return this.getBoxByIdNode(string);
        }
        return this.getBoxByIdExplorer(string);
    }

    public InputBox getBoxByIdExplorer(String string) {
        OutputInfo outputInfo = this.executeCall(this.explorerApi.getApiV1BoxesP1(string));
        return new InputBoxImpl(outputInfo);
    }

    @Override
    public List<InputBox> getUnspentBoxesFor(Address address, int n, int n2) {
        if (this.isBlockchainApiEnabled()) {
            return this.getUnspentBoxesNodeApi(address, n, n2);
        }
        return this.getUnspentBoxesForExplorer(address, n, n2);
    }

    public List<InputBox> getUnspentBoxesForExplorer(Address address, int n, int n2) {
        List<OutputInfo> list = this.executeCall(this.explorerApi.getApiV1BoxesUnspentByaddressP1(address.toString(), n, n2, "asc")).getItems();
        return this.getInputBoxes(list);
    }

    private List<InputBox> getInputBoxes(List<OutputInfo> list) {
        ArrayList<InputBox> arrayList = new ArrayList<InputBox>(list.size());
        for (OutputInfo outputInfo : list) {
            String string = outputInfo.getBoxId();
            try {
                InputBox inputBox = this.getBoxById(string, false, false);
                if (inputBox == null) continue;
                arrayList.add(inputBox);
            }
            catch (ErgoClientException ergoClientException) {}
        }
        return arrayList;
    }

    public DefaultApi getExplorerApi() {
        return this.explorerApi;
    }
}

