/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.ergoplatform.ErgoBoxCandidate;
import org.ergoplatform.SigmaConstants;
import org.ergoplatform.appkit.AppkitHelpers$;
import org.ergoplatform.appkit.Eip4Token;
import org.ergoplatform.appkit.ErgoContract;
import org.ergoplatform.appkit.ErgoValue;
import org.ergoplatform.appkit.OutBox;
import org.ergoplatform.appkit.OutBoxBuilder;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.OutBoxImpl;
import org.ergoplatform.appkit.impl.UnsignedTransactionBuilderImpl;
import org.ergoplatform.sdk.ErgoToken;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import sigmastate.Values;
import special.collection.Coll;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\r\u001b\u0001\rB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\u0006k\u0001!\tA\u000e\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019q\u0004\u0001)A\u0005w!9q\b\u0001a\u0001\n\u0013\u0001\u0005bB$\u0001\u0001\u0004%I\u0001\u0013\u0005\u0007\u001d\u0002\u0001\u000b\u0015B!\t\u0013=\u0003\u0001\u0019!a\u0001\n\u0013\u0001\u0006\"\u0003+\u0001\u0001\u0004\u0005\r\u0011\"\u0003V\u0011%9\u0006\u00011A\u0001B\u0003&\u0011\u000bC\u0004Y\u0001\t\u0007I\u0011B-\t\r!\u0004\u0001\u0015!\u0003[\u0011\u001dI\u0007A1A\u0005\n)Da\u0001\u001e\u0001!\u0002\u0013Y\u0007b\u0002?\u0001\u0001\u0004%I! \u0005\n\u0003\u0013\u0001\u0001\u0019!C\u0005\u0003\u0017Aq!a\u0004\u0001A\u0003&a\u0010C\u0004\u0002\u0012\u0001!\t%a\u0005\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a!9\u0011Q\u0004\u0001\u0005B\u0005}\u0001bBA\u0015\u0001\u0011\u0005\u00131\u0006\u0005\b\u0003o\u0001A\u0011IA\u001d\u0011\u001d\tI\u0005\u0001C!\u0003\u0017Bq!!\u0015\u0001\t\u0003\n\u0019FA\tPkR\u0014u\u000e\u001f\"vS2$WM]%na2T!a\u0007\u000f\u0002\t%l\u0007\u000f\u001c\u0006\u0003;y\ta!\u00199qW&$(BA\u0010!\u00031)'oZ8qY\u0006$hm\u001c:n\u0015\u0005\t\u0013aA8sO\u000e\u00011c\u0001\u0001%YA\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\u0005Y\u0006twMC\u0001*\u0003\u0011Q\u0017M^1\n\u0005-2#AB(cU\u0016\u001cG\u000f\u0005\u0002.]5\tA$\u0003\u000209\tiq*\u001e;C_b\u0014U/\u001b7eKJ\fAa\u0018;y\u0005B\u0011!gM\u0007\u00025%\u0011AG\u0007\u0002\u001f+:\u001c\u0018n\u001a8fIR\u0013\u0018M\\:bGRLwN\u001c\"vS2$WM]%na2\fa\u0001P5oSRtDCA\u001c9!\t\u0011\u0004\u0001C\u00031\u0005\u0001\u0007\u0011'\u0001\u0003`GRDX#A\u001e\u0011\u0005Ib\u0014BA\u001f\u001b\u0005U\u0011En\\2lG\"\f\u0017N\\\"p]R,\u0007\u0010^%na2\fQaX2uq\u0002\naa\u0018<bYV,W#A!\u0011\u0005\t+U\"A\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0003\t1{gnZ\u0001\u000b?Z\fG.^3`I\u0015\fHCA%M!\t\u0011%*\u0003\u0002L\u0007\n!QK\\5u\u0011\u001die!!AA\u0002\u0005\u000b1\u0001\u001f\u00132\u0003\u001dyf/\u00197vK\u0002\n\u0011bX2p]R\u0014\u0018m\u0019;\u0016\u0003E\u0003\"!\f*\n\u0005Mc\"\u0001D#sO>\u001cuN\u001c;sC\u000e$\u0018!D0d_:$(/Y2u?\u0012*\u0017\u000f\u0006\u0002J-\"9Q*CA\u0001\u0002\u0004\t\u0016AC0d_:$(/Y2uA\u00059q\f^8lK:\u001cX#\u0001.\u0011\u0007m\u0003'-D\u0001]\u0015\tif,A\u0004nkR\f'\r\\3\u000b\u0005}\u001b\u0015AC2pY2,7\r^5p]&\u0011\u0011\r\u0018\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0002dM6\tAM\u0003\u0002f=\u0005\u00191\u000fZ6\n\u0005\u001d$'!C#sO>$vn[3o\u0003!yFo\\6f]N\u0004\u0013AC0sK\u001eL7\u000f^3sgV\t1\u000eE\u0002\\A2\u0004$!\u001c:\u0011\u00075r\u0007/\u0003\u0002p9\tIQI]4p-\u0006dW/\u001a\t\u0003cJd\u0001\u0001B\u0005t\u001d\u0005\u0005\t\u0011!B\u0001k\n\u0019q\fJ\u0019\u0002\u0017}\u0013XmZ5ti\u0016\u00148\u000fI\t\u0003mf\u0004\"AQ<\n\u0005a\u001c%a\u0002(pi\"Lgn\u001a\t\u0003\u0005jL!a_\"\u0003\u0007\u0005s\u00170\u0001\n`GJ,\u0017\r^5p]\"+\u0017n\u001a5u\u001fB$X#\u0001@\u0011\t\t{\u00181A\u0005\u0004\u0003\u0003\u0019%AB(qi&|g\u000eE\u0002C\u0003\u000bI1!a\u0002D\u0005\rIe\u000e^\u0001\u0017?\u000e\u0014X-\u0019;j_:DU-[4ii>\u0003Ho\u0018\u0013fcR\u0019\u0011*!\u0004\t\u000f5\u0003\u0012\u0011!a\u0001}\u0006\u0019rl\u0019:fCRLwN\u001c%fS\u001eDGo\u00149uA\u0005)a/\u00197vKR\u0019q'!\u0006\t\r\u0005E!\u00031\u0001B\u0003!\u0019wN\u001c;sC\u000e$HcA\u001c\u0002\u001c!1\u0011qC\nA\u0002E\u000ba\u0001^8lK:\u001cHcA\u001c\u0002\"!9\u0011Q\u0004\u000bA\u0002\u0005\r\u0002\u0003\u0002\"\u0002&\tL1!a\nD\u0005)a$/\u001a9fCR,GMP\u0001\n[&tG\u000fV8lK:$2\u0001LA\u0017\u0011\u001d\ty#\u0006a\u0001\u0003c\tQ\u0001^8lK:\u00042!LA\u001a\u0013\r\t)\u0004\b\u0002\n\u000b&\u0004H\u0007V8lK:\f\u0011B]3hSN$XM]:\u0015\u0007]\nY\u0004C\u0004\u00028Y\u0001\r!!\u0010\u0011\u000b\t\u000b)#a\u00101\t\u0005\u0005\u0013Q\t\t\u0005[9\f\u0019\u0005E\u0002r\u0003\u000b\"1\"a\u0012\u0002<\u0005\u0005\t\u0011!B\u0001k\n\u0019q\f\n\u001a\u0002\u001d\r\u0014X-\u0019;j_:DU-[4iiR\u0019A&!\u0014\t\u000f\u0005=s\u00031\u0001\u0002\u0004\u00051\u0001.Z5hQR\fQAY;jY\u0012$\"!!\u0016\u0011\u00075\n9&C\u0002\u0002Zq\u0011aaT;u\u0005>D\b")
public class OutBoxBuilderImpl
implements OutBoxBuilder {
    private final UnsignedTransactionBuilderImpl _txB;
    private final BlockchainContextImpl _ctx;
    private long _value;
    private ErgoContract _contract;
    private final ArrayBuffer<ErgoToken> _tokens;
    private final ArrayBuffer<ErgoValue<?>> _registers;
    private Option<Object> _creationHeightOpt;

    private BlockchainContextImpl _ctx() {
        return this._ctx;
    }

    private long _value() {
        return this._value;
    }

    private void _value_$eq(long x$1) {
        this._value = x$1;
    }

    private ErgoContract _contract() {
        return this._contract;
    }

    private void _contract_$eq(ErgoContract x$1) {
        this._contract = x$1;
    }

    private ArrayBuffer<ErgoToken> _tokens() {
        return this._tokens;
    }

    private ArrayBuffer<ErgoValue<?>> _registers() {
        return this._registers;
    }

    private Option<Object> _creationHeightOpt() {
        return this._creationHeightOpt;
    }

    private void _creationHeightOpt_$eq(Option<Object> x$1) {
        this._creationHeightOpt = x$1;
    }

    @Override
    public OutBoxBuilderImpl value(long value) {
        this._value_$eq(value);
        return this;
    }

    @Override
    public OutBoxBuilderImpl contract(ErgoContract contract) {
        this._contract_$eq(contract);
        return this;
    }

    public OutBoxBuilderImpl tokens(Seq<ErgoToken> tokens) {
        Predef$.MODULE$.require(tokens.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "At least one token should be specified");
        int maxTokens = BoxesRunTime.unboxToInt((Object)SigmaConstants.MaxTokens$.MODULE$.value());
        Predef$.MODULE$.require(tokens.size() <= maxTokens, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(SigmaConstants.MaxTokens$.MODULE$.description()).append(": ").append(maxTokens).toString());
        this._tokens().$plus$plus$eq(tokens);
        return this;
    }

    @Override
    public OutBoxBuilder mintToken(Eip4Token token) {
        ErgoValue<Coll<Byte>> tokenNameVal = token.getMintingBoxR4();
        ErgoValue<Coll<Byte>> tokenDescVal = token.getMintingBoxR5();
        ErgoValue<Coll<Byte>> tokenNumOfDecVal = token.getMintingBoxR6();
        this._registers().$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ErgoValue[]{tokenNameVal, tokenDescVal, tokenNumOfDecVal})));
        if (token.getMintingBoxR9() != null && token.getMintingBoxR8() == null) {
            throw new IllegalArgumentException("Invalid token: R9 cannot exist without R8");
        }
        if (token.getMintingBoxR8() != null && token.getMintingBoxR7() == null) {
            throw new IllegalArgumentException("Invalid token: R8 cannot exist without R7");
        }
        if (token.getMintingBoxR9() != null && token.getMintingBoxR7() == null) {
            throw new IllegalArgumentException("Invalid token: R9 cannot exist without R7");
        }
        this._registers().$plus$plus$eq((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{Option$.MODULE$.apply(token.getMintingBoxR7())})).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo)));
        this._registers().$plus$plus$eq((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{Option$.MODULE$.apply(token.getMintingBoxR8())})).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo)));
        this._registers().$plus$plus$eq((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{Option$.MODULE$.apply(token.getMintingBoxR9())})).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo)));
        this._tokens().$plus$eq((Object)token);
        return this;
    }

    public OutBoxBuilderImpl registers(Seq<ErgoValue<?>> registers) {
        Preconditions.checkArgument((boolean)registers.nonEmpty(), (Object)"At least one register should be specified");
        this._registers().clear();
        this._registers().$plus$plus$eq(registers);
        return this;
    }

    @Override
    public OutBoxBuilder creationHeight(int height) {
        this._creationHeightOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)height)));
        return this;
    }

    @Override
    public OutBox build() {
        Preconditions.checkState((this._contract() != null ? 1 : 0) != 0, (Object)"Contract is not defined");
        Values.ErgoTree tree = this._contract().getErgoTree();
        ErgoBoxCandidate ergoBoxCandidate = AppkitHelpers$.MODULE$.createBoxCandidate(this._value(), tree, (Seq<ErgoToken>)this._tokens().toSeq(), this._registers().toSeq(), BoxesRunTime.unboxToInt((Object)this._creationHeightOpt().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this._txB.getCtx().getHeight())));
        return new OutBoxImpl(ergoBoxCandidate);
    }

    @Override
    public OutBoxBuilderImpl registers(ErgoValue<?>[] registers) {
        return this.registers((Seq<ErgoValue<?>>)Predef$.MODULE$.wrapRefArray((Object[])registers));
    }

    @Override
    public OutBoxBuilderImpl tokens(ErgoToken[] tokens) {
        return this.tokens((Seq<ErgoToken>)Predef$.MODULE$.wrapRefArray((Object[])tokens));
    }

    public OutBoxBuilderImpl(UnsignedTransactionBuilderImpl _txB) {
        this._txB = _txB;
        this._ctx = (BlockchainContextImpl)_txB.getCtx();
        this._value = 0L;
        this._tokens = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this._registers = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this._creationHeightOpt = None$.MODULE$;
    }
}

