/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ergoplatform.ErgoBoxCandidate;
import org.ergoplatform.UnsignedInput;
import org.ergoplatform.appkit.AppkitHelpers;
import org.ergoplatform.appkit.OutBox;
import org.ergoplatform.appkit.ReducedTransaction;
import org.ergoplatform.appkit.impl.BlockchainContextBase;
import org.ergoplatform.appkit.impl.OutBoxImpl;
import org.ergoplatform.sdk.ErgoId;
import org.ergoplatform.sdk.ReducedErgoLikeTransaction;
import org.ergoplatform.sdk.ReducedErgoLikeTransactionSerializer;
import sigmastate.serialization.SigmaSerializer;
import sigmastate.utils.SigmaByteWriter;

public class ReducedTransactionImpl
implements ReducedTransaction {
    private final BlockchainContextBase _ctx;
    private final ReducedErgoLikeTransaction _tx;

    public ReducedTransactionImpl(BlockchainContextBase blockchainContextBase, ReducedErgoLikeTransaction reducedErgoLikeTransaction) {
        this._ctx = blockchainContextBase;
        this._tx = reducedErgoLikeTransaction;
    }

    @Override
    public String getId() {
        return this.getTx().unsignedTx().id();
    }

    @Override
    public List<String> getInputBoxesIds() {
        List<UnsignedInput> list = AppkitHelpers.toJavaList(this.getTx().unsignedTx().inputs());
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (UnsignedInput unsignedInput : list) {
            arrayList.add(new ErgoId(unsignedInput.boxId()).toString());
        }
        return arrayList;
    }

    @Override
    public List<OutBox> getOutputs() {
        List<ErgoBoxCandidate> list = AppkitHelpers.toJavaList(this._tx.unsignedTx().outputs());
        ArrayList<OutBox> arrayList = new ArrayList<OutBox>(list.size());
        for (ErgoBoxCandidate ergoBoxCandidate : list) {
            arrayList.add(new OutBoxImpl(ergoBoxCandidate));
        }
        return arrayList;
    }

    @Override
    public ReducedErgoLikeTransaction getTx() {
        return this._tx;
    }

    @Override
    public int getCost() {
        return this._tx.cost();
    }

    @Override
    public byte[] toBytes() {
        SigmaByteWriter sigmaByteWriter = SigmaSerializer.startWriter();
        ReducedErgoLikeTransactionSerializer.serialize((ReducedErgoLikeTransaction)this._tx, (SigmaByteWriter)sigmaByteWriter);
        return sigmaByteWriter.toBytes();
    }

    public int hashCode() {
        return this._tx.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ReducedTransactionImpl) {
            ReducedTransactionImpl reducedTransactionImpl = (ReducedTransactionImpl)object;
            return Objects.equals(reducedTransactionImpl._tx, this._tx);
        }
        return false;
    }

    public String toString() {
        return "ReducedTransactionImpl(\n" + this._tx + ",\n" + this.getCost() + "\n)";
    }
}

