/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import java.util.List;
import org.ergoplatform.explorer.client.model.Items;
import org.ergoplatform.explorer.client.model.TotalBalance;
import org.ergoplatform.restapi.client.BlockchainIndexHeight;
import org.ergoplatform.restapi.client.BlockchainToken;
import org.ergoplatform.restapi.client.BlockchainTransaction;
import org.ergoplatform.restapi.client.ErgoTransactionOutput;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface BlockchainApi {
    public static final String sortDirectionOldestFirst = "asc";
    public static final String sortDirectionNewestFirst = "desc";

    @GET(value="blockchain/indexedHeight")
    public Call<BlockchainIndexHeight> getBlockchainIndexHeight();

    @GET(value="blockchain/box/byId/{boxId}")
    public Call<ErgoTransactionOutput> getBoxById(@Path(value="boxId") String var1);

    @POST(value="blockchain/box/unspent/byAddress/")
    public Call<List<ErgoTransactionOutput>> getUnspentBoxesByAddress(@Body String var1, @Query(value="limit") Integer var2, @Query(value="offset") Integer var3, @Query(value="sortDirection") String var4);

    @POST(value="blockchain/box/unspent/byErgoTree/")
    public Call<List<ErgoTransactionOutput>> getUnspentBoxesByErgoTree(@Body String var1, @Query(value="limit") Integer var2, @Query(value="offset") Integer var3, @Query(value="sortDirection") String var4);

    @GET(value="blockchain/transaction/byId/{txId}")
    public Call<BlockchainTransaction> getTxById(@Path(value="txId") String var1);

    @GET(value="blockchain/transaction/byIndex/{txIdx}")
    public Call<BlockchainTransaction> getTxByIndex(@Path(value="txIdx") String var1);

    @POST(value="blockchain/transaction/byAddress/")
    public Call<Items<BlockchainTransaction>> getTransactionsByAddress(@Body String var1, @Query(value="limit") Integer var2, @Query(value="offset") Integer var3);

    @GET(value="blockchain/token/byId/{tokenId}")
    public Call<BlockchainToken> getTokenById(@Path(value="tokenId") String var1);

    @POST(value="blockchain/balance/")
    public Call<TotalBalance> getBalance(@Body String var1);
}

