/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Objects;
import org.ergoplatform.restapi.client.Parameters;

public class NodeInfo {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="appVersion")
    private String appVersion = null;
    @SerializedName(value="fullHeight")
    private Integer fullHeight = null;
    @SerializedName(value="headersHeight")
    private Integer headersHeight = null;
    @SerializedName(value="bestFullHeaderId")
    private String bestFullHeaderId = null;
    @SerializedName(value="previousFullHeaderId")
    private String previousFullHeaderId = null;
    @SerializedName(value="bestHeaderId")
    private String bestHeaderId = null;
    @SerializedName(value="stateRoot")
    private String stateRoot = null;
    @SerializedName(value="network")
    private String network = null;
    @SerializedName(value="stateType")
    private StateTypeEnum stateType = null;
    @SerializedName(value="stateVersion")
    private String stateVersion = null;
    @SerializedName(value="isMining")
    private Boolean isMining = null;
    @SerializedName(value="peersCount")
    private Integer peersCount = null;
    @SerializedName(value="unconfirmedCount")
    private Integer unconfirmedCount = null;
    @SerializedName(value="difficulty")
    private BigInteger difficulty = null;
    @SerializedName(value="currentTime")
    private Long currentTime = null;
    @SerializedName(value="launchTime")
    private Long launchTime = null;
    @SerializedName(value="headersScore")
    private BigInteger headersScore = null;
    @SerializedName(value="fullBlocksScore")
    private BigInteger fullBlocksScore = null;
    @SerializedName(value="genesisBlockId")
    private String genesisBlockId = null;
    @SerializedName(value="restApiUrl")
    private String restApiUrl = null;
    @SerializedName(value="parameters")
    private Parameters parameters = null;
    @SerializedName(value="isExplorer")
    private boolean isExplorer = false;

    public NodeInfo name(String string) {
        this.name = string;
        return this;
    }

    @Schema(example="my-node-1", required=true, description="")
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public NodeInfo appVersion(String string) {
        this.appVersion = string;
        return this;
    }

    @Schema(example="0.0.1", required=true, description="")
    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String string) {
        this.appVersion = string;
    }

    public NodeInfo fullHeight(Integer n) {
        this.fullHeight = n;
        return this;
    }

    @Schema(example="667", required=true, description="Can be 'null' if state is empty (no full block is applied since node launch)")
    public Integer getFullHeight() {
        return this.fullHeight;
    }

    public void setFullHeight(Integer n) {
        this.fullHeight = n;
    }

    public NodeInfo headersHeight(Integer n) {
        this.headersHeight = n;
        return this;
    }

    @Schema(example="667", required=true, description="Can be 'null' if state is empty (no header applied since node launch)")
    public Integer getHeadersHeight() {
        return this.headersHeight;
    }

    public void setHeadersHeight(Integer n) {
        this.headersHeight = n;
    }

    public NodeInfo bestFullHeaderId(String string) {
        this.bestFullHeaderId = string;
        return this;
    }

    @Schema(required=true, description="Can be 'null' if no full block is applied since node launch")
    public String getBestFullHeaderId() {
        return this.bestFullHeaderId;
    }

    public void setBestFullHeaderId(String string) {
        this.bestFullHeaderId = string;
    }

    public NodeInfo previousFullHeaderId(String string) {
        this.previousFullHeaderId = string;
        return this;
    }

    @Schema(required=true, description="Can be 'null' if no full block is applied since node launch")
    public String getPreviousFullHeaderId() {
        return this.previousFullHeaderId;
    }

    public void setPreviousFullHeaderId(String string) {
        this.previousFullHeaderId = string;
    }

    public NodeInfo bestHeaderId(String string) {
        this.bestHeaderId = string;
        return this;
    }

    @Schema(required=true, description="Can be 'null' if no header applied since node launch")
    public String getBestHeaderId() {
        return this.bestHeaderId;
    }

    public void setBestHeaderId(String string) {
        this.bestHeaderId = string;
    }

    public NodeInfo stateRoot(String string) {
        this.stateRoot = string;
        return this;
    }

    @Schema(example="dab9da11fc216660e974842cc3b7705e62ebb9e0bf5ff78e53f9cd40abadd117", required=true, description="Can be 'null' if state is empty (no full block is applied since node launch)")
    public String getStateRoot() {
        return this.stateRoot;
    }

    public void setStateRoot(String string) {
        this.stateRoot = string;
    }

    public NodeInfo stateType(StateTypeEnum stateTypeEnum) {
        this.stateType = stateTypeEnum;
        return this;
    }

    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String string) {
        this.network = string;
    }

    @Schema(required=true, description="")
    public StateTypeEnum getStateType() {
        return this.stateType;
    }

    public void setStateType(StateTypeEnum stateTypeEnum) {
        this.stateType = stateTypeEnum;
    }

    public NodeInfo stateVersion(String string) {
        this.stateVersion = string;
        return this;
    }

    @Schema(example="fab9da11fc216660e974842cc3b7705e62ebb9e0bf5ff78e53f9cd40abadd117", required=true, description="Can be 'null' if no full block is applied since node launch")
    public String getStateVersion() {
        return this.stateVersion;
    }

    public void setStateVersion(String string) {
        this.stateVersion = string;
    }

    public NodeInfo isMining(Boolean bl) {
        this.isMining = bl;
        return this;
    }

    @Schema(example="true", required=true, description="")
    public Boolean isIsMining() {
        return this.isMining;
    }

    public void setIsMining(Boolean bl) {
        this.isMining = bl;
    }

    public NodeInfo peersCount(Integer n) {
        this.peersCount = n;
        return this;
    }

    @Schema(example="327", required=true, description="Number of connected peers")
    public Integer getPeersCount() {
        return this.peersCount;
    }

    public void setPeersCount(Integer n) {
        this.peersCount = n;
    }

    public NodeInfo unconfirmedCount(Integer n) {
        this.unconfirmedCount = n;
        return this;
    }

    @Schema(example="327", required=true, description="Current unconfirmed transactions count")
    public Integer getUnconfirmedCount() {
        return this.unconfirmedCount;
    }

    public void setUnconfirmedCount(Integer n) {
        this.unconfirmedCount = n;
    }

    public NodeInfo difficulty(BigInteger bigInteger) {
        this.difficulty = bigInteger;
        return this;
    }

    @Schema(example="667", required=true, description="Difficulty on current bestFullHeaderId. Can be 'null' if no full block is applied since node launch")
    public BigInteger getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(BigInteger bigInteger) {
        this.difficulty = bigInteger;
    }

    public NodeInfo currentTime(Long l) {
        this.currentTime = l;
        return this;
    }

    @Schema(required=true, description="Current internal node time")
    public Long getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(Long l) {
        this.currentTime = l;
    }

    public NodeInfo launchTime(Long l) {
        this.launchTime = l;
        return this;
    }

    public boolean isExplorer() {
        return this.isExplorer;
    }

    public void setExplorer(boolean bl) {
        this.isExplorer = bl;
    }

    @Schema(required=true, description="Time when the node was started")
    public Long getLaunchTime() {
        return this.launchTime;
    }

    public void setLaunchTime(Long l) {
        this.launchTime = l;
    }

    public NodeInfo headersScore(BigInteger bigInteger) {
        this.headersScore = bigInteger;
        return this;
    }

    @Schema(required=true, description="Can be 'null' if no headers is applied since node launch")
    public BigInteger getHeadersScore() {
        return this.headersScore;
    }

    public void setHeadersScore(BigInteger bigInteger) {
        this.headersScore = bigInteger;
    }

    public NodeInfo fullBlocksScore(BigInteger bigInteger) {
        this.fullBlocksScore = bigInteger;
        return this;
    }

    @Schema(required=true, description="Can be 'null' if no full block is applied since node launch")
    public BigInteger getFullBlocksScore() {
        return this.fullBlocksScore;
    }

    public void setFullBlocksScore(BigInteger bigInteger) {
        this.fullBlocksScore = bigInteger;
    }

    public NodeInfo genesisBlockId(String string) {
        this.genesisBlockId = string;
        return this;
    }

    @Schema(required=true, description="Can be 'null' if genesis blocks is not produced yet")
    public String getGenesisBlockId() {
        return this.genesisBlockId;
    }

    public void setGenesisBlockId(String string) {
        this.genesisBlockId = string;
    }

    public String getRestApiUrl() {
        return this.restApiUrl;
    }

    public void setRestApiUrl(String string) {
        this.restApiUrl = string;
    }

    public NodeInfo parameters(Parameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Schema(required=true, description="")
    public Parameters getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NodeInfo nodeInfo = (NodeInfo)object;
        return Objects.equals(this.name, nodeInfo.name) && Objects.equals(this.appVersion, nodeInfo.appVersion) && Objects.equals(this.fullHeight, nodeInfo.fullHeight) && Objects.equals(this.headersHeight, nodeInfo.headersHeight) && Objects.equals(this.bestFullHeaderId, nodeInfo.bestFullHeaderId) && Objects.equals(this.previousFullHeaderId, nodeInfo.previousFullHeaderId) && Objects.equals(this.bestHeaderId, nodeInfo.bestHeaderId) && Objects.equals(this.stateRoot, nodeInfo.stateRoot) && Objects.equals((Object)this.stateType, (Object)nodeInfo.stateType) && Objects.equals(this.stateVersion, nodeInfo.stateVersion) && Objects.equals(this.isMining, nodeInfo.isMining) && Objects.equals(this.peersCount, nodeInfo.peersCount) && Objects.equals(this.unconfirmedCount, nodeInfo.unconfirmedCount) && Objects.equals(this.difficulty, nodeInfo.difficulty) && Objects.equals(this.currentTime, nodeInfo.currentTime) && Objects.equals(this.launchTime, nodeInfo.launchTime) && Objects.equals(this.headersScore, nodeInfo.headersScore) && Objects.equals(this.fullBlocksScore, nodeInfo.fullBlocksScore) && Objects.equals(this.genesisBlockId, nodeInfo.genesisBlockId) && Objects.equals(this.restApiUrl, nodeInfo.restApiUrl) && Objects.equals(this.isExplorer, nodeInfo.isExplorer) && Objects.equals(this.parameters, nodeInfo.parameters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.appVersion, this.fullHeight, this.headersHeight, this.bestFullHeaderId, this.previousFullHeaderId, this.bestHeaderId, this.stateRoot, this.stateType, this.stateVersion, this.isMining, this.peersCount, this.unconfirmedCount, this.difficulty, this.currentTime, this.launchTime, this.headersScore, this.fullBlocksScore, this.genesisBlockId, this.restApiUrl, this.parameters, this.isExplorer});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class NodeInfo {\n");
        stringBuilder.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        stringBuilder.append("    appVersion: ").append(this.toIndentedString(this.appVersion)).append("\n");
        stringBuilder.append("    fullHeight: ").append(this.toIndentedString(this.fullHeight)).append("\n");
        stringBuilder.append("    headersHeight: ").append(this.toIndentedString(this.headersHeight)).append("\n");
        stringBuilder.append("    bestFullHeaderId: ").append(this.toIndentedString(this.bestFullHeaderId)).append("\n");
        stringBuilder.append("    previousFullHeaderId: ").append(this.toIndentedString(this.previousFullHeaderId)).append("\n");
        stringBuilder.append("    bestHeaderId: ").append(this.toIndentedString(this.bestHeaderId)).append("\n");
        stringBuilder.append("    stateRoot: ").append(this.toIndentedString(this.stateRoot)).append("\n");
        stringBuilder.append("    stateType: ").append(this.toIndentedString((Object)this.stateType)).append("\n");
        stringBuilder.append("    stateVersion: ").append(this.toIndentedString(this.stateVersion)).append("\n");
        stringBuilder.append("    isMining: ").append(this.toIndentedString(this.isMining)).append("\n");
        stringBuilder.append("    peersCount: ").append(this.toIndentedString(this.peersCount)).append("\n");
        stringBuilder.append("    unconfirmedCount: ").append(this.toIndentedString(this.unconfirmedCount)).append("\n");
        stringBuilder.append("    difficulty: ").append(this.toIndentedString(this.difficulty)).append("\n");
        stringBuilder.append("    currentTime: ").append(this.toIndentedString(this.currentTime)).append("\n");
        stringBuilder.append("    launchTime: ").append(this.toIndentedString(this.launchTime)).append("\n");
        stringBuilder.append("    headersScore: ").append(this.toIndentedString(this.headersScore)).append("\n");
        stringBuilder.append("    fullBlocksScore: ").append(this.toIndentedString(this.fullBlocksScore)).append("\n");
        stringBuilder.append("    genesisBlockId: ").append(this.toIndentedString(this.genesisBlockId)).append("\n");
        stringBuilder.append("    restApiUrl: ").append(this.toIndentedString(this.restApiUrl)).append("\n");
        stringBuilder.append("    isExplorer: ").append(this.toIndentedString(this.isExplorer)).append("\n");
        stringBuilder.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateTypeEnum {
        DIGEST("digest"),
        UTXO("utxo");

        private String value;

        private StateTypeEnum(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateTypeEnum fromValue(String string) {
            for (StateTypeEnum stateTypeEnum : StateTypeEnum.values()) {
                if (!String.valueOf(stateTypeEnum.value).equals(string)) continue;
                return stateTypeEnum;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StateTypeEnum> {
            public void write(JsonWriter jsonWriter, StateTypeEnum stateTypeEnum) throws IOException {
                jsonWriter.value(stateTypeEnum.getValue());
            }

            public StateTypeEnum read(JsonReader jsonReader) throws IOException {
                String string = jsonReader.nextString();
                return StateTypeEnum.fromValue(String.valueOf(string));
            }
        }
    }
}

