/*
 * Ergo Node API
 * API docs for Ergo Node. Models are shared between all Ergo products
 *
 * OpenAPI spec version: 4.0.12
 * Contact: ergoplatform@protonmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.ergoplatform.restapi.client;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * Hex-encoded big-endian 256-bits secret exponent \&quot;w\&quot; along with generators \&quot;g\&quot;, \&quot;h\&quot;, and group elements \&quot;u\&quot;, \&quot;v\&quot;, such as g^w &#x3D; u, h^w &#x3D; v
 */
@Schema(description = "Hex-encoded big-endian 256-bits secret exponent \"w\" along with generators \"g\", \"h\", and group elements \"u\", \"v\", such as g^w = u, h^w = v")

public class DhtSecret {
  @SerializedName("secret")
  private String secret = null;

  @SerializedName("g")
  private String g = null;

  @SerializedName("h")
  private String h = null;

  @SerializedName("u")
  private String u = null;

  @SerializedName("v")
  private String v = null;

  public DhtSecret secret(String secret) {
    this.secret = secret;
    return this;
  }

   /**
   * Hex-encoded big-endian 256-bits secret exponent
   * @return secret
  **/
  @Schema(example = "433080ff80d0d52d7f8bfffff47f00807f44f680000949b800007f7f7ff1017f", required = true, description = "Hex-encoded big-endian 256-bits secret exponent")
  public String getSecret() {
    return secret;
  }

  public void setSecret(String secret) {
    this.secret = secret;
  }

  public DhtSecret g(String g) {
    this.g = g;
    return this;
  }

   /**
   * Hex-encoded \&quot;g\&quot; generator for the Diffie-Hellman tuple (secp256k1 curve point)
   * @return g
  **/
  @Schema(example = "02a7955281885bf0f0ca4a48678848cad8dc5b328ce8bc1d4481d041c98e891ff3", required = true, description = "Hex-encoded \"g\" generator for the Diffie-Hellman tuple (secp256k1 curve point)")
  public String getG() {
    return g;
  }

  public void setG(String g) {
    this.g = g;
  }

  public DhtSecret h(String h) {
    this.h = h;
    return this;
  }

   /**
   * Hex-encoded \&quot;h\&quot; generator for the Diffie-Hellman tuple (secp256k1 curve point)
   * @return h
  **/
  @Schema(example = "02a7955281885bf0f0ca4a48678848cad8dc5b328ce8bc1d4481d041c98e891ff3", required = true, description = "Hex-encoded \"h\" generator for the Diffie-Hellman tuple (secp256k1 curve point)")
  public String getH() {
    return h;
  }

  public void setH(String h) {
    this.h = h;
  }

  public DhtSecret u(String u) {
    this.u = u;
    return this;
  }

   /**
   * Hex-encoded \&quot;u\&quot; group element of the Diffie-Hellman tuple (secp256k1 curve point)
   * @return u
  **/
  @Schema(example = "02a7955281885bf0f0ca4a48678848cad8dc5b328ce8bc1d4481d041c98e891ff3", required = true, description = "Hex-encoded \"u\" group element of the Diffie-Hellman tuple (secp256k1 curve point)")
  public String getU() {
    return u;
  }

  public void setU(String u) {
    this.u = u;
  }

  public DhtSecret v(String v) {
    this.v = v;
    return this;
  }

   /**
   * Hex-encoded \&quot;v\&quot; group element of the Diffie-Hellman tuple (secp256k1 curve point)
   * @return v
  **/
  @Schema(example = "02a7955281885bf0f0ca4a48678848cad8dc5b328ce8bc1d4481d041c98e891ff3", required = true, description = "Hex-encoded \"v\" group element of the Diffie-Hellman tuple (secp256k1 curve point)")
  public String getV() {
    return v;
  }

  public void setV(String v) {
    this.v = v;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DhtSecret dhtSecret = (DhtSecret) o;
    return Objects.equals(this.secret, dhtSecret.secret) &&
        Objects.equals(this.g, dhtSecret.g) &&
        Objects.equals(this.h, dhtSecret.h) &&
        Objects.equals(this.u, dhtSecret.u) &&
        Objects.equals(this.v, dhtSecret.v);
  }

  @Override
  public int hashCode() {
    return Objects.hash(secret, g, h, u, v);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DhtSecret {\n");
    
    sb.append("    secret: ").append(toIndentedString(secret)).append("\n");
    sb.append("    g: ").append(toIndentedString(g)).append("\n");
    sb.append("    h: ").append(toIndentedString(h)).append("\n");
    sb.append("    u: ").append(toIndentedString(u)).append("\n");
    sb.append("    v: ").append(toIndentedString(v)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
