/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import org.bouncycastle.jcajce.provider.digest.RIPEMD160;
import org.ergoplatform.appkit.NetworkType;
import org.ergoplatform.sdk.JavaHelpers;
import org.ergoplatform.sdk.wallet.Constants;
import org.ergoplatform.sdk.wallet.secrets.DerivationPath;
import org.ergoplatform.sdk.wallet.secrets.ExtendedPublicKey;
import org.ergoplatform.sdk.wallet.secrets.ExtendedSecretKey;
import scala.collection.Seq;
import scorex.crypto.hash.Sha256;
import scorex.util.encode.Base16;

public class Bip32Serialization {
    public static String serializeExtendedPublicKeyToHex(ExtendedSecretKey extendedSecretKey, NetworkType networkType) {
        byte[] byArray = Bip32Serialization.serializeExtendedPublicKeyBip32(extendedSecretKey, networkType);
        return Base16.encode((byte[])byArray);
    }

    public static byte[] serializeExtendedPublicKeyBip32(ExtendedSecretKey extendedSecretKey, NetworkType networkType) {
        if (extendedSecretKey.path().depth() > 1) {
            throw new IllegalArgumentException("Master key expected for serialization");
        }
        DerivationPath derivationPath = JavaHelpers.eip3DerivationParent();
        ExtendedPublicKey extendedPublicKey = ((ExtendedSecretKey)extendedSecretKey.derive(derivationPath)).publicKey();
        ExtendedPublicKey extendedPublicKey2 = ((ExtendedSecretKey)extendedSecretKey.derive(new DerivationPath((Seq)((scala.collection.immutable.Seq)derivationPath.decodedPath().dropRight(1)), extendedSecretKey.path().publicBranch()))).publicKey();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(Bip32Serialization.getPublicHeader(networkType), 0, 4);
        byteArrayOutputStream.write((byte)(extendedPublicKey.path().depth() - 1));
        byteArrayOutputStream.write(Bip32Serialization.calculateFingerPrint(extendedPublicKey2.keyBytes()), 0, 4);
        byteArrayOutputStream.write(new byte[]{0, 0, 0, 0}, 0, 4);
        byteArrayOutputStream.write(extendedPublicKey.chainCode(), 0, 32);
        byteArrayOutputStream.write(extendedPublicKey.keyBytes(), 0, 33);
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] calculateFingerPrint(byte[] byArray) {
        byte[] byArray2 = Sha256.hash((byte[])byArray);
        return Arrays.copyOfRange(new RIPEMD160.Digest().digest(byArray2), 0, 4);
    }

    private static byte[] getPublicHeader(NetworkType networkType) {
        if (networkType == NetworkType.MAINNET) {
            return new byte[]{4, -120, -78, 30};
        }
        return new byte[]{4, 53, -121, -49};
    }

    public static ExtendedPublicKey parseExtendedPublicKeyFromHex(String string, NetworkType networkType) {
        byte[] byArray = (byte[])Base16.decode((String)string).get();
        return Bip32Serialization.parseExtendedPublicKey(byArray, networkType);
    }

    public static ExtendedPublicKey parseExtendedPublicKey(byte[] byArray, NetworkType networkType) {
        if (byArray.length != 78) {
            throw new IllegalArgumentException("xpubkey should have length of 78 bytes.");
        }
        if (!Arrays.equals(Bip32Serialization.getPublicHeader(networkType), Arrays.copyOfRange(byArray, 0, 4))) {
            throw new IllegalArgumentException("Given xpubkey did not start with expected version bytes.");
        }
        return new ExtendedPublicKey(Arrays.copyOfRange(byArray, 45, 78), Arrays.copyOfRange(byArray, 13, 45), new DerivationPath((Seq)((scala.collection.immutable.Seq)Constants.eip3DerivationPath().decodedPath().dropRight(1)), true));
    }
}

