/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.util.Arrays;
import org.ergoplatform.appkit.BoxAttachment;
import org.ergoplatform.appkit.BoxAttachmentMulti;
import org.ergoplatform.appkit.BoxAttachmentPlainText;
import org.ergoplatform.appkit.ErgoValue;
import org.ergoplatform.appkit.ScalaHelpers;
import org.ergoplatform.sdk.JavaHelpers;
import scala.Tuple2;
import sigma.Coll;

public class BoxAttachmentGeneric
implements BoxAttachment {
    private final int attachmentType;
    private final byte[] attachmentContent;

    BoxAttachmentGeneric(int n, byte[] byArray) {
        this.attachmentType = n;
        this.attachmentContent = byArray;
    }

    @Override
    public BoxAttachment.Type getType() {
        return BoxAttachment.Type.fromTypeRawValue(this.attachmentType);
    }

    @Override
    public int getTypeRawValue() {
        return this.attachmentType;
    }

    @Override
    public ErgoValue<Tuple2<Coll<Byte>, Tuple2<Integer, Coll<Byte>>>> getErgoValue() {
        ErgoValue<Tuple2<Integer, Coll<Byte>>> ergoValue = ErgoValue.pairOf(ErgoValue.of(this.getTypeRawValue()), ErgoValue.of(this.attachmentContent));
        return ErgoValue.pairOf(ErgoValue.of(BoxAttachment.MAGIC_BYTES), ergoValue);
    }

    @Override
    public ErgoValue<?>[] getOutboxRegistersForAttachment() {
        ErgoValue[] ergoValueArray = new ErgoValue[6];
        for (int i = 0; i < ergoValueArray.length - 1; ++i) {
            ergoValueArray[i] = ErgoValue.unit();
        }
        ergoValueArray[5] = this.getErgoValue();
        return ergoValueArray;
    }

    public static BoxAttachment createFromErgoValue(ErgoValue<?> ergoValue) {
        String string = "R9 must be of pair (Coll[0x50, 0x52, 0x50], Tuple2(Int, Coll[Byte]), actual: ";
        if (!(ergoValue.getValue() instanceof Tuple2)) {
            throw new IllegalArgumentException(string + ergoValue.getValue().getClass().getSimpleName());
        }
        Tuple2 tuple2 = (Tuple2)ergoValue.getValue();
        if (!(tuple2._1 instanceof Coll) || !(tuple2._2 instanceof Tuple2)) {
            throw new IllegalArgumentException(string + ergoValue.getType().toString());
        }
        byte[] byArray = JavaHelpers.collToByteArray((Coll)((Coll)tuple2._1));
        if (!Arrays.equals(BoxAttachment.MAGIC_BYTES, byArray)) {
            throw new IllegalArgumentException(string + "Magic bytes not matched.");
        }
        Tuple2 tuple22 = (Tuple2)tuple2._2;
        if (!(tuple22._1 instanceof Integer) || !(tuple22._2 instanceof Coll)) {
            throw new IllegalArgumentException(string + ergoValue.getType());
        }
        return BoxAttachmentGeneric.createFromAttachmentTuple((Tuple2<Integer, Coll<Byte>>)tuple22);
    }

    static BoxAttachment createFromAttachmentTuple(Tuple2<Integer, Coll<Byte>> tuple2) {
        Integer n = (Integer)tuple2._1;
        BoxAttachment.Type type = BoxAttachment.Type.fromTypeRawValue(n);
        byte[] byArray = ScalaHelpers.collByteToByteArray((Coll<Byte>)((Coll)tuple2._2));
        switch (type) {
            case PLAIN_TEXT: {
                return new BoxAttachmentPlainText(byArray);
            }
            case MULTI_ATTACHMENT: {
                return new BoxAttachmentMulti(byArray);
            }
        }
        return new BoxAttachmentGeneric(n, byArray);
    }
}

