/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ergoplatform.ErgoAddress;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.BlockchainContext;
import org.ergoplatform.appkit.BoxAttachment;
import org.ergoplatform.appkit.BoxAttachmentPlainText;
import org.ergoplatform.appkit.CoveringBoxes;
import org.ergoplatform.appkit.Eip4Token;
import org.ergoplatform.appkit.ErgoContract;
import org.ergoplatform.appkit.ErgoProver;
import org.ergoplatform.appkit.ErgoProverBuilder;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.InputBoxesSelectionException;
import org.ergoplatform.appkit.InputBoxesValidatorJavaHelper;
import org.ergoplatform.appkit.Mnemonic;
import org.ergoplatform.appkit.OutBox;
import org.ergoplatform.appkit.OutBoxBuilder;
import org.ergoplatform.appkit.SecretStorage;
import org.ergoplatform.appkit.SelectTokensHelper;
import org.ergoplatform.appkit.SignedTransaction;
import org.ergoplatform.appkit.UnsignedTransaction;
import org.ergoplatform.appkit.UnsignedTransactionBuilder;
import org.ergoplatform.sdk.ErgoToken;
import org.ergoplatform.sdk.SecretString;

public class BoxOperations {
    private final BlockchainContext ctx;
    private final List<Address> senders;
    private final ErgoProver senderProver;
    private long amountToSpend = 0L;
    private List<ErgoToken> tokensToSpend = Collections.emptyList();
    private long feeAmount = 1000000L;
    private IUnspentBoxesLoader inputBoxesLoader = new ExplorerApiUnspentLoader();
    private BoxAttachment attachment;
    private int maxInputBoxesToSelect = 0;
    private static final long CHANGE_BOX_NANOERG = 1000000L;

    BoxOperations(BlockchainContext blockchainContext, List<Address> list, @Nullable ErgoProver ergoProver) {
        this.ctx = blockchainContext;
        this.senders = list;
        this.senderProver = ergoProver;
    }

    public static BoxOperations createForSender(Address address, BlockchainContext blockchainContext) {
        return BoxOperations.createForSenders(Collections.singletonList(address), blockchainContext);
    }

    public static BoxOperations createForSenders(List<Address> list, BlockchainContext blockchainContext) {
        return new BoxOperations(blockchainContext, list, null);
    }

    public static BoxOperations createForEip3Prover(ErgoProver ergoProver, BlockchainContext blockchainContext) {
        List<Address> list = ergoProver.getEip3Addresses();
        Preconditions.checkState((list.size() > 0 ? 1 : 0) != 0, (Object)"EIP-3 addresses are not derived in the prover (use ErgoProverBuilder.withEip3Secret)");
        return new BoxOperations(blockchainContext, list, ergoProver);
    }

    public static BoxOperations createForProver(ErgoProver ergoProver, BlockchainContext blockchainContext) {
        return new BoxOperations(blockchainContext, Collections.singletonList(ergoProver.getAddress()), ergoProver);
    }

    public BoxOperations withAmountToSpend(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Amount to send must be >= 0");
        }
        this.amountToSpend = l;
        return this;
    }

    public BoxOperations withTokensToSpend(@Nonnull List<ErgoToken> list) {
        this.tokensToSpend = list;
        return this;
    }

    public BoxOperations withFeeAmount(long l) {
        if (l < 1000000L) {
            throw new IllegalArgumentException("Amount to send must be >= 1000000");
        }
        this.feeAmount = l;
        return this;
    }

    public BoxOperations withAttachment(@Nullable BoxAttachment boxAttachment) {
        this.attachment = boxAttachment;
        return this;
    }

    public int getMaxInputBoxesToSelect() {
        return this.maxInputBoxesToSelect;
    }

    public BoxOperations withMaxInputBoxesToSelect(int n) {
        this.maxInputBoxesToSelect = n;
        return this;
    }

    public BoxOperations withMessage(@Nullable String string) {
        if (string != null) {
            this.withAttachment(BoxAttachmentPlainText.buildForText(string));
        } else {
            this.withAttachment(null);
        }
        return this;
    }

    public BoxOperations withInputBoxesLoader(@Nonnull IUnspentBoxesLoader iUnspentBoxesLoader) {
        this.inputBoxesLoader = iUnspentBoxesLoader;
        return this;
    }

    public BlockchainContext getBlockchainContext() {
        return this.ctx;
    }

    public List<Address> getSenders() {
        return this.senders;
    }

    public long getAmountToSpend() {
        return this.amountToSpend;
    }

    public List<ErgoToken> getTokensToSpend() {
        return this.tokensToSpend;
    }

    public long getFeeAmount() {
        return this.feeAmount;
    }

    @Deprecated
    public static ErgoProver createProver(BlockchainContext blockchainContext, Mnemonic mnemonic, Boolean bl) {
        ErgoProver ergoProver = blockchainContext.newProverBuilder().withMnemonic(mnemonic.getPhrase(), mnemonic.getPassword(), bl).build();
        return ergoProver;
    }

    @Deprecated
    public static ErgoProverBuilder createProver(BlockchainContext blockchainContext, String string, SecretString secretString) {
        return BoxOperations.createProver(blockchainContext, string, secretString.toStringUnsecure());
    }

    @Deprecated
    public static ErgoProverBuilder createProver(BlockchainContext blockchainContext, String string, String string2) {
        SecretStorage secretStorage = SecretStorage.loadFrom(string);
        secretStorage.unlock(string2);
        ErgoProverBuilder ergoProverBuilder = blockchainContext.newProverBuilder().withSecretStorage(secretStorage);
        return ergoProverBuilder;
    }

    public String send(Address address) {
        ErgoContract ergoContract = address.toErgoContract();
        SignedTransaction signedTransaction = this.putToContractTx(ergoContract);
        this.ctx.sendTransaction(signedTransaction);
        return signedTransaction.toJson(true);
    }

    public List<InputBox> loadTop() {
        return this.loadTop(0L);
    }

    public List<InputBox> loadTop(long l) {
        long l2;
        ArrayList<InputBox> arrayList = new ArrayList<InputBox>();
        long l3 = l2 = this.amountToSpend + this.feeAmount - l;
        boolean bl = false;
        SelectTokensHelper selectTokensHelper = new SelectTokensHelper(this.tokensToSpend);
        List<ErgoToken> list = this.tokensToSpend;
        this.inputBoxesLoader.prepare(this.ctx, this.senders, l2, this.tokensToSpend);
        for (Address address : this.senders) {
            this.inputBoxesLoader.prepareForAddress(address);
            CoveringBoxes coveringBoxes = BoxOperations.getCoveringBoxesFor(l3, list, bl, n -> this.inputBoxesLoader.loadBoxesPage(this.ctx, address, (Integer)n), this.maxInputBoxesToSelect <= 0 ? 0 : Math.max(1, this.maxInputBoxesToSelect - arrayList.size()));
            if (!bl && coveringBoxes.isChangeBoxNeeded()) {
                bl = true;
                l3 += 1000000L;
            }
            for (InputBox inputBox : coveringBoxes.getBoxes()) {
                arrayList.add(inputBox);
                selectTokensHelper.useTokens(inputBox.getTokens());
                if ((l3 -= inputBox.getValue()) > 0L || !selectTokensHelper.areTokensCovered()) continue;
                break;
            }
            if (l3 <= 0L && selectTokensHelper.areTokensCovered()) break;
            list = selectTokensHelper.getRemainingTokenList();
        }
        InputBoxesValidatorJavaHelper.validateBoxes(arrayList, l2, this.tokensToSpend);
        return arrayList;
    }

    public SignedTransaction putToContractTx(ErgoContract ergoContract) {
        if (this.senderProver == null) {
            throw new IllegalStateException("Call this only when prover is set");
        }
        UnsignedTransaction unsignedTransaction = this.putToContractTxUnsigned(ergoContract);
        SignedTransaction signedTransaction = this.senderProver.sign(unsignedTransaction);
        return signedTransaction;
    }

    public UnsignedTransaction putToContractTxUnsigned(ErgoContract ergoContract) {
        return this.buildTxWithDefaultInputs(unsignedTransactionBuilder -> {
            OutBoxBuilder outBoxBuilder = this.prepareOutBox((UnsignedTransactionBuilder)unsignedTransactionBuilder).contract(ergoContract);
            OutBox outBox = outBoxBuilder.build();
            unsignedTransactionBuilder.outputs(outBox);
            return unsignedTransactionBuilder;
        });
    }

    public OutBoxBuilder prepareOutBox(UnsignedTransactionBuilder unsignedTransactionBuilder) {
        OutBoxBuilder outBoxBuilder = unsignedTransactionBuilder.outBoxBuilder().value(this.amountToSpend);
        if (!this.tokensToSpend.isEmpty()) {
            outBoxBuilder.tokens(this.tokensToSpend.toArray(new ErgoToken[0]));
        }
        if (this.attachment != null) {
            outBoxBuilder.registers(this.attachment.getOutboxRegistersForAttachment());
        }
        return outBoxBuilder;
    }

    public UnsignedTransaction mintTokenToContractTxUnsigned(ErgoContract ergoContract, Function<String, Eip4Token> function) {
        if (!this.tokensToSpend.isEmpty()) {
            throw new IllegalArgumentException("Mint token not possible with spending tokens");
        }
        if (this.attachment != null) {
            throw new IllegalArgumentException("Mint token not possible with attachment");
        }
        return this.buildTxWithDefaultInputs(unsignedTransactionBuilder -> {
            OutBox outBox = unsignedTransactionBuilder.outBoxBuilder().value(this.amountToSpend).contract(ergoContract).mintToken((Eip4Token)((Object)((Object)function.apply(unsignedTransactionBuilder.getInputBoxes().get(0).getId().toString())))).build();
            unsignedTransactionBuilder.outputs(outBox);
            return unsignedTransactionBuilder;
        });
    }

    public UnsignedTransaction buildTxWithDefaultInputs(Function<UnsignedTransactionBuilder, UnsignedTransactionBuilder> function) {
        List<InputBox> list = this.loadTop();
        UnsignedTransactionBuilder unsignedTransactionBuilder = this.ctx.newTxBuilder();
        UnsignedTransactionBuilder unsignedTransactionBuilder2 = unsignedTransactionBuilder.boxesToSpend(list).fee(this.feeAmount).sendChangeTo(this.senders.get(0).getErgoAddress());
        return function.apply(unsignedTransactionBuilder2).build();
    }

    public static SignedTransaction spendBoxesTx(BlockchainContext blockchainContext, UnsignedTransactionBuilder unsignedTransactionBuilder, List<InputBox> list, ErgoProver ergoProver, Address address, long l, long l2) {
        OutBox outBox = unsignedTransactionBuilder.outBoxBuilder().value(l).contract(address.toErgoContract()).build();
        UnsignedTransaction unsignedTransaction = unsignedTransactionBuilder.boxesToSpend(list).addOutputs(outBox).fee(l2).sendChangeTo((ErgoAddress)ergoProver.getP2PKAddress()).build();
        SignedTransaction signedTransaction = ergoProver.sign(unsignedTransaction);
        return signedTransaction;
    }

    public static CoveringBoxes getCoveringBoxesFor(long l, List<ErgoToken> list, boolean bl, Function<Integer, List<InputBox>> function) {
        return BoxOperations.getCoveringBoxesFor(l, list, bl, function, 0);
    }

    private static CoveringBoxes getCoveringBoxesFor(long l, List<ErgoToken> list, boolean bl, Function<Integer, List<InputBox>> function, int n) {
        SelectTokensHelper selectTokensHelper = new SelectTokensHelper(list);
        Preconditions.checkArgument((l > 0L || !selectTokensHelper.areTokensCovered() ? 1 : 0) != 0, (Object)"amountToSpend or tokens to spend should be > 0");
        ArrayList<InputBox> arrayList = new ArrayList<InputBox>();
        long l2 = l;
        int n2 = 0;
        while (true) {
            List<InputBox> list2 = function.apply(n2);
            for (InputBox inputBox : list2) {
                if (BoxOperations.isAlreadyAdded(arrayList, inputBox)) continue;
                boolean bl2 = selectTokensHelper.areTokensNeeded(inputBox.getTokens());
                if (bl2 || l2 > 0L) {
                    arrayList.add(inputBox);
                    l2 -= inputBox.getValue();
                    selectTokensHelper.useTokens(inputBox.getTokens());
                    if (!bl && selectTokensHelper.isChangeBoxNeeded()) {
                        bl = true;
                        l2 += 1000000L;
                        l += 1000000L;
                    }
                }
                if (l2 <= 0L && selectTokensHelper.areTokensCovered()) {
                    return new CoveringBoxes(l, arrayList, list, bl);
                }
                if (n <= 0 || arrayList.size() < n) continue;
                List<ErgoToken> list3 = selectTokensHelper.getRemainingTokenList();
                throw new InputBoxesSelectionException.InputBoxLimitExceededException("Input box limit exceeded, could not cover " + l2 + " nanoERG and " + list3.size() + " tokens.", l2, list3, n);
            }
            if (list2.size() == 0) {
                assert (l2 > 0L || !selectTokensHelper.areTokensCovered());
                return new CoveringBoxes(l, arrayList, list, bl);
            }
            ++n2;
        }
    }

    private static boolean isAlreadyAdded(ArrayList<InputBox> arrayList, InputBox inputBox) {
        boolean bl = false;
        for (InputBox inputBox2 : arrayList) {
            if (!inputBox2.getId().equals((Object)inputBox.getId())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static class ExplorerApiUnspentLoader
    implements IUnspentBoxesLoader {
        @Override
        public void prepare(@Nonnull BlockchainContext blockchainContext, List<Address> list, long l, @Nonnull List<ErgoToken> list2) {
        }

        @Override
        public void prepareForAddress(Address address) {
        }

        @Override
        @Nonnull
        public List<InputBox> loadBoxesPage(@Nonnull BlockchainContext blockchainContext, @Nonnull Address address, @Nonnull Integer n) {
            return blockchainContext.getDataSource().getUnspentBoxesFor(address, n * 20, 20);
        }
    }

    public static abstract class ExplorerApiWithCheckerLoader
    extends ExplorerApiUnspentLoader {
        protected abstract boolean canUseBox(InputBox var1);

        @Override
        @Nonnull
        public List<InputBox> loadBoxesPage(@Nonnull BlockchainContext blockchainContext, @Nonnull Address address, @Nonnull Integer n) {
            List<InputBox> list = super.loadBoxesPage(blockchainContext, address, n);
            ArrayList<InputBox> arrayList = new ArrayList<InputBox>(list.size());
            int n2 = 0;
            while (!list.isEmpty() && arrayList.isEmpty()) {
                for (InputBox inputBox : list) {
                    if (!this.canUseBox(inputBox)) continue;
                    arrayList.add(inputBox);
                }
                if (!arrayList.isEmpty()) continue;
                list = super.loadBoxesPage(blockchainContext, address, n + ++n2);
            }
            return arrayList;
        }
    }

    public static interface IUnspentBoxesLoader {
        public void prepare(@Nonnull BlockchainContext var1, List<Address> var2, long var3, @Nonnull List<ErgoToken> var5);

        public void prepareForAddress(Address var1);

        @Nonnull
        public List<InputBox> loadBoxesPage(@Nonnull BlockchainContext var1, @Nonnull Address var2, @Nonnull Integer var3);
    }
}

