/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ergoplatform.appkit.ErgoType;
import org.ergoplatform.appkit.ErgoValue;
import org.ergoplatform.sdk.ErgoToken;
import org.ergoplatform.sdk.JavaHelpers;
import scala.Tuple2;
import sigma.Coll;

public class Eip4Token
extends ErgoToken {
    private final String name;
    private final String description;
    private final int decimals;
    private final ErgoValue<?> r7;
    private final ErgoValue<?> r8;
    private final ErgoValue<?> r9;

    public Eip4Token(@Nonnull String string, long l, @Nonnull ErgoValue<Coll<Object>> ergoValue, @Nonnull ErgoValue<Coll<Object>> ergoValue2, @Nonnull ErgoValue<Coll<Object>> ergoValue3, @Nullable ErgoValue<?> ergoValue4, @Nullable ErgoValue<?> ergoValue5, @Nullable ErgoValue<?> ergoValue6) {
        this(string, l, new String(JavaHelpers.collToByteArray(ergoValue.getValue()), StandardCharsets.UTF_8), new String(JavaHelpers.collToByteArray(ergoValue2.getValue()), StandardCharsets.UTF_8), Integer.parseInt(new String(JavaHelpers.collToByteArray(ergoValue3.getValue()), StandardCharsets.UTF_8)), ergoValue4, ergoValue5, ergoValue6);
    }

    public Eip4Token(@Nonnull String string, long l, @Nonnull String string2, @Nonnull String string3, int n) {
        this(string, l, string2, string3, n, null, null, null);
    }

    public Eip4Token(@Nonnull String string, long l, @Nonnull String string2, @Nonnull String string3, int n, @Nullable ErgoValue<?> ergoValue, @Nullable ErgoValue<?> ergoValue2, @Nullable ErgoValue<?> ergoValue3) {
        super(string, l);
        this.name = string2;
        this.description = string3;
        this.decimals = n;
        this.r7 = ergoValue;
        this.r8 = ergoValue2;
        this.r9 = ergoValue3;
    }

    @Nonnull
    public String getTokenName() {
        return this.name;
    }

    @Nonnull
    public String getTokenDescription() {
        return this.description;
    }

    public int getDecimals() {
        return this.decimals;
    }

    @Nonnull
    public String getAmountFormatted() {
        return BigDecimal.valueOf(this.getValue()).movePointLeft(this.decimals).toPlainString();
    }

    @Nonnull
    public AssetType getAssetType() {
        byte[] byArray = this.getR7ByteArrayOrNull();
        if (this.r7 == null) {
            return AssetType.NONE;
        }
        if (byArray == null) {
            return AssetType.UNKNOWN;
        }
        for (AssetType assetType : AssetType.values()) {
            byte[] byArray2 = assetType.getR7ByteArrayForType();
            if (byArray2 == null || !Arrays.equals(byArray2, byArray)) continue;
            return assetType;
        }
        return AssetType.UNKNOWN;
    }

    @Nullable
    private byte[] getR7ByteArrayOrNull() {
        if (this.r7 != null && this.r7.getValue() instanceof Coll) {
            Coll coll = (Coll)this.r7.getValue();
            if (coll.length() > 0 && coll.tItem() == ErgoType.byteType().getRType()) {
                return JavaHelpers.collToByteArray((Coll)((Coll)this.r7.getValue()));
            }
            return null;
        }
        return null;
    }

    public boolean isNftAssetType() {
        byte[] byArray = this.getR7ByteArrayOrNull();
        return byArray != null && byArray.length == 2 && byArray[0] == 1;
    }

    @Nullable
    public byte[] getNftContentHash() {
        if (this.isNftAssetType()) {
            return JavaHelpers.collToByteArray((Coll)((Coll)this.r8.getValue()));
        }
        return null;
    }

    @Nullable
    public String getNftContentLink() {
        if (this.r9 != null && this.isNftAssetType()) {
            if (this.r9.getValue() instanceof Coll) {
                return new String(JavaHelpers.collToByteArray((Coll)((Coll)this.r9.getValue())), StandardCharsets.UTF_8);
            }
            if (this.r9.getValue() instanceof Tuple2) {
                return new String(JavaHelpers.collToByteArray((Coll)((Coll)((Tuple2)this.r9.getValue())._1)), StandardCharsets.UTF_8);
            }
        }
        return null;
    }

    @Nullable
    public String getNftCoverImageLink() {
        if (this.r9 != null && this.isNftAssetType() && this.r9.getValue() instanceof Tuple2) {
            return new String(JavaHelpers.collToByteArray((Coll)((Coll)((Tuple2)this.r9.getValue())._2)), StandardCharsets.UTF_8);
        }
        return null;
    }

    @Nonnull
    public ErgoValue<Coll<Byte>> getMintingBoxR4() {
        return ErgoValue.of(this.name.getBytes(StandardCharsets.UTF_8));
    }

    @Nonnull
    public ErgoValue<Coll<Byte>> getMintingBoxR5() {
        return ErgoValue.of(this.description.getBytes(StandardCharsets.UTF_8));
    }

    @Nonnull
    public ErgoValue<Coll<Byte>> getMintingBoxR6() {
        return ErgoValue.of(Integer.toString(this.decimals).getBytes(StandardCharsets.UTF_8));
    }

    @Nullable
    public ErgoValue<?> getMintingBoxR7() {
        return this.r7;
    }

    @Nullable
    public ErgoValue<?> getMintingBoxR8() {
        return this.r8;
    }

    @Nullable
    public ErgoValue<?> getMintingBoxR9() {
        return this.r9;
    }

    public static enum AssetType {
        NONE,
        NFT_PICTURE,
        NFT_AUDIO,
        NFT_VIDEO,
        ARTWORK_COLLECTION,
        MEMBERSHIP_THRESHOLD_SIG,
        UNKNOWN;


        public byte[] getR7ByteArrayForType() {
            switch (this) {
                case NFT_PICTURE: {
                    return new byte[]{1, 1};
                }
                case NFT_AUDIO: {
                    return new byte[]{1, 2};
                }
                case NFT_VIDEO: {
                    return new byte[]{1, 3};
                }
                case ARTWORK_COLLECTION: {
                    return new byte[]{1, 4};
                }
                case MEMBERSHIP_THRESHOLD_SIG: {
                    return new byte[]{2, 1};
                }
            }
            return null;
        }
    }
}

