/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.ergoplatform.appkit.AppkitHelpers;
import org.ergoplatform.appkit.AppkitIso;
import org.ergoplatform.appkit.ErgoType;
import org.ergoplatform.appkit.ErgoValue;
import org.ergoplatform.sdk.JavaHelpers;
import scala.collection.IndexedSeq;
import scorex.crypto.hash.Sha256;
import scorex.util.encode.Base16;
import sigmastate.SType;
import sigmastate.Values;
import sigmastate.serialization.ErgoTreeSerializer;

public class ErgoTreeTemplate {
    private static int[] _noParameters = new int[0];
    private final Values.ErgoTree _tree;
    private final byte[] _templateBytes;
    private int[] _parameterPositions = _noParameters;

    private ErgoTreeTemplate(Values.ErgoTree ergoTree) {
        this._tree = ergoTree;
        this._templateBytes = JavaHelpers.ergoTreeTemplateBytes((Values.ErgoTree)this._tree);
    }

    public ErgoTreeTemplate withParameterPositions(int[] nArray) {
        HashSet<Integer> hashSet = new HashSet<Integer>(nArray.length);
        for (int n : nArray) {
            hashSet.add(n);
        }
        if (hashSet.size() != nArray.length) {
            throw new IllegalArgumentException("Duplicate positions: " + AppkitHelpers.arraySeq(nArray).mkString("[", ",", "]"));
        }
        for (int n : nArray) {
            if (this._tree.constants().isDefinedAt(n)) continue;
            throw new IllegalArgumentException("Invalid parameter position " + n);
        }
        this._parameterPositions = nArray;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ErgoTreeTemplate ergoTreeTemplate = (ErgoTreeTemplate)object;
        return Arrays.equals(this.getBytes(), ergoTreeTemplate.getBytes());
    }

    public int hashCode() {
        return Arrays.hashCode(this._templateBytes);
    }

    public byte[] getBytes() {
        return this._templateBytes;
    }

    public String getEncodedBytes() {
        return Base16.encode((byte[])this.getBytes());
    }

    public String getTemplateHashHex() {
        return Base16.encode((byte[])Sha256.hash((byte[])this._templateBytes));
    }

    public int getParameterCount() {
        return this._parameterPositions.length;
    }

    public List<ErgoType<?>> getParameterTypes() {
        ArrayList arrayList = new ArrayList();
        IndexedSeq indexedSeq = this._tree.constants();
        for (int n : this._parameterPositions) {
            SType sType = ((Values.Constant)indexedSeq.apply(n)).tpe();
            arrayList.add((ErgoType<?>)AppkitIso.isoErgoTypeToSType().from((Object)sType));
        }
        return arrayList;
    }

    public ErgoValue<?> getParameterValue(int n) {
        Values.Constant constant = (Values.Constant)this._tree.constants().apply(this._parameterPositions[n]);
        return (ErgoValue)AppkitIso.isoErgoValueToSValue().from((Object)constant);
    }

    public Values.ErgoTree applyParameters(ErgoValue<?> ... ergoValueArray) {
        if (ergoValueArray.length != this._parameterPositions.length) {
            throw new IllegalArgumentException("Wrong number of newValues. Expected " + this._parameterPositions.length + " but was " + ergoValueArray.length);
        }
        return AppkitHelpers.substituteErgoTreeConstants(this._tree.bytes(), this._parameterPositions, ergoValueArray);
    }

    public static ErgoTreeTemplate fromErgoTree(Values.ErgoTree ergoTree) {
        return new ErgoTreeTemplate(ergoTree);
    }

    public static ErgoTreeTemplate fromErgoTreeBytes(byte[] byArray) {
        Values.ErgoTree ergoTree = ErgoTreeSerializer.DefaultSerializer().deserializeErgoTree(byArray);
        return ErgoTreeTemplate.fromErgoTree(ergoTree);
    }
}

