/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.util.Objects;
import org.ergoplatform.sdk.JavaHelpers;
import scala.Tuple2;
import scala.Unit;
import sigma.AvlTree;
import sigma.BigInt;
import sigma.Box;
import sigma.Coll;
import sigma.GroupElement;
import sigma.Header;
import sigma.PreHeader;
import sigma.SigmaProp;
import sigma.data.RType;

public class ErgoType<T> {
    private static ErgoType<Byte> _byte = new ErgoType(JavaHelpers.JByteRType());
    private static ErgoType<Short> _short = new ErgoType(JavaHelpers.JShortRType());
    private static ErgoType<Integer> _integer = new ErgoType(JavaHelpers.JIntRType());
    private static ErgoType<Long> _long = new ErgoType(JavaHelpers.JLongRType());
    private static ErgoType<Boolean> _boolean = new ErgoType(JavaHelpers.JBooleanRType());
    private static ErgoType<BigInt> _bigInt = new ErgoType(JavaHelpers.BigIntRType());
    private static ErgoType<Unit> _unit = new ErgoType(JavaHelpers.JUnitRType());
    private static ErgoType<GroupElement> _groupElement = new ErgoType(JavaHelpers.GroupElementRType());
    private static ErgoType<SigmaProp> _sigmaProp = new ErgoType(JavaHelpers.SigmaPropRType());
    private static ErgoType<AvlTree> _avlTree = new ErgoType(JavaHelpers.AvlTreeRType());
    private static ErgoType<Box> _box = new ErgoType(JavaHelpers.BoxRType());
    private static ErgoType<Header> _header = new ErgoType(JavaHelpers.HeaderRType());
    private static ErgoType<PreHeader> _preHeader = new ErgoType(JavaHelpers.PreHeaderRType());
    private final RType<T> _rtype;

    public RType<T> getRType() {
        return this._rtype;
    }

    ErgoType(RType<T> rType) {
        this._rtype = rType;
    }

    public int hashCode() {
        return Objects.hashCode(this._rtype);
    }

    public boolean equals(Object object) {
        return object instanceof ErgoType && Objects.equals(this._rtype, ((ErgoType)object)._rtype);
    }

    public String toString() {
        return "ErgoType(" + this._rtype.name() + ")";
    }

    public static ErgoType<Byte> byteType() {
        return _byte;
    }

    public static ErgoType<Short> shortType() {
        return _short;
    }

    public static ErgoType<Integer> integerType() {
        return _integer;
    }

    public static ErgoType<Long> longType() {
        return _long;
    }

    public static ErgoType<Boolean> booleanType() {
        return _boolean;
    }

    public static ErgoType<BigInt> bigIntType() {
        return _bigInt;
    }

    public static ErgoType<Unit> unitType() {
        return _unit;
    }

    public static ErgoType<GroupElement> groupElementType() {
        return _groupElement;
    }

    public static ErgoType<SigmaProp> sigmaPropType() {
        return _sigmaProp;
    }

    public static ErgoType<AvlTree> avlTreeType() {
        return _avlTree;
    }

    public static ErgoType<Box> boxType() {
        return _box;
    }

    public static ErgoType<Header> headerType() {
        return _header;
    }

    public static ErgoType<PreHeader> preHeaderType() {
        return _preHeader;
    }

    public static <A, B> ErgoType<Tuple2<A, B>> pairType(ErgoType<A> ergoType, ErgoType<B> ergoType2) {
        return new ErgoType<Tuple2<A, B>>(RType.pairRType(ergoType._rtype, ergoType2._rtype));
    }

    public static <A> ErgoType<Coll<A>> collType(ErgoType<A> ergoType) {
        return new ErgoType<Coll<A>>(JavaHelpers.collRType(ergoType._rtype));
    }

    public static <A> ErgoType<A> ofRType(RType<A> rType) {
        return new ErgoType<A>(rType);
    }
}

