/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.math.BigInteger;
import java.util.Objects;
import org.bouncycastle.math.ec.ECPoint;
import org.ergoplatform.ErgoBox;
import org.ergoplatform.appkit.AppkitHelpers;
import org.ergoplatform.appkit.AppkitIso;
import org.ergoplatform.appkit.ErgoType;
import org.ergoplatform.appkit.SigmaProp;
import org.ergoplatform.sdk.Iso;
import org.ergoplatform.sdk.JavaHelpers;
import scala.Tuple2;
import scorex.util.encode.Base16;
import sigma.AvlTree;
import sigma.BigInt;
import sigma.Box;
import sigma.Coll;
import sigma.GroupElement;
import sigmastate.AvlTreeData;
import sigmastate.Values;
import sigmastate.crypto.Platform;
import sigmastate.serialization.ValueSerializer;
import sigmastate.serialization.ValueSerializer$;

public class ErgoValue<T> {
    private final T _value;
    private final ErgoType<T> _type;

    ErgoValue(T t, ErgoType<T> ergoType) {
        this._value = t;
        this._type = ergoType;
    }

    public T getValue() {
        return this._value;
    }

    public ErgoType<T> getType() {
        return this._type;
    }

    public String toHex() {
        Values.EvaluatedValue evaluatedValue = (Values.EvaluatedValue)AppkitIso.isoErgoValueToSValue().to((Object)this);
        byte[] byArray = ValueSerializer$.MODULE$.serialize((Values.Value)evaluatedValue);
        return Base16.encode((byte[])byArray);
    }

    public int hashCode() {
        return Objects.hash(this._type, this._value);
    }

    public boolean equals(Object object) {
        if (object instanceof ErgoValue) {
            ErgoValue ergoValue = (ErgoValue)object;
            return Objects.equals(this._type, ergoValue._type) && Objects.equals(this._value, ergoValue._value);
        }
        return false;
    }

    public String toString() {
        return "ErgoValue(" + this._value.toString() + ", " + this._type.toString() + ")";
    }

    public static ErgoValue<Byte> of(byte by) {
        return new ErgoValue<Byte>((Byte)Iso.jbyteToByte().to((Object)by), ErgoType.byteType());
    }

    public static ErgoValue<Short> of(short s) {
        return new ErgoValue<Short>((Short)Iso.jshortToShort().to((Object)s), ErgoType.shortType());
    }

    public static ErgoValue<Integer> of(int n) {
        return new ErgoValue<Integer>((Integer)Iso.jintToInt().to((Object)n), ErgoType.integerType());
    }

    public static ErgoValue<Long> of(long l) {
        return new ErgoValue<Long>((Long)Iso.jlongToLong().to((Object)l), ErgoType.longType());
    }

    public static ErgoValue<Boolean> of(boolean bl) {
        return new ErgoValue<Boolean>((Boolean)Iso.jboolToBool().to((Object)bl), ErgoType.booleanType());
    }

    public static ErgoValue<?> unit() {
        return AppkitHelpers.UnitErgoVal();
    }

    public static ErgoValue<BigInt> of(BigInteger bigInteger) {
        return new ErgoValue<BigInt>(JavaHelpers.SigmaDsl().BigInt(bigInteger), ErgoType.bigIntType());
    }

    public static ErgoValue<GroupElement> of(ECPoint eCPoint) {
        GroupElement groupElement = JavaHelpers.SigmaDsl().GroupElement(new Platform.Ecp(eCPoint));
        return new ErgoValue<GroupElement>(groupElement, ErgoType.groupElementType());
    }

    public static ErgoValue<GroupElement> of(GroupElement groupElement) {
        return new ErgoValue<GroupElement>(groupElement, ErgoType.groupElementType());
    }

    public static ErgoValue<sigma.SigmaProp> of(Values.SigmaBoolean sigmaBoolean) {
        return new ErgoValue<sigma.SigmaProp>(JavaHelpers.SigmaDsl().SigmaProp(sigmaBoolean), ErgoType.sigmaPropType());
    }

    public static ErgoValue<sigma.SigmaProp> of(SigmaProp sigmaProp) {
        return new ErgoValue<sigma.SigmaProp>(JavaHelpers.SigmaDsl().SigmaProp(sigmaProp.getSigmaBoolean()), ErgoType.sigmaPropType());
    }

    public static ErgoValue<AvlTree> of(AvlTreeData avlTreeData) {
        return new ErgoValue<AvlTree>(JavaHelpers.SigmaDsl().avlTree(avlTreeData), ErgoType.avlTreeType());
    }

    public static ErgoValue<Box> of(ErgoBox ergoBox) {
        return ErgoValue.of(JavaHelpers.SigmaDsl().Box(ergoBox));
    }

    public static ErgoValue<Box> of(Box box) {
        return new ErgoValue<Box>(box, ErgoType.boxType());
    }

    public static ErgoValue<Coll<Byte>> of(byte[] byArray) {
        Coll coll = JavaHelpers.collFrom((byte[])byArray);
        ErgoType<Coll<Byte>> ergoType = ErgoType.collType(ErgoType.byteType());
        return new ErgoValue<Coll<Byte>>(coll, ergoType);
    }

    public static ErgoValue<Coll<Long>> of(long[] lArray) {
        return new ErgoValue<Coll<Long>>(JavaHelpers.collFrom((long[])lArray), ErgoType.collType(ErgoType.longType()));
    }

    public static ErgoValue<Coll<Boolean>> of(boolean[] blArray) {
        return new ErgoValue<Coll<Boolean>>(JavaHelpers.collFrom((boolean[])blArray), ErgoType.collType(ErgoType.booleanType()));
    }

    public static ErgoValue<Coll<Short>> of(short[] sArray) {
        return new ErgoValue<Coll<Short>>(JavaHelpers.collFrom((short[])sArray), ErgoType.collType(ErgoType.shortType()));
    }

    public static ErgoValue<Coll<Integer>> of(int[] nArray) {
        return new ErgoValue<Coll<Integer>>(JavaHelpers.collFrom((int[])nArray), ErgoType.collType(ErgoType.integerType()));
    }

    public static <A, B> ErgoValue<Tuple2<A, B>> pairOf(ErgoValue<A> ergoValue, ErgoValue<B> ergoValue2) {
        return new ErgoValue<Tuple2<A, B>>(new Tuple2(ergoValue.getValue(), ergoValue2.getValue()), ErgoType.pairType(ergoValue.getType(), ergoValue2.getType()));
    }

    public static <T> ErgoValue<Coll<T>> of(T[] TArray, ErgoType<T> ergoType) {
        Coll coll = JavaHelpers.SigmaDsl().Colls().fromArray(TArray, ergoType.getRType());
        return new ErgoValue<Coll<T>>(coll, ErgoType.collType(ergoType));
    }

    public static <T> ErgoValue<Coll<T>> of(Coll<T> coll, ErgoType<T> ergoType) {
        return new ErgoValue<Coll<T>>(coll, ErgoType.collType(ergoType));
    }

    public static <T> ErgoValue<T> of(T t, ErgoType<T> ergoType) {
        return new ErgoValue<T>(t, ergoType);
    }

    public static ErgoValue<?> fromHex(String string) {
        byte[] byArray = JavaHelpers.decodeStringToBytes((String)string);
        Values.EvaluatedValue evaluatedValue = (Values.EvaluatedValue)ValueSerializer.deserialize((byte[])byArray, (int)0);
        ErgoValue ergoValue = (ErgoValue)AppkitIso.isoErgoValueToSValue().from((Object)evaluatedValue);
        return ergoValue;
    }
}

