/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.io.File;
import org.ergoplatform.ErgoAddress;
import org.ergoplatform.P2PKAddress;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.AppkitHelpers;
import org.ergoplatform.appkit.Mnemonic;
import org.ergoplatform.appkit.NetworkType;
import org.ergoplatform.appkit.SecretStringConverter;
import org.ergoplatform.sdk.JavaHelpers;
import org.ergoplatform.sdk.wallet.secrets.ExtendedSecretKey;
import org.ergoplatform.sdk.wallet.settings.EncryptionSettings;
import org.ergoplatform.wallet.interface4j.SecretString;
import org.ergoplatform.wallet.secrets.JsonSecretStorage;
import org.ergoplatform.wallet.settings.SecretStorageSettings;
import scala.Option;
import scala.util.Failure;
import scala.util.Try;
import sigmastate.crypto.DLogProtocol;

public class SecretStorage {
    public static EncryptionSettings DEFAULT_SETTINGS = new EncryptionSettings("HmacSHA256", 128000, 256);
    private final JsonSecretStorage _jsonStorage;

    SecretStorage(JsonSecretStorage jsonSecretStorage) {
        this._jsonStorage = jsonSecretStorage;
    }

    public boolean isLocked() {
        return this._jsonStorage.isLocked();
    }

    public File getFile() {
        return this._jsonStorage.secretFile();
    }

    public ExtendedSecretKey getSecret() {
        Option option = this._jsonStorage.secret();
        if (option.isEmpty()) {
            return null;
        }
        return (ExtendedSecretKey)option.get();
    }

    public Address getAddressFor(NetworkType networkType) {
        DLogProtocol.ProveDlog proveDlog = ((ExtendedSecretKey)this._jsonStorage.secret().get()).publicImage();
        P2PKAddress p2PKAddress = JavaHelpers.createP2PKAddress((DLogProtocol.ProveDlog)proveDlog, (byte)networkType.networkPrefix);
        return new Address((ErgoAddress)p2PKAddress);
    }

    public void unlock(org.ergoplatform.sdk.SecretString secretString) {
        Try try_ = this._jsonStorage.unlock(SecretStringConverter.toInterface4JSecretString(secretString));
        if (try_.isFailure()) {
            Throwable throwable = ((Failure)try_).exception();
            throw new RuntimeException("Cannot unlock secrete storage.", throwable);
        }
    }

    public void unlock(String string) {
        this.unlock(org.ergoplatform.sdk.SecretString.create((String)string));
    }

    public static SecretStorage createFromMnemonicIn(String string, Mnemonic mnemonic, org.ergoplatform.sdk.SecretString secretString, Boolean bl) {
        SecretStorageSettings secretStorageSettings = new SecretStorageSettings(string, DEFAULT_SETTINGS);
        org.ergoplatform.sdk.SecretString secretString2 = mnemonic.getPassword();
        JsonSecretStorage jsonSecretStorage = JsonSecretStorage.restore((SecretString)SecretStringConverter.toInterface4JSecretString(mnemonic.getPhrase()), AppkitHelpers.secretStringToOption(secretString2 != null ? SecretStringConverter.toInterface4JSecretString(secretString2) : null), (SecretString)SecretStringConverter.toInterface4JSecretString(secretString), (SecretStorageSettings)secretStorageSettings, (boolean)bl);
        return new SecretStorage(jsonSecretStorage);
    }

    public static SecretStorage createFromMnemonicIn(String string, Mnemonic mnemonic, String string2, Boolean bl) {
        return SecretStorage.createFromMnemonicIn(string, mnemonic, org.ergoplatform.sdk.SecretString.create((String)string2), bl);
    }

    public static SecretStorage loadFrom(String string) {
        File file = new File(string);
        return SecretStorage.loadFrom(file);
    }

    public static SecretStorage loadFrom(File file) {
        if (!file.exists()) {
            throw new RuntimeException("SecreteStorage file not found: " + file.getPath());
        }
        return new SecretStorage(new JsonSecretStorage(file, DEFAULT_SETTINGS));
    }
}

