/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.AppkitHelpers;
import org.ergoplatform.appkit.Constants;
import org.ergoplatform.appkit.ErgoContract;
import org.ergoplatform.appkit.NetworkType;
import sigmastate.Values;

public class ErgoScriptContract
implements ErgoContract {
    private final Constants _constants;
    private final String _code;
    private final NetworkType _networkType;

    private ErgoScriptContract(Constants constants, String string, NetworkType networkType) {
        this._constants = constants;
        this._code = string;
        this._networkType = networkType;
    }

    @Override
    public Constants getConstants() {
        return this._constants;
    }

    @Override
    public String getErgoScript() {
        return this._code;
    }

    public static ErgoScriptContract create(Constants constants, String string, NetworkType networkType) {
        return new ErgoScriptContract(constants, string, networkType);
    }

    @Override
    public ErgoScriptContract substConstant(String string, Object object) {
        Constants constants = (Constants)this._constants.clone();
        constants.replace(string, object);
        return ErgoScriptContract.create(constants, this._code, this._networkType);
    }

    @Override
    public Values.ErgoTree getErgoTree() {
        Values.ErgoTree ergoTree = AppkitHelpers.compile(this._constants, this._code, this._networkType.networkPrefix);
        return ergoTree;
    }

    @Override
    public Address toAddress() {
        return Address.fromErgoTree(this.getErgoTree(), this._networkType);
    }
}

