/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.List;
import org.ergoplatform.ErgoBox;
import org.ergoplatform.ErgoBoxCandidate;
import org.ergoplatform.appkit.AppkitHelpers;
import org.ergoplatform.appkit.AppkitIso;
import org.ergoplatform.appkit.BoxAttachment;
import org.ergoplatform.appkit.ContextVar;
import org.ergoplatform.appkit.ErgoValue;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.impl.BoxAttachmentBuilder;
import org.ergoplatform.appkit.impl.ScalaBridge;
import org.ergoplatform.explorer.client.model.OutputInfo;
import org.ergoplatform.restapi.client.ErgoTransactionOutput;
import org.ergoplatform.restapi.client.JSON;
import org.ergoplatform.sdk.ErgoId;
import org.ergoplatform.sdk.ErgoToken;
import org.ergoplatform.sdk.Iso;
import org.ergoplatform.sdk.JavaHelpers;
import sigma.Box;
import sigmastate.Values;
import sigmastate.interpreter.ContextExtension;

public class InputBoxImpl
implements InputBox {
    private final ErgoId _id;
    private final ErgoBox _ergoBox;
    private final ErgoTransactionOutput _boxData;
    private ContextExtension _extension;

    public InputBoxImpl(ErgoTransactionOutput ergoTransactionOutput) {
        this._id = new ErgoId(JavaHelpers.decodeStringToBytes((String)ergoTransactionOutput.getBoxId()));
        this._ergoBox = (ErgoBox)ScalaBridge.isoErgoTransactionOutput().to((Object)ergoTransactionOutput);
        this._boxData = ergoTransactionOutput;
        this._extension = ContextExtension.empty();
    }

    public InputBoxImpl(OutputInfo outputInfo) {
        this._id = ErgoId.create((String)outputInfo.getBoxId());
        this._ergoBox = (ErgoBox)ScalaBridge.isoExplTransactionOutput().to((Object)outputInfo);
        this._boxData = (ErgoTransactionOutput)ScalaBridge.isoErgoTransactionOutput().from((Object)this._ergoBox);
        this._extension = ContextExtension.empty();
    }

    public InputBoxImpl(ErgoBox ergoBox) {
        this._ergoBox = ergoBox;
        this._id = new ErgoId(ergoBox.id());
        this._boxData = (ErgoTransactionOutput)ScalaBridge.isoErgoTransactionOutput().from((Object)ergoBox);
        this._extension = ContextExtension.empty();
    }

    @Override
    public ErgoId getId() {
        return this._id;
    }

    @Override
    public long getValue() {
        return this._ergoBox.value();
    }

    @Override
    public int getCreationHeight() {
        return this._ergoBox.creationHeight();
    }

    @Override
    public List<ErgoToken> getTokens() {
        List list = (List)Iso.isoTokensListToPairsColl().from((Object)this._ergoBox.additionalTokens());
        return list;
    }

    @Override
    public List<ErgoValue<?>> getRegisters() {
        return AppkitHelpers.getBoxRegisters((ErgoBoxCandidate)this._ergoBox);
    }

    @Override
    public Values.ErgoTree getErgoTree() {
        return this._ergoBox.ergoTree();
    }

    @Override
    public BoxAttachment getAttachment() {
        return BoxAttachmentBuilder.buildFromTransactionBox(this);
    }

    @Override
    public InputBox withContextVars(ContextVar ... contextVarArray) {
        ContextExtension contextExtension = (ContextExtension)AppkitIso.isoContextVarsToContextExtension().to(Arrays.asList(contextVarArray));
        InputBoxImpl inputBoxImpl = new InputBoxImpl(this._ergoBox);
        inputBoxImpl._extension = contextExtension;
        return inputBoxImpl;
    }

    @Override
    public String toJson(boolean bl) {
        return this.toJson(bl, true);
    }

    @Override
    public String toJson(boolean bl, boolean bl2) {
        Gson gson = bl || bl2 ? JSON.createGson().setPrettyPrinting().create() : JSON.createGson().create();
        ErgoTransactionOutput ergoTransactionOutput = this._boxData;
        if (bl) {
            ergoTransactionOutput = this.cloneDataObject(gson, this._boxData);
            ergoTransactionOutput.ergoTree(this._ergoBox.ergoTree().toString());
        }
        String string = gson.toJson((Object)ergoTransactionOutput);
        return string;
    }

    private <T> T cloneDataObject(Gson gson, T t) {
        return (T)gson.fromJson(gson.toJson(t), t.getClass());
    }

    @Override
    public byte[] getBytes() {
        return this._ergoBox.bytes();
    }

    @Override
    public String getTransactionId() {
        return this._ergoBox.transactionId();
    }

    @Override
    public int getTransactionIndex() {
        return this._ergoBox.index();
    }

    public ErgoBox getErgoBox() {
        return this._ergoBox;
    }

    public ContextExtension getExtension() {
        return this._extension;
    }

    public String toString() {
        return String.format("InputBox(%s, %s)", this.getId(), this.getValue());
    }

    @Override
    public ErgoValue<Box> toErgoValue() {
        return ErgoValue.of(this.getErgoBox());
    }
}

