/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.ergoplatform.ErgoAddress;
import org.ergoplatform.ErgoBox;
import org.ergoplatform.ErgoBoxCandidate;
import org.ergoplatform.UnsignedErgoLikeTransaction;
import org.ergoplatform.appkit.AppkitHelpers;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.OutBox;
import org.ergoplatform.appkit.UnsignedTransaction;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.InputBoxImpl;
import org.ergoplatform.appkit.impl.OutBoxImpl;
import org.ergoplatform.appkit.impl.ScalaBridge;
import org.ergoplatform.restapi.client.ErgoTransactionOutput;
import org.ergoplatform.restapi.client.JSON;
import org.ergoplatform.restapi.client.UnsignedErgoTransaction;
import org.ergoplatform.sdk.ErgoId;
import org.ergoplatform.sdk.ErgoToken;
import org.ergoplatform.sdk.ExtendedInputBox;
import org.ergoplatform.sdk.wallet.protocol.context.BlockchainStateContext;
import sigmastate.Values;

public class UnsignedTransactionImpl
implements UnsignedTransaction {
    private final UnsignedErgoLikeTransaction _tx;
    private List<ExtendedInputBox> _boxesToSpend;
    private List<ErgoBox> _dataBoxes;
    private List<ErgoToken> _tokensToBurn;
    private List<ErgoBox> _outputs;
    private ErgoAddress _changeAddress;
    private BlockchainStateContext _stateContext;
    private BlockchainContextImpl _ctx;

    public UnsignedTransactionImpl(UnsignedErgoLikeTransaction unsignedErgoLikeTransaction, List<ExtendedInputBox> list, List<ErgoBox> list2, ErgoAddress ergoAddress, BlockchainStateContext blockchainStateContext, BlockchainContextImpl blockchainContextImpl, List<ErgoToken> list3) {
        this._tx = unsignedErgoLikeTransaction;
        this._boxesToSpend = list;
        this._dataBoxes = list2;
        this._tokensToBurn = list3;
        this._outputs = AppkitHelpers.toJavaList(this._tx.outputs());
        this._changeAddress = ergoAddress;
        this._stateContext = blockchainStateContext;
        this._ctx = blockchainContextImpl;
    }

    @Override
    public String getId() {
        return this.getTx().id();
    }

    public UnsignedErgoLikeTransaction getTx() {
        return this._tx;
    }

    public List<ExtendedInputBox> getBoxesToSpend() {
        return this._boxesToSpend;
    }

    public List<ErgoBox> getDataBoxes() {
        return this._dataBoxes;
    }

    public BlockchainStateContext getStateContext() {
        return this._stateContext;
    }

    @Override
    public List<InputBox> getInputs() {
        ArrayList<InputBox> arrayList = new ArrayList<InputBox>(this._boxesToSpend.size());
        for (ExtendedInputBox extendedInputBox : this._boxesToSpend) {
            arrayList.add(new InputBoxImpl(extendedInputBox.box()));
        }
        return arrayList;
    }

    @Override
    public List<String> getInputBoxesIds() {
        ArrayList<String> arrayList = new ArrayList<String>(this._boxesToSpend.size());
        for (ExtendedInputBox extendedInputBox : this._boxesToSpend) {
            arrayList.add(new ErgoId(extendedInputBox.box().id()).toString());
        }
        return arrayList;
    }

    @Override
    public List<OutBox> getOutputs() {
        ArrayList<OutBox> arrayList = new ArrayList<OutBox>(this._outputs.size());
        for (ErgoBoxCandidate ergoBoxCandidate : this._outputs) {
            arrayList.add(new OutBoxImpl(ergoBoxCandidate));
        }
        return arrayList;
    }

    @Override
    public List<InputBox> getDataInputs() {
        ArrayList<InputBox> arrayList = new ArrayList<InputBox>(this._dataBoxes.size());
        for (ErgoBox ergoBox : this._dataBoxes) {
            arrayList.add(new InputBoxImpl(ergoBox));
        }
        return arrayList;
    }

    @Override
    public ErgoAddress getChangeAddress() {
        return this._changeAddress;
    }

    @Override
    @Nonnull
    public List<ErgoToken> getTokensToBurn() {
        return this._tokensToBurn;
    }

    @Override
    public String toJson(boolean bl) {
        return this.toJson(bl, true);
    }

    @Override
    public String toJson(boolean bl, boolean bl2) {
        UnsignedErgoTransaction unsignedErgoTransaction = (UnsignedErgoTransaction)ScalaBridge.isoUnsignedErgoTransaction().from((Object)this._tx);
        if (bl) {
            for (ErgoTransactionOutput object2 : unsignedErgoTransaction.getOutputs()) {
                Values.ErgoTree ergoTree = (Values.ErgoTree)ScalaBridge.isoStringToErgoTree().to((Object)object2.getErgoTree());
                object2.ergoTree(ergoTree.toString());
            }
        }
        Gson gson = bl || bl2 ? JSON.createGson().setPrettyPrinting().create() : JSON.createGson().create();
        String string = gson.toJson((Object)unsignedErgoTransaction);
        return string;
    }
}

