/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.explorer.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class TokenInfo {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="boxId")
    private String boxId = null;
    @SerializedName(value="emissionAmount")
    private Long emissionAmount = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="decimals")
    private Integer decimals = null;

    public TokenInfo id(String string) {
        this.id = string;
        return this;
    }

    @Schema(required=true, description="ID of the asset")
    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public TokenInfo boxId(String string) {
        this.boxId = string;
        return this;
    }

    @Schema(required=true, description="Box ID this asset was issued by")
    public String getBoxId() {
        return this.boxId;
    }

    public void setBoxId(String string) {
        this.boxId = string;
    }

    public TokenInfo emissionAmount(Long l) {
        this.emissionAmount = l;
        return this;
    }

    @Schema(required=true, description="Number of decimal places")
    public Long getEmissionAmount() {
        return this.emissionAmount;
    }

    public void setEmissionAmount(Long l) {
        this.emissionAmount = l;
    }

    public TokenInfo name(String string) {
        this.name = string;
        return this;
    }

    @Schema(description="Name of the asset")
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public TokenInfo description(String string) {
        this.description = string;
        return this;
    }

    @Schema(description="Description of the asset")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public TokenInfo type(String string) {
        this.type = string;
        return this;
    }

    @Schema(description="Asset type (token standard)")
    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public TokenInfo decimals(Integer n) {
        this.decimals = n;
        return this;
    }

    @Schema(description="Number of decimal places")
    public Integer getDecimals() {
        return this.decimals;
    }

    public void setDecimals(Integer n) {
        this.decimals = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TokenInfo tokenInfo = (TokenInfo)object;
        return Objects.equals(this.id, tokenInfo.id) && Objects.equals(this.boxId, tokenInfo.boxId) && Objects.equals(this.emissionAmount, tokenInfo.emissionAmount) && Objects.equals(this.name, tokenInfo.name) && Objects.equals(this.description, tokenInfo.description) && Objects.equals(this.type, tokenInfo.type) && Objects.equals(this.decimals, tokenInfo.decimals);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.boxId, this.emissionAmount, this.name, this.description, this.type, this.decimals);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class TokenInfo {\n");
        stringBuilder.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        stringBuilder.append("    boxId: ").append(this.toIndentedString(this.boxId)).append("\n");
        stringBuilder.append("    emissionAmount: ").append(this.toIndentedString(this.emissionAmount)).append("\n");
        stringBuilder.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        stringBuilder.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        stringBuilder.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        stringBuilder.append("    decimals: ").append(this.toIndentedString(this.decimals)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

