/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.wallet.secrets;

import io.circe.Decoder;
import io.circe.parser.package$;
import java.io.File;
import java.io.Serializable;
import org.ergoplatform.wallet.crypto.AES$;
import org.ergoplatform.wallet.secrets.EncryptedSecret$EncryptedSecretDecoder$;
import org.ergoplatform.wallet.secrets.ExtendedSecretKey;
import org.ergoplatform.wallet.secrets.ExtendedSecretKey$;
import org.ergoplatform.wallet.secrets.JsonSecretStorage$;
import org.ergoplatform.wallet.secrets.SecretStorage;
import org.ergoplatform.wallet.settings.EncryptionSettings;
import org.ergoplatform.wallet.settings.SecretStorageSettings;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scorex.util.encode.Base16$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001B\t\u0013\u0005mA\u0001B\n\u0001\u0003\u0006\u0004%\ta\n\u0005\ta\u0001\u0011\t\u0011)A\u0005Q!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007C\u00039\u0001\u0011\u0005\u0011\bC\u0004>\u0001\u0001\u0007I\u0011\u0002 \t\u000f\u0015\u0003\u0001\u0019!C\u0005\r\"1A\n\u0001Q!\n}BQ!\u0014\u0001\u0005B9CQA\u0015\u0001\u0005ByBQa\u0015\u0001\u0005BQCQ\u0001\u001b\u0001\u0005B%<QA\u001b\n\t\u0002-4Q!\u0005\n\t\u00021DQ\u0001O\u0007\u0005\u00025DQA\\\u0007\u0005\u0002=DQA`\u0007\u0005\u0002}\u0014\u0011CS:p]N+7M]3u'R|'/Y4f\u0015\t\u0019B#A\u0004tK\u000e\u0014X\r^:\u000b\u0005U1\u0012AB<bY2,GO\u0003\u0002\u00181\u0005aQM]4pa2\fGOZ8s[*\t\u0011$A\u0002pe\u001e\u001c\u0001aE\u0002\u00019\t\u0002\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011a!\u00118z%\u00164\u0007CA\u0012%\u001b\u0005\u0011\u0012BA\u0013\u0013\u00055\u0019Vm\u0019:fiN#xN]1hK\u0006Q1/Z2sKR4\u0015\u000e\\3\u0016\u0003!\u0002\"!\u000b\u0018\u000e\u0003)R!a\u000b\u0017\u0002\u0005%|'\"A\u0017\u0002\t)\fg/Y\u0005\u0003_)\u0012AAR5mK\u0006Y1/Z2sKR4\u0015\u000e\\3!\u0003I)gn\u0019:zaRLwN\\*fiRLgnZ:\u0011\u0005M2T\"\u0001\u001b\u000b\u0005U\"\u0012\u0001C:fiRLgnZ:\n\u0005]\"$AE#oGJL\b\u000f^5p]N+G\u000f^5oON\fa\u0001P5oSRtDc\u0001\u001e<yA\u00111\u0005\u0001\u0005\u0006M\u0011\u0001\r\u0001\u000b\u0005\u0006c\u0011\u0001\rAM\u0001\u000fk:dwnY6fIN+7M]3u+\u0005y\u0004cA\u000fA\u0005&\u0011\u0011I\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\r\u001a\u0015B\u0001#\u0013\u0005E)\u0005\u0010^3oI\u0016$7+Z2sKR\\U-_\u0001\u0013k:dwnY6fIN+7M]3u?\u0012*\u0017\u000f\u0006\u0002H\u0015B\u0011Q\u0004S\u0005\u0003\u0013z\u0011A!\u00168ji\"91JBA\u0001\u0002\u0004y\u0014a\u0001=%c\u0005yQO\u001c7pG.,GmU3de\u0016$\b%\u0001\u0005jg2{7m[3e+\u0005y\u0005CA\u000fQ\u0013\t\tfDA\u0004C_>dW-\u00198\u0002\rM,7M]3u\u0003\u0019)h\u000e\\8dWR\u0011Qk\u0017\t\u0004-f;U\"A,\u000b\u0005as\u0012\u0001B;uS2L!AW,\u0003\u0007Q\u0013\u0018\u0010C\u0003]\u0015\u0001\u0007Q,\u0001\u0003qCN\u001c\bC\u00010f\u001d\ty6\r\u0005\u0002a=5\t\u0011M\u0003\u0002c5\u00051AH]8pizJ!\u0001\u001a\u0010\u0002\rA\u0013X\rZ3g\u0013\t1wM\u0001\u0004TiJLgn\u001a\u0006\u0003Iz\tA\u0001\\8dWR\tq)A\tKg>t7+Z2sKR\u001cFo\u001c:bO\u0016\u0004\"aI\u0007\u0014\u00055aB#A6\u0002\t%t\u0017\u000e\u001e\u000b\u0004aVlHC\u0001\u001er\u0011\u0015)t\u00021\u0001s!\t\u00194/\u0003\u0002ui\t)2+Z2sKR\u001cFo\u001c:bO\u0016\u001cV\r\u001e;j]\u001e\u001c\b\"\u0002<\u0010\u0001\u00049\u0018\u0001B:fK\u0012\u00042!\b={\u0013\tIhDA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001ew&\u0011AP\b\u0002\u0005\u0005f$X\rC\u0003]\u001f\u0001\u0007Q,A\u0004sKN$xN]3\u0015\u0011\u0005\u0005\u0011QAA\u0005\u0003\u001f!2AOA\u0002\u0011\u0015)\u0004\u00031\u0001s\u0011\u0019\t9\u0001\u0005a\u0001;\u0006AQN\\3n_:L7\rC\u0004\u0002\fA\u0001\r!!\u0004\u0002\u001f5tW-\\8oS\u000e\u0004\u0016m]:PaR\u00042!\b!^\u0011\u0019\t\t\u0002\u0005a\u0001;\u0006qQM\\2ssB$\u0018n\u001c8QCN\u001c\b")
public final class JsonSecretStorage
implements SecretStorage {
    private final File secretFile;
    private final EncryptionSettings encryptionSettings;
    private Option<ExtendedSecretKey> unlockedSecret;

    public static JsonSecretStorage restore(String string, Option<String> option, String string2, SecretStorageSettings secretStorageSettings) {
        return JsonSecretStorage$.MODULE$.restore(string, option, string2, secretStorageSettings);
    }

    public static JsonSecretStorage init(byte[] byArray, String string, SecretStorageSettings secretStorageSettings) {
        return JsonSecretStorage$.MODULE$.init(byArray, string, secretStorageSettings);
    }

    @Override
    public File secretFile() {
        return this.secretFile;
    }

    private Option<ExtendedSecretKey> unlockedSecret() {
        return this.unlockedSecret;
    }

    private void unlockedSecret_$eq(Option<ExtendedSecretKey> x$1) {
        this.unlockedSecret = x$1;
    }

    @Override
    public boolean isLocked() {
        return this.unlockedSecret().isEmpty();
    }

    @Override
    public Option<ExtendedSecretKey> secret() {
        return this.unlockedSecret();
    }

    @Override
    public Try<BoxedUnit> unlock(String pass) {
        String secretFileRaw = Source$.MODULE$.fromFile(this.secretFile(), "UTF-8").getLines().mkString();
        return ((Try)package$.MODULE$.decode(secretFileRaw, (Decoder)EncryptedSecret$EncryptedSecretDecoder$.MODULE$).right().map((Function1 & Serializable & scala.Serializable)encryptedSecret -> Base16$.MODULE$.decode(encryptedSecret.cipherText()).flatMap((Function1 & Serializable & scala.Serializable)txt -> Base16$.MODULE$.decode(encryptedSecret.salt()).flatMap((Function1 & Serializable & scala.Serializable)salt -> Base16$.MODULE$.decode(encryptedSecret.iv()).flatMap((Function1 & Serializable & scala.Serializable)iv -> Base16$.MODULE$.decode(encryptedSecret.authTag()).map((Function1 & Serializable & scala.Serializable)tag -> new Tuple4(txt, salt, iv, tag))))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            byte[] cipherText = (byte[])tuple4._1();
            byte[] salt = (byte[])tuple4._2();
            byte[] iv = (byte[])tuple4._3();
            byte[] tag = (byte[])tuple4._4();
            Try<byte[]> try_ = AES$.MODULE$.decrypt(cipherText, pass, salt, iv, tag, $this.encryptionSettings);
            return try_;
        })).fold((Function1 & Serializable & scala.Serializable)x$1 -> new Failure((Throwable)x$1), (Function1 & Serializable & scala.Serializable)x$2 -> new Success(x$2))).flatten(Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)seed -> {
            this.unlockedSecret_$eq((Option<ExtendedSecretKey>)new Some((Object)ExtendedSecretKey$.MODULE$.deriveMasterKey(seed)));
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void lock() {
        this.unlockedSecret().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.zeroSecret();
            return BoxedUnit.UNIT;
        });
        this.unlockedSecret_$eq((Option<ExtendedSecretKey>)None$.MODULE$);
    }

    public JsonSecretStorage(File secretFile, EncryptionSettings encryptionSettings) {
        this.secretFile = secretFile;
        this.encryptionSettings = encryptionSettings;
        this.unlockedSecret = None$.MODULE$;
    }
}

