/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.wallet.transactions;

import java.io.Serializable;
import org.ergoplatform.DataInput;
import org.ergoplatform.ErgoAddress;
import org.ergoplatform.ErgoBox;
import org.ergoplatform.ErgoBoxAssets;
import org.ergoplatform.ErgoBoxCandidate;
import org.ergoplatform.ErgoBoxCandidate$;
import org.ergoplatform.ErgoScriptPredef$;
import org.ergoplatform.UnsignedErgoLikeTransaction;
import org.ergoplatform.UnsignedInput;
import org.ergoplatform.wallet.AssetUtils$;
import org.ergoplatform.wallet.boxes.BoxSelector;
import org.ergoplatform.wallet.boxes.DefaultBoxSelector$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;
import scalan.RType$;
import scorex.crypto.hash.package;
import scorex.util.package$;
import sigmastate.Values;
import sigmastate.eval.Extensions$;
import special.collection.Coll;
import supertagged.package;

public final class TransactionBuilder$ {
    public static TransactionBuilder$ MODULE$;

    static {
        new TransactionBuilder$();
    }

    public Map<String, Object> collectOutputTokens(Seq<ErgoBoxCandidate> outputCandidates) {
        return AssetUtils$.MODULE$.mergeAssets((Map<String, Object>)Predef$.MODULE$.Map().empty(), (Seq<Map<String, Object>>)((Seq)outputCandidates.map((Function1 & Serializable & scala.Serializable)b -> MODULE$.collTokensToMap((Coll<Tuple2<byte[], Object>>)b.additionalTokens()), Seq$.MODULE$.canBuildFrom())));
    }

    public Map<String, Object> collTokensToMap(Coll<Tuple2<byte[], Object>> tokens) {
        return ((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens.toArray())).toSeq().map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.bytesToId((byte[])t._1())), (Object)BoxesRunTime.boxToLong((long)t._2$mcJ$sp())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Coll<Tuple2<byte[], Object>> tokensMapToColl(Map<String, Object> tokens) {
        return Extensions$.MODULE$.ArrayOps(((TraversableOnce)tokens.toSeq().map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(package.Digest32$.MODULE$.$at$at((Object)package$.MODULE$.idToBytes((String)t._1()), package.Tagger$.MODULE$.baseRaw())), (Object)BoxesRunTime.boxToLong((long)t._2$mcJ$sp())), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class)), RType$.MODULE$.pairRType(sigmastate.eval.package$.MODULE$.Digest32RType(), RType$.MODULE$.LongType())).toColl();
    }

    private void validateStatelessChecks(IndexedSeq<ErgoBox> inputs, IndexedSeq<DataInput> dataInputs, Seq<ErgoBoxCandidate> outputCandidates) {
        Predef$.MODULE$.require(inputs.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "inputs cannot be empty");
        Predef$.MODULE$.require(outputCandidates.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "outputCandidates cannot be empty");
        Predef$.MODULE$.require(inputs.size() <= Short.MAX_VALUE, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("too many inputs - ").append(inputs.size()).append(" (max ").append(Short.MAX_VALUE).append(")").toString());
        Predef$.MODULE$.require(dataInputs.size() <= Short.MAX_VALUE, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("too many dataInputs - ").append(dataInputs.size()).append(" (max ").append(Short.MAX_VALUE).append(")").toString());
        Predef$.MODULE$.require(outputCandidates.size() <= Short.MAX_VALUE, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("too many outputCandidates - ").append(outputCandidates.size()).append(" (max ").append(Short.MAX_VALUE).append(")").toString());
        Predef$.MODULE$.require(outputCandidates.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionBuilder$.$anonfun$validateStatelessChecks$6(x$1))), (Function0 & Serializable & scala.Serializable)() -> "outputCandidate.value must be >= 0");
        Try outputSumTry = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)((TraversableOnce)outputCandidates.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.value()), Seq$.MODULE$.canBuildFrom())).reduce((Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x$3, x$4) -> Math.addExact(x$3, x$4))));
        Predef$.MODULE$.require(outputSumTry.isSuccess(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Sum of transaction output values should not exceed ").append(Long.MAX_VALUE).toString());
        Predef$.MODULE$.require(((SeqLike)inputs.distinct()).size() == inputs.size(), (Function0 & Serializable & scala.Serializable)() -> "There should be no duplicate inputs");
    }

    public Try<UnsignedErgoLikeTransaction> buildUnsignedTx(IndexedSeq<ErgoBox> inputs, IndexedSeq<DataInput> dataInputs, Seq<ErgoBoxCandidate> outputCandidates, int currentHeight, long feeAmount, ErgoAddress changeAddress, long minChangeValue, int minerRewardDelay, Map<String, Object> burnTokens, BoxSelector boxSelector) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Seq seq;
            BoxSelector.BoxSelectionResult v;
            MODULE$.validateStatelessChecks(inputs, dataInputs, outputCandidates);
            Predef$.MODULE$.require(feeAmount > 0L, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("expected fee amount > 0, got ").append(feeAmount).toString());
            long inputTotal = BoxesRunTime.unboxToLong((Object)((TraversableOnce)inputs.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.value()), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            long outputSum = BoxesRunTime.unboxToLong((Object)((TraversableOnce)outputCandidates.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.value()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            long outputTotal = outputSum + feeAmount;
            long changeAmt = inputTotal - outputTotal;
            Predef$.MODULE$.require(changeAmt >= 0L, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("total inputs ").append(inputTotal).append(" is less then total outputs ").append(outputTotal).toString());
            String firstInputBoxId = package$.MODULE$.bytesToId(((ErgoBox)inputs.apply(0)).id());
            Map<String, Object> tokensOut = MODULE$.collectOutputTokens(outputCandidates);
            Map tokensOutNoMinted = tokensOut.filterKeys((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TransactionBuilder$.$anonfun$buildUnsignedTx$6(firstInputBoxId, x$7)));
            int mintedTokensNum = tokensOut.size() - tokensOutNoMinted.size();
            Predef$.MODULE$.require(mintedTokensNum <= 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Only one token can be minted, but found ").append(mintedTokensNum).toString());
            Predef$.MODULE$.require(burnTokens.values().forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$8 -> x$8 > 0L), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Incorrect burnTokens specification, positive values are expected: ").append(burnTokens).toString());
            Map<String, Object> tokensOutWithBurned = AssetUtils$.MODULE$.mergeAssets((Map<String, Object>)tokensOutNoMinted, (Seq<Map<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{burnTokens}));
            Either either = boxSelector.select(inputs.toIterator(), outputTotal, tokensOutWithBurned);
            if (either instanceof Left) {
                Left left = (Left)either;
                BoxSelector.BoxSelectionError err = (BoxSelector.BoxSelectionError)left.value();
                throw new IllegalArgumentException(new StringBuilder(92).append("failed to calculate change for outputTotal: ").append(outputTotal).append(", \ntokens: ").append(tokensOut).append(", \nburnTokens: ").append(burnTokens).append(", \ninputs: ").append(inputs).append(", \nreason: ").append(err).toString());
            }
            if (!(either instanceof Right)) {
                throw new MatchError(either);
            }
            Right right = (Right)either;
            BoxSelector.BoxSelectionResult boxSelectionResult = v = (BoxSelector.BoxSelectionResult)right.value();
            BoxSelector.BoxSelectionResult selection = boxSelectionResult;
            Seq seq2 = selection.boxes();
            IndexedSeq indexedSeq = inputs;
            Predef$.MODULE$.assert(!(seq2 != null ? !seq2.equals(indexedSeq) : indexedSeq != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("unexpected selected boxes, expected: ").append(inputs).append(", got ").append(selection.boxes()).toString());
            Seq<ErgoBoxAssets> changeBoxes = selection.changeBoxes();
            boolean changeBoxesHaveTokens = changeBoxes.exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TransactionBuilder$.$anonfun$buildUnsignedTx$11(x$9)));
            boolean noChange = changeAmt < minChangeValue && !changeBoxesHaveTokens;
            long actualFee = noChange ? feeAmount + changeAmt : feeAmount;
            ErgoBoxCandidate feeOut = new ErgoBoxCandidate(actualFee, ErgoScriptPredef$.MODULE$.feeProposition(minerRewardDelay), currentHeight, ErgoBoxCandidate$.MODULE$.$lessinit$greater$default$4(), ErgoBoxCandidate$.MODULE$.$lessinit$greater$default$5());
            if (!noChange) {
                Values.ErgoTree script = changeAddress.script();
                seq = (Seq)changeBoxes.map((Function1 & Serializable & scala.Serializable)cb -> new ErgoBoxCandidate(cb.value(), script, currentHeight, MODULE$.tokensMapToColl((Map<String, Object>)cb.tokens()), ErgoBoxCandidate$.MODULE$.$lessinit$greater$default$5()), Seq$.MODULE$.canBuildFrom());
            } else {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
            Seq addedChangeOut = seq;
            Seq finalOutputCandidates = (Seq)((TraversableLike)outputCandidates.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ErgoBoxCandidate[]{feeOut})), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)addedChangeOut, Seq$.MODULE$.canBuildFrom());
            return new UnsignedErgoLikeTransaction((IndexedSeq)inputs.map((Function1 & Serializable & scala.Serializable)b -> new UnsignedInput(b.id()), IndexedSeq$.MODULE$.canBuildFrom()), dataInputs, (IndexedSeq)finalOutputCandidates.toIndexedSeq());
        });
    }

    public Map<String, Object> buildUnsignedTx$default$9() {
        return Predef$.MODULE$.Map().empty();
    }

    public BoxSelector buildUnsignedTx$default$10() {
        return DefaultBoxSelector$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$validateStatelessChecks$6(ErgoBoxCandidate x$1) {
        return x$1.value() >= 0L;
    }

    public static final /* synthetic */ boolean $anonfun$buildUnsignedTx$6(String firstInputBoxId$1, String x$7) {
        String string = x$7;
        String string2 = firstInputBoxId$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$buildUnsignedTx$11(ErgoBoxAssets x$9) {
        return x$9.tokens().nonEmpty();
    }

    private TransactionBuilder$() {
        MODULE$ = this;
    }
}

