/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.wallet.secrets;

import io.circe.Encoder;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.UUID;
import org.ergoplatform.wallet.crypto.AES$;
import org.ergoplatform.wallet.interface4j.SecretString;
import org.ergoplatform.wallet.mnemonic.Mnemonic$;
import org.ergoplatform.wallet.secrets.EncryptedSecret;
import org.ergoplatform.wallet.secrets.EncryptedSecret$;
import org.ergoplatform.wallet.secrets.EncryptedSecret$EncryptedSecretEncoder$;
import org.ergoplatform.wallet.secrets.JsonSecretStorage;
import org.ergoplatform.wallet.settings.SecretStorageSettings;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scorex.utils.Random$;

public final class JsonSecretStorage$ {
    public static JsonSecretStorage$ MODULE$;

    static {
        new JsonSecretStorage$();
    }

    public JsonSecretStorage init(byte[] seed, SecretString pass, boolean usePre1627KeyDerivation, SecretStorageSettings settings) {
        byte[] iv = Random$.MODULE$.randomBytes(AES$.MODULE$.NonceBitsLen() / 8);
        byte[] salt = Random$.MODULE$.randomBytes(32);
        Tuple2<byte[], byte[]> tuple2 = AES$.MODULE$.encrypt(seed, pass.getData(), salt, iv, settings.encryption());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        byte[] ciphertext = (byte[])tuple2._1();
        byte[] tag = (byte[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)ciphertext, (Object)tag);
        Tuple2 tuple23 = tuple22;
        byte[] ciphertext2 = (byte[])tuple23._1();
        byte[] tag2 = (byte[])tuple23._2();
        EncryptedSecret encryptedSecret = EncryptedSecret$.MODULE$.apply(ciphertext2, salt, iv, tag2, settings.encryption(), (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)usePre1627KeyDerivation)));
        UUID uuid = UUID.nameUUIDFromBytes(ciphertext2);
        new File(settings.secretDir()).mkdirs();
        File file = new File(new StringBuilder(6).append(settings.secretDir()).append("/").append(uuid).append(".json").toString());
        PrintWriter outWriter = new PrintWriter(file);
        String jsonRaw = package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)encryptedSecret), (Encoder)EncryptedSecret$EncryptedSecretEncoder$.MODULE$).noSpaces();
        outWriter.write(jsonRaw);
        outWriter.close();
        pass.erase();
        Arrays.fill(seed, (byte)0);
        return new JsonSecretStorage(file, settings.encryption());
    }

    public JsonSecretStorage restore(SecretString mnemonic, Option<SecretString> mnemonicPassOpt, SecretString encryptionPass, SecretStorageSettings settings, boolean usePre1627KeyDerivation) {
        byte[] seed = Mnemonic$.MODULE$.toSeed(mnemonic, mnemonicPassOpt);
        return this.init(seed, encryptionPass, usePre1627KeyDerivation, settings);
    }

    public Try<JsonSecretStorage> readFile(SecretStorageSettings settings) {
        Failure failure;
        File dir = new File(settings.secretDir());
        if (dir.exists()) {
            Success success;
            List list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())).toList();
            if (list.size() > 1) {
                Success success2;
                List jsonFiles = (List)list.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)JsonSecretStorage$.$anonfun$readFile$1(x$5)));
                Option option = jsonFiles.headOption();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    File headFile = (File)some.value();
                    success2 = new Success((Object)new JsonSecretStorage(headFile, settings.encryption()));
                } else if (None$.MODULE$.equals(option)) {
                    success2 = new Failure((Throwable)new Exception(new StringBuilder(29).append("No json files found in dir '").append(dir).append("'").toString()));
                } else {
                    throw new MatchError((Object)option);
                }
                success = success2;
            } else if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                File headFile = (File)colon2.head();
                success = new Success((Object)new JsonSecretStorage(headFile, settings.encryption()));
            } else if (Nil$.MODULE$.equals(list)) {
                success = new Failure((Throwable)new Exception(new StringBuilder(57).append("Cannot readSecretStorage: Secret file not found in dir '").append(dir).append("'").toString()));
            } else {
                throw new MatchError((Object)list);
            }
            failure = success;
        } else {
            failure = new Failure((Throwable)new FileNotFoundException(new StringBuilder(46).append("Cannot readSecretStorage: dir '").append(dir).append("' doesn't exist").toString()));
        }
        return failure;
    }

    public static final /* synthetic */ boolean $anonfun$readFile$1(File x$5) {
        return x$5.getName().contains(".json");
    }

    private JsonSecretStorage$() {
        MODULE$ = this;
    }
}

