/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.wallet.crypto;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.ergoplatform.wallet.settings.EncryptionSettings;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.util.Try;
import scala.util.Try$;

public final class AES$ {
    public static AES$ MODULE$;
    private final int AuthTagBitsLen;
    private final int NonceBitsLen;
    private final String CipherAlgo;
    private final String CipherAlgoInstance;

    static {
        new AES$();
    }

    public int AuthTagBitsLen() {
        return this.AuthTagBitsLen;
    }

    public int NonceBitsLen() {
        return this.NonceBitsLen;
    }

    public String CipherAlgo() {
        return this.CipherAlgo;
    }

    public String CipherAlgoInstance() {
        return this.CipherAlgoInstance;
    }

    public Tuple2<byte[], byte[]> encrypt(byte[] data, String pass, byte[] salt, byte[] iv, EncryptionSettings settings) {
        Predef$.MODULE$.require(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(data)).nonEmpty(), (Function0 & java.io.Serializable & Serializable)() -> "Empty data encryption attempt");
        SecretKeySpec keySpec = this.deriveEncryptionKeySpec(pass, salt, settings);
        GCMParameterSpec paramsSpec = new GCMParameterSpec(this.AuthTagBitsLen(), iv);
        Cipher cipher = Cipher.getInstance(this.CipherAlgoInstance());
        cipher.init(1, (Key)keySpec, paramsSpec);
        Tuple2 tuple2 = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(cipher.doFinal(data))).splitAt(this.AuthTagBitsLen() / 8);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        byte[] authTag = (byte[])tuple2._1();
        byte[] ciphertext = (byte[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)authTag, (Object)ciphertext);
        Tuple2 tuple23 = tuple22;
        byte[] authTag2 = (byte[])tuple23._1();
        byte[] ciphertext2 = (byte[])tuple23._2();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ciphertext2), (Object)authTag2);
    }

    public Try<byte[]> decrypt(byte[] ciphertext, String pass, byte[] salt, byte[] iv, byte[] authTag, EncryptionSettings settings) {
        Predef$.MODULE$.require(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(ciphertext)).nonEmpty(), (Function0 & java.io.Serializable & Serializable)() -> "Empty ciphertext decryption attempt");
        SecretKeySpec keySpec = this.deriveEncryptionKeySpec(pass, salt, settings);
        GCMParameterSpec paramsSpec = new GCMParameterSpec(this.AuthTagBitsLen(), iv);
        Cipher cipher = Cipher.getInstance(this.CipherAlgoInstance());
        cipher.init(2, (Key)keySpec, paramsSpec);
        return Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> cipher.doFinal((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(authTag)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(ciphertext)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()))));
    }

    private SecretKeySpec deriveEncryptionKeySpec(String pass, byte[] salt, EncryptionSettings settings) {
        PBEKeySpec pbeSpec = new PBEKeySpec(pass.toCharArray(), salt, settings.c(), settings.dkLen());
        SecretKeyFactory skf = SecretKeyFactory.getInstance(new StringBuilder(10).append("PBKDF2With").append(settings.prf()).toString());
        byte[] encryptionKey = skf.generateSecret(pbeSpec).getEncoded();
        return new SecretKeySpec(encryptionKey, this.CipherAlgo());
    }

    private AES$() {
        MODULE$ = this;
        this.AuthTagBitsLen = 128;
        this.NonceBitsLen = 96;
        this.CipherAlgo = "AES";
        this.CipherAlgoInstance = new StringBuilder(14).append(this.CipherAlgo()).append("/GCM/NoPadding").toString();
    }
}

