/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.wallet.secrets;

import io.circe.Encoder;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.UUID;
import org.ergoplatform.wallet.crypto.AES$;
import org.ergoplatform.wallet.mnemonic.Mnemonic$;
import org.ergoplatform.wallet.secrets.EncryptedSecret;
import org.ergoplatform.wallet.secrets.EncryptedSecret$;
import org.ergoplatform.wallet.secrets.EncryptedSecret$EncryptedSecretEncoder$;
import org.ergoplatform.wallet.secrets.JsonSecretStorage;
import org.ergoplatform.wallet.settings.SecretStorageSettings;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scorex.utils.Random$;

public final class JsonSecretStorage$ {
    public static JsonSecretStorage$ MODULE$;

    static {
        new JsonSecretStorage$();
    }

    public JsonSecretStorage init(byte[] seed, String pass, SecretStorageSettings settings) {
        byte[] iv = Random$.MODULE$.randomBytes(AES$.MODULE$.NonceBitsLen() / 8);
        byte[] salt = Random$.MODULE$.randomBytes(32);
        Tuple2<byte[], byte[]> tuple2 = AES$.MODULE$.encrypt(seed, pass, salt, iv, settings.encryption());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        byte[] ciphertext = (byte[])tuple2._1();
        byte[] tag = (byte[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)ciphertext, (Object)tag);
        Tuple2 tuple23 = tuple22;
        byte[] ciphertext2 = (byte[])tuple23._1();
        byte[] tag2 = (byte[])tuple23._2();
        EncryptedSecret encryptedSecret = EncryptedSecret$.MODULE$.apply(ciphertext2, salt, iv, tag2, settings.encryption());
        UUID uuid = UUID.nameUUIDFromBytes(ciphertext2);
        new File(settings.secretDir()).mkdirs();
        File file = new File(new StringBuilder(6).append(settings.secretDir()).append("/").append(uuid).append(".json").toString());
        PrintWriter outWriter = new PrintWriter(file);
        String jsonRaw = package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)encryptedSecret), (Encoder)EncryptedSecret$EncryptedSecretEncoder$.MODULE$).noSpaces();
        outWriter.write(jsonRaw);
        outWriter.close();
        Arrays.fill(seed, (byte)0);
        return new JsonSecretStorage(file, settings.encryption());
    }

    public JsonSecretStorage restore(String mnemonic, Option<String> mnemonicPassOpt, String encryptionPass, SecretStorageSettings settings) {
        byte[] seed = Mnemonic$.MODULE$.toSeed(mnemonic, mnemonicPassOpt);
        return this.init(seed, encryptionPass, settings);
    }

    public Try<JsonSecretStorage> readFile(SecretStorageSettings settings) {
        Failure failure;
        File dir = new File(settings.secretDir());
        if (dir.exists()) {
            Failure failure2;
            List list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())).toList();
            if (list.size() > 1) {
                failure2 = new Failure((Throwable)new Exception(new StringBuilder(32).append("Ambiguous secret files in dir '").append(dir).append("'").toString()));
            } else if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                File headFile = (File)colon2.head();
                failure2 = new Success((Object)new JsonSecretStorage(headFile, settings.encryption()));
            } else if (Nil$.MODULE$.equals(list)) {
                failure2 = new Failure((Throwable)new Exception(new StringBuilder(57).append("Cannot readSecretStorage: Secret file not found in dir '").append(dir).append("'").toString()));
            } else {
                throw new MatchError((Object)list);
            }
            failure = failure2;
        } else {
            failure = new Failure((Throwable)new Exception(new StringBuilder(53).append("Cannot readSecretStorage: Secret dir '").append(dir).append("' doesn't exist").toString()));
        }
        return failure;
    }

    private JsonSecretStorage$() {
        MODULE$ = this;
    }
}

