/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.wallet.secrets;

import io.circe.Decoder;
import io.circe.parser.package$;
import java.io.File;
import java.io.Serializable;
import org.ergoplatform.wallet.crypto.AES$;
import org.ergoplatform.wallet.mnemonic.Mnemonic$;
import org.ergoplatform.wallet.secrets.EncryptedSecret$EncryptedSecretDecoder$;
import org.ergoplatform.wallet.secrets.ExtendedSecretKey;
import org.ergoplatform.wallet.secrets.ExtendedSecretKey$;
import org.ergoplatform.wallet.secrets.JsonSecretStorage$;
import org.ergoplatform.wallet.secrets.SecretStorage;
import org.ergoplatform.wallet.settings.EncryptionSettings;
import org.ergoplatform.wallet.settings.SecretStorageSettings;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scorex.util.encode.Base16$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\n\u0015\u0005uA\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\te\u0001\u0011\t\u0011)A\u0005U!A1\u0007\u0001B\u0001B\u0003%A\u0007C\u0003;\u0001\u0011\u00051\bC\u0004@\u0001\u0001\u0007I\u0011\u0002!\t\u000f\u001d\u0003\u0001\u0019!C\u0005\u0011\"1a\n\u0001Q!\n\u0005CQa\u0014\u0001\u0005BACQ\u0001\u0016\u0001\u0005B\u0001CQ!\u0016\u0001\u0005BYCQa\u001a\u0001\u0005B!DQ!\u001d\u0001\u0005BI<Qa\u001d\u000b\t\u0002Q4Qa\u0005\u000b\t\u0002UDQA\u000f\b\u0005\u0002YDQa\u001e\b\u0005\u0002aDq!a\u0004\u000f\t\u0003\t\t\u0002C\u0004\u0002\u001e9!\t!a\b\u0003#)\u001bxN\\*fGJ,Go\u0015;pe\u0006<WM\u0003\u0002\u0016-\u000591/Z2sKR\u001c(BA\f\u0019\u0003\u00199\u0018\r\u001c7fi*\u0011\u0011DG\u0001\rKJ<w\u000e\u001d7bi\u001a|'/\u001c\u0006\u00027\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\b\u0013\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g!\t)c%D\u0001\u0015\u0013\t9CCA\u0007TK\u000e\u0014X\r^*u_J\fw-Z\u0001\u000bg\u0016\u001c'/\u001a;GS2,W#\u0001\u0016\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013AA5p\u0015\u0005y\u0013\u0001\u00026bm\u0006L!!\r\u0017\u0003\t\u0019KG.Z\u0001\fg\u0016\u001c'/\u001a;GS2,\u0007%\u0001\nf]\u000e\u0014\u0018\u0010\u001d;j_:\u001cV\r\u001e;j]\u001e\u001c\bCA\u001b9\u001b\u00051$BA\u001c\u0017\u0003!\u0019X\r\u001e;j]\u001e\u001c\u0018BA\u001d7\u0005I)en\u0019:zaRLwN\\*fiRLgnZ:\u0002\rqJg.\u001b;?)\raTH\u0010\t\u0003K\u0001AQ\u0001\u000b\u0003A\u0002)BQa\r\u0003A\u0002Q\na\"\u001e8m_\u000e\\W\rZ*fGJ,G/F\u0001B!\ry\"\tR\u0005\u0003\u0007\u0002\u0012aa\u00149uS>t\u0007CA\u0013F\u0013\t1ECA\tFqR,g\u000eZ3e'\u0016\u001c'/\u001a;LKf\f!#\u001e8m_\u000e\\W\rZ*fGJ,Go\u0018\u0013fcR\u0011\u0011\n\u0014\t\u0003?)K!a\u0013\u0011\u0003\tUs\u0017\u000e\u001e\u0005\b\u001b\u001a\t\t\u00111\u0001B\u0003\rAH%M\u0001\u0010k:dwnY6fIN+7M]3uA\u0005A\u0011n\u001d'pG.,G-F\u0001R!\ty\"+\u0003\u0002TA\t9!i\\8mK\u0006t\u0017AB:fGJ,G/A\u0005dQ\u0016\u001c7nU3fIR\u0019\u0011k\u00163\t\u000baS\u0001\u0019A-\u0002\u00115tW-\\8oS\u000e\u0004\"AW1\u000f\u0005m{\u0006C\u0001/!\u001b\u0005i&B\u00010\u001d\u0003\u0019a$o\\8u}%\u0011\u0001\rI\u0001\u0007!J,G-\u001a4\n\u0005\t\u001c'AB*ue&twM\u0003\u0002aA!)QM\u0003a\u0001M\u0006yQN\\3n_:L7\rU1tg>\u0003H\u000fE\u0002 \u0005f\u000ba!\u001e8m_\u000e\\GCA5p!\rQW.S\u0007\u0002W*\u0011A\u000eI\u0001\u0005kRLG.\u0003\u0002oW\n\u0019AK]=\t\u000bA\\\u0001\u0019A-\u0002\tA\f7o]\u0001\u0005Y>\u001c7\u000eF\u0001J\u0003EQ5o\u001c8TK\u000e\u0014X\r^*u_J\fw-\u001a\t\u0003K9\u0019\"A\u0004\u0010\u0015\u0003Q\fA!\u001b8jiR!\u0011P`A\u0007)\ta$\u0010C\u00038!\u0001\u00071\u0010\u0005\u00026y&\u0011QP\u000e\u0002\u0016'\u0016\u001c'/\u001a;Ti>\u0014\u0018mZ3TKR$\u0018N\\4t\u0011\u0019y\b\u00031\u0001\u0002\u0002\u0005!1/Z3e!\u0015y\u00121AA\u0004\u0013\r\t)\u0001\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004?\u0005%\u0011bAA\u0006A\t!!)\u001f;f\u0011\u0015\u0001\b\u00031\u0001Z\u0003\u001d\u0011Xm\u001d;pe\u0016$\u0012\u0002PA\n\u0003+\t9\"a\u0007\t\u000ba\u000b\u0002\u0019A-\t\u000b\u0015\f\u0002\u0019\u00014\t\r\u0005e\u0011\u00031\u0001Z\u00039)gn\u0019:zaRLwN\u001c)bgNDQaN\tA\u0002m\f\u0001B]3bI\u001aKG.\u001a\u000b\u0005\u0003C\t\u0019\u0003E\u0002k[rBQa\u000e\nA\u0002m\u0004")
public final class JsonSecretStorage
implements SecretStorage {
    private final File secretFile;
    private final EncryptionSettings encryptionSettings;
    private Option<ExtendedSecretKey> unlockedSecret;

    public static Try<JsonSecretStorage> readFile(SecretStorageSettings secretStorageSettings) {
        return JsonSecretStorage$.MODULE$.readFile(secretStorageSettings);
    }

    public static JsonSecretStorage restore(String string, Option<String> option, String string2, SecretStorageSettings secretStorageSettings) {
        return JsonSecretStorage$.MODULE$.restore(string, option, string2, secretStorageSettings);
    }

    public static JsonSecretStorage init(byte[] byArray, String string, SecretStorageSettings secretStorageSettings) {
        return JsonSecretStorage$.MODULE$.init(byArray, string, secretStorageSettings);
    }

    @Override
    public File secretFile() {
        return this.secretFile;
    }

    private Option<ExtendedSecretKey> unlockedSecret() {
        return this.unlockedSecret;
    }

    private void unlockedSecret_$eq(Option<ExtendedSecretKey> x$1) {
        this.unlockedSecret = x$1;
    }

    @Override
    public boolean isLocked() {
        return this.unlockedSecret().isEmpty();
    }

    @Override
    public Option<ExtendedSecretKey> secret() {
        return this.unlockedSecret();
    }

    @Override
    public boolean checkSeed(String mnemonic, Option<String> mnemonicPassOpt) {
        byte[] seed = Mnemonic$.MODULE$.toSeed(mnemonic, mnemonicPassOpt);
        ExtendedSecretKey secret = ExtendedSecretKey$.MODULE$.deriveMasterKey(seed);
        return BoxesRunTime.unboxToBoolean((Object)this.unlockedSecret().fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)secret.equals(s))));
    }

    @Override
    public Try<BoxedUnit> unlock(String pass) {
        String secretFileRaw = Source$.MODULE$.fromFile(this.secretFile(), "UTF-8").getLines().mkString();
        return ((Try)package$.MODULE$.decode(secretFileRaw, (Decoder)EncryptedSecret$EncryptedSecretDecoder$.MODULE$).right().map((Function1 & Serializable & scala.Serializable)encryptedSecret -> Base16$.MODULE$.decode(encryptedSecret.cipherText()).flatMap((Function1 & Serializable & scala.Serializable)txt -> Base16$.MODULE$.decode(encryptedSecret.salt()).flatMap((Function1 & Serializable & scala.Serializable)salt -> Base16$.MODULE$.decode(encryptedSecret.iv()).flatMap((Function1 & Serializable & scala.Serializable)iv -> Base16$.MODULE$.decode(encryptedSecret.authTag()).map((Function1 & Serializable & scala.Serializable)tag -> new Tuple4(txt, salt, iv, tag))))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            byte[] cipherText = (byte[])tuple4._1();
            byte[] salt = (byte[])tuple4._2();
            byte[] iv = (byte[])tuple4._3();
            byte[] tag = (byte[])tuple4._4();
            Try<byte[]> try_ = AES$.MODULE$.decrypt(cipherText, pass, salt, iv, tag, $this.encryptionSettings);
            return try_;
        })).fold((Function1 & Serializable & scala.Serializable)x$1 -> new Failure((Throwable)x$1), (Function1 & Serializable & scala.Serializable)x$2 -> new Success(x$2))).flatten(Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)seed -> {
            this.unlockedSecret_$eq((Option<ExtendedSecretKey>)new Some((Object)ExtendedSecretKey$.MODULE$.deriveMasterKey(seed)));
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void lock() {
        this.unlockedSecret().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.zeroSecret();
            return BoxedUnit.UNIT;
        });
        this.unlockedSecret_$eq((Option<ExtendedSecretKey>)None$.MODULE$);
    }

    public JsonSecretStorage(File secretFile, EncryptionSettings encryptionSettings) {
        this.secretFile = secretFile;
        this.encryptionSettings = encryptionSettings;
        this.unlockedSecret = None$.MODULE$;
    }
}

