/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.wallet.secrets;

import io.circe.Decoder;
import io.circe.parser.package$;
import java.io.File;
import java.io.Serializable;
import org.ergoplatform.sdk.wallet.secrets.ExtendedSecretKey;
import org.ergoplatform.sdk.wallet.secrets.ExtendedSecretKey$;
import org.ergoplatform.sdk.wallet.settings.EncryptionSettings;
import org.ergoplatform.wallet.crypto.AES$;
import org.ergoplatform.wallet.interface4j.SecretString;
import org.ergoplatform.wallet.mnemonic.Mnemonic$;
import org.ergoplatform.wallet.secrets.EncryptedSecret$EncryptedSecretDecoder$;
import org.ergoplatform.wallet.secrets.JsonSecretStorage$;
import org.ergoplatform.wallet.secrets.SecretStorage;
import org.ergoplatform.wallet.settings.SecretStorageSettings;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple5;
import scala.UninitializedFieldError;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scorex.util.encode.Base16$;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\n\u0015\u0005uA\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\te\u0001\u0011\t\u0011)A\u0005U!A1\u0007\u0001B\u0001B\u0003%A\u0007C\u0003>\u0001\u0011\u0005a\bC\u0004C\u0001\u0001\u0007I\u0011B\"\t\u000f1\u0003\u0001\u0019!C\u0005\u001b\"11\u000b\u0001Q!\n\u0011CQ\u0001\u0016\u0001\u0005BUCQ!\u0017\u0001\u0005B\rCQA\u0017\u0001\u0005BmCQa\u001a\u0001\u0005B!DQ!\u001d\u0001\u0005BI<Qa\u001d\u000b\t\u0002Q4Qa\u0005\u000b\t\u0002UDQ!\u0010\b\u0005\u0002YDQa\u001e\b\u0005\u0002aDq!a\u0006\u000f\t\u0003\tI\u0002C\u0004\u0002(9!\t!!\u000b\u0003#)\u001bxN\\*fGJ,Go\u0015;pe\u0006<WM\u0003\u0002\u0016-\u000591/Z2sKR\u001c(BA\f\u0019\u0003\u00199\u0018\r\u001c7fi*\u0011\u0011DG\u0001\rKJ<w\u000e\u001d7bi\u001a|'/\u001c\u0006\u00027\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\b\u0013\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g!\t)c%D\u0001\u0015\u0013\t9CCA\u0007TK\u000e\u0014X\r^*u_J\fw-Z\u0001\u000bg\u0016\u001c'/\u001a;GS2,W#\u0001\u0016\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013AA5p\u0015\u0005y\u0013\u0001\u00026bm\u0006L!!\r\u0017\u0003\t\u0019KG.Z\u0001\fg\u0016\u001c'/\u001a;GS2,\u0007%\u0001\nf]\u000e\u0014\u0018\u0010\u001d;j_:\u001cV\r\u001e;j]\u001e\u001c\bCA\u001b<\u001b\u00051$BA\u001c9\u0003!\u0019X\r\u001e;j]\u001e\u001c(BA\f:\u0015\tQ\u0004$A\u0002tI.L!\u0001\u0010\u001c\u0003%\u0015s7M]=qi&|gnU3ui&twm]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007}\u0002\u0015\t\u0005\u0002&\u0001!)\u0001\u0006\u0002a\u0001U!)1\u0007\u0002a\u0001i\u0005qQO\u001c7pG.,GmU3de\u0016$X#\u0001#\u0011\u0007})u)\u0003\u0002GA\t1q\n\u001d;j_:\u0004\"\u0001\u0013&\u000e\u0003%S!!\u0006\u001d\n\u0005-K%!E#yi\u0016tG-\u001a3TK\u000e\u0014X\r^&fs\u0006\u0011RO\u001c7pG.,GmU3de\u0016$x\fJ3r)\tq\u0015\u000b\u0005\u0002 \u001f&\u0011\u0001\u000b\t\u0002\u0005+:LG\u000fC\u0004S\r\u0005\u0005\t\u0019\u0001#\u0002\u0007a$\u0013'A\bv]2|7m[3e'\u0016\u001c'/\u001a;!\u0003!I7\u000fT8dW\u0016$W#\u0001,\u0011\u0005}9\u0016B\u0001-!\u0005\u001d\u0011un\u001c7fC:\faa]3de\u0016$\u0018!C2iK\u000e\\7+Z3e)\r1F\f\u001a\u0005\u0006;*\u0001\rAX\u0001\t[:,Wn\u001c8jGB\u0011qLY\u0007\u0002A*\u0011\u0011MF\u0001\fS:$XM\u001d4bG\u0016$$.\u0003\u0002dA\na1+Z2sKR\u001cFO]5oO\")QM\u0003a\u0001M\u0006yQN\\3n_:L7\rU1tg>\u0003H\u000fE\u0002 \u000bz\u000ba!\u001e8m_\u000e\\GCA5p!\rQWNT\u0007\u0002W*\u0011A\u000eI\u0001\u0005kRLG.\u0003\u0002oW\n\u0019AK]=\t\u000bA\\\u0001\u0019\u00010\u0002\tA\f7o]\u0001\u0005Y>\u001c7\u000eF\u0001O\u0003EQ5o\u001c8TK\u000e\u0014X\r^*u_J\fw-\u001a\t\u0003K9\u0019\"A\u0004\u0010\u0015\u0003Q\fA!\u001b8jiR9\u00110!\u0001\u0002\u0012\u0005MACA {\u0011\u00159\u0004\u00031\u0001|!\tah0D\u0001~\u0015\t9d#\u0003\u0002\u0000{\n)2+Z2sKR\u001cFo\u001c:bO\u0016\u001cV\r\u001e;j]\u001e\u001c\bbBA\u0002!\u0001\u0007\u0011QA\u0001\u0005g\u0016,G\rE\u0003 \u0003\u000f\tY!C\u0002\u0002\n\u0001\u0012Q!\u0011:sCf\u00042aHA\u0007\u0013\r\ty\u0001\t\u0002\u0005\u0005f$X\rC\u0003q!\u0001\u0007a\f\u0003\u0004\u0002\u0016A\u0001\rAV\u0001\u0018kN,\u0007K]32mI:4*Z=EKJLg/\u0019;j_:\fqA]3ti>\u0014X\rF\u0006@\u00037\ti\"a\b\u0002$\u0005\u0015\u0002\"B/\u0012\u0001\u0004q\u0006\"B3\u0012\u0001\u00041\u0007BBA\u0011#\u0001\u0007a,\u0001\bf]\u000e\u0014\u0018\u0010\u001d;j_:\u0004\u0016m]:\t\u000b]\n\u0002\u0019A>\t\r\u0005U\u0011\u00031\u0001W\u0003!\u0011X-\u00193GS2,G\u0003BA\u0016\u0003[\u00012A[7@\u0011\u00159$\u00031\u0001|\u0001")
public final class JsonSecretStorage
implements SecretStorage {
    private final File secretFile;
    private final EncryptionSettings encryptionSettings;
    private Option<ExtendedSecretKey> unlockedSecret;
    private volatile boolean bitmap$init$0;

    public static Try<JsonSecretStorage> readFile(SecretStorageSettings secretStorageSettings) {
        return JsonSecretStorage$.MODULE$.readFile(secretStorageSettings);
    }

    public static JsonSecretStorage restore(SecretString secretString, Option<SecretString> option, SecretString secretString2, SecretStorageSettings secretStorageSettings, boolean bl) {
        return JsonSecretStorage$.MODULE$.restore(secretString, option, secretString2, secretStorageSettings, bl);
    }

    public static JsonSecretStorage init(byte[] byArray, SecretString secretString, boolean bl, SecretStorageSettings secretStorageSettings) {
        return JsonSecretStorage$.MODULE$.init(byArray, secretString, bl, secretStorageSettings);
    }

    @Override
    public File secretFile() {
        return this.secretFile;
    }

    private Option<ExtendedSecretKey> unlockedSecret() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/ergo/ergo/ergo-wallet/src/main/scala/org/ergoplatform/wallet/secrets/JsonSecretStorage.scala: 27");
        }
        return this.unlockedSecret;
    }

    private void unlockedSecret_$eq(Option<ExtendedSecretKey> x$1) {
        this.unlockedSecret = x$1;
        this.bitmap$init$0 = true;
    }

    @Override
    public boolean isLocked() {
        return this.unlockedSecret().isEmpty();
    }

    @Override
    public Option<ExtendedSecretKey> secret() {
        return this.unlockedSecret();
    }

    @Override
    public boolean checkSeed(SecretString mnemonic, Option<SecretString> mnemonicPassOpt) {
        return BoxesRunTime.unboxToBoolean((Object)this.unlockedSecret().fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1 & Serializable & scala.Serializable)uSecret -> BoxesRunTime.boxToBoolean((boolean)JsonSecretStorage.$anonfun$checkSeed$2(mnemonic, mnemonicPassOpt, uSecret))));
    }

    @Override
    public Try<BoxedUnit> unlock(SecretString pass) {
        String secretFileRaw = Source$.MODULE$.fromFile(this.secretFile(), "UTF-8").getLines().mkString();
        return ((Try)package$.MODULE$.decode(secretFileRaw, (Decoder)EncryptedSecret$EncryptedSecretDecoder$.MODULE$).right().map((Function1 & Serializable & scala.Serializable)encryptedSecret -> Base16$.MODULE$.decode(encryptedSecret.cipherText()).flatMap((Function1 & Serializable & scala.Serializable)txt -> Base16$.MODULE$.decode(encryptedSecret.salt()).flatMap((Function1 & Serializable & scala.Serializable)salt -> Base16$.MODULE$.decode(encryptedSecret.iv()).flatMap((Function1 & Serializable & scala.Serializable)iv -> Base16$.MODULE$.decode(encryptedSecret.authTag()).map((Function1 & Serializable & scala.Serializable)tag -> new Tuple5(txt, salt, iv, tag, encryptedSecret.usePre1627KeyDerivation()))))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple5 tuple5 = x0$1;
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            byte[] cipherText = (byte[])tuple5._1();
            byte[] salt = (byte[])tuple5._2();
            byte[] iv = (byte[])tuple5._3();
            byte[] tag = (byte[])tuple5._4();
            Option usePre1627KeyDerivation = (Option)tuple5._5();
            Try<byte[]> res = AES$.MODULE$.decrypt(cipherText, pass.getData(), salt, iv, tag, $this.encryptionSettings);
            Try try_ = res.map((Function1 & Serializable & scala.Serializable)seed -> {
                this.unlockedSecret_$eq((Option<ExtendedSecretKey>)new Some((Object)ExtendedSecretKey$.MODULE$.deriveMasterKey(seed, BoxesRunTime.unboxToBoolean((Object)usePre1627KeyDerivation.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true)))));
                return BoxedUnit.UNIT;
            });
            return try_;
        })).fold((Function1 & Serializable & scala.Serializable)x$1 -> new Failure((Throwable)x$1), (Function1 & Serializable & scala.Serializable)x$2 -> new Success(x$2))).flatten(Predef$.MODULE$.$conforms());
    }

    @Override
    public void lock() {
        this.unlockedSecret().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.zeroSecret();
            return BoxedUnit.UNIT;
        });
        this.unlockedSecret_$eq((Option<ExtendedSecretKey>)None$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$checkSeed$2(SecretString mnemonic$1, Option mnemonicPassOpt$1, ExtendedSecretKey uSecret) {
        byte[] seed = Mnemonic$.MODULE$.toSeed(mnemonic$1, (Option<SecretString>)mnemonicPassOpt$1);
        ExtendedSecretKey secret = ExtendedSecretKey$.MODULE$.deriveMasterKey(seed, uSecret.usePre1627KeyDerivation());
        return secret.equals((Object)uSecret);
    }

    public JsonSecretStorage(File secretFile, EncryptionSettings encryptionSettings) {
        this.secretFile = secretFile;
        this.encryptionSettings = encryptionSettings;
        this.unlockedSecret = None$.MODULE$;
        this.bitmap$init$0 = true;
    }
}

