/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.wallet.crypto;

import java.math.BigInteger;
import java.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import scala.Array$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scorex.crypto.hash.Blake2b256$;
import scorex.util.encode.Base16$;
import sigma.crypto.CryptoConstants$;
import sigma.crypto.Platform;
import sigma.serialization.GroupElementSerializer$;

public final class ErgoSignature$ {
    public static ErgoSignature$ MODULE$;

    static {
        new ErgoSignature$();
    }

    public byte[] sign(byte[] msg, BigInt sk) {
        BigInt y = this.genSecret();
        Platform.Ecp pk = CryptoConstants$.MODULE$.dlogGroup().exponentiate(CryptoConstants$.MODULE$.dlogGroup().generator(), sk.bigInteger());
        Platform.Ecp w = CryptoConstants$.MODULE$.dlogGroup().exponentiate(CryptoConstants$.MODULE$.dlogGroup().generator(), y.bigInteger());
        byte[] s = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.genCommitment(pk, w))).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(msg)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
        BigInt c = package$.MODULE$.BigInt().apply(BigIntegers.fromUnsignedByteArray((byte[])this.hf(s)));
        BigInt z = sk.$times(c).$plus(y).$percent(BigInt$.MODULE$.javaBigInteger2bigInt(CryptoConstants$.MODULE$.groupOrder()));
        return (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(BigIntegers.asUnsignedByteArray((int)24, (BigInteger)c.bigInteger()))).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(BigIntegers.asUnsignedByteArray((int)32, (BigInteger)z.bigInteger()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
    }

    public boolean verify(byte[] msg, byte[] signature, Platform.Ecp pk) {
        byte[] cBytes = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(signature)).take(24);
        BigInt c = package$.MODULE$.BigInt().apply(BigIntegers.fromUnsignedByteArray((byte[])cBytes));
        BigInt z = package$.MODULE$.BigInt().apply(BigIntegers.fromUnsignedByteArray((byte[])((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(signature)).takeRight(32))));
        Platform.Ecp a1 = CryptoConstants$.MODULE$.dlogGroup().exponentiate(CryptoConstants$.MODULE$.dlogGroup().generator(), z.bigInteger());
        Platform.Ecp a2 = CryptoConstants$.MODULE$.dlogGroup().exponentiate(pk, c.bigInteger().negate());
        Platform.Ecp w = CryptoConstants$.MODULE$.dlogGroup().multiplyGroupElements(a1, a2);
        byte[] s = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.genCommitment(pk, w))).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(msg)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
        return Arrays.equals(this.hf(s), cBytes);
    }

    public BigInt genSecret() {
        BigInt y;
        while (BoxesRunTime.equalsNumObject((Number)(y = package$.MODULE$.BigInt().apply(BigIntegers.fromUnsignedByteArray((byte[])CryptoConstants$.MODULE$.secureRandomBytes(32)))), (Object)BoxesRunTime.boxToInteger((int)0)) || y.$greater$eq((Object)BigInt$.MODULE$.javaBigInteger2bigInt(CryptoConstants$.MODULE$.groupOrder()))) {
        }
        return y;
    }

    private byte[] hf(byte[] x) {
        return (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(Blake2b256$.MODULE$.hash(x))).take(24);
    }

    private byte[] genCommitment(Platform.Ecp pk, Platform.Ecp w) {
        byte[] prefix = (byte[])Base16$.MODULE$.decode("010027100108cd").get();
        byte[] postfix = (byte[])Base16$.MODULE$.decode("73000021").get();
        byte[] pkBytes = GroupElementSerializer$.MODULE$.toBytes((Object)pk);
        byte[] wBytes = GroupElementSerializer$.MODULE$.toBytes((Object)w);
        return (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(prefix)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(pkBytes)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())))).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(postfix)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())))).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(wBytes)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
    }

    private ErgoSignature$() {
        MODULE$ = this;
    }
}

