/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.wallet.mnemonic;

import java.io.Serializable;
import java.text.Normalizer;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.ergoplatform.sdk.SecretString;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import sigma.crypto.CryptoFacade$;

public final class Mnemonic$ {
    public static Mnemonic$ MODULE$;
    private final Seq<Object> MnemonicSentenceSizes;
    private final Seq<Object> AllowedStrengths;
    private final Seq<Object> AllowedEntropyLengths;
    private final int BitsGroupSize;
    private final String Pbkdf2Algorithm;
    private final int Pbkdf2Iterations;
    private final int Pbkdf2KeyLength;

    static {
        new Mnemonic$();
    }

    public Seq<Object> MnemonicSentenceSizes() {
        return this.MnemonicSentenceSizes;
    }

    public Seq<Object> AllowedStrengths() {
        return this.AllowedStrengths;
    }

    public Seq<Object> AllowedEntropyLengths() {
        return this.AllowedEntropyLengths;
    }

    public int BitsGroupSize() {
        return this.BitsGroupSize;
    }

    public String Pbkdf2Algorithm() {
        return this.Pbkdf2Algorithm;
    }

    public int Pbkdf2Iterations() {
        return this.Pbkdf2Iterations;
    }

    public int Pbkdf2KeyLength() {
        return this.Pbkdf2KeyLength;
    }

    public byte[] toSeed(SecretString mnemonic, Option<SecretString> passOpt) {
        char[] normalizedMnemonic = Normalizer.normalize((CharSequence)Predef$.MODULE$.ArrayCharSequence(mnemonic.getData()), Normalizer.Form.NFKD).toCharArray();
        String normalizedPass = Normalizer.normalize((CharSequence)Predef$.MODULE$.ArrayCharSequence((char[])new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps("mnemonic".toCharArray())).$plus$plus((GenTraversableOnce)new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps((char[])passOpt.fold((Function0 & Serializable & scala.Serializable)() -> "".toCharArray(), (Function1 & Serializable & scala.Serializable)x$2 -> x$2.getData()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Char()))), Normalizer.Form.NFKD);
        passOpt.fold((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}, (Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.erase();
            return BoxedUnit.UNIT;
        });
        PBEKeySpec spec = new PBEKeySpec(normalizedMnemonic, normalizedPass.getBytes(CryptoFacade$.MODULE$.Encoding()), this.Pbkdf2Iterations(), this.Pbkdf2KeyLength());
        SecretKeyFactory skf = SecretKeyFactory.getInstance(this.Pbkdf2Algorithm());
        return skf.generateSecret(spec).getEncoded();
    }

    public Option<SecretString> toSeed$default$2() {
        return None$.MODULE$;
    }

    private Mnemonic$() {
        MODULE$ = this;
        this.MnemonicSentenceSizes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12, 15, 18, 21, 24}));
        this.AllowedStrengths = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{128, 160, 192, 224, 256}));
        this.AllowedEntropyLengths = (Seq)this.AllowedStrengths().map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$1 -> x$1 / 8, Seq$.MODULE$.canBuildFrom());
        this.BitsGroupSize = 11;
        this.Pbkdf2Algorithm = "PBKDF2WithHmacSHA512";
        this.Pbkdf2Iterations = 2048;
        this.Pbkdf2KeyLength = 512;
    }
}

