/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.wallet.secrets;

import io.circe.Decoder;
import io.circe.parser.package$;
import java.io.File;
import java.io.Serializable;
import org.ergoplatform.sdk.SecretString;
import org.ergoplatform.sdk.wallet.secrets.ExtendedSecretKey;
import org.ergoplatform.sdk.wallet.secrets.ExtendedSecretKey$;
import org.ergoplatform.sdk.wallet.settings.EncryptionSettings;
import org.ergoplatform.wallet.crypto.AES$;
import org.ergoplatform.wallet.mnemonic.Mnemonic$;
import org.ergoplatform.wallet.secrets.EncryptedSecret$EncryptedSecretDecoder$;
import org.ergoplatform.wallet.secrets.JsonSecretStorage$;
import org.ergoplatform.wallet.secrets.SecretStorage;
import org.ergoplatform.wallet.settings.SecretStorageSettings;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple5;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scorex.util.encode.Base16$;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\n\u0015\u0005uA\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\te\u0001\u0011\t\u0011)A\u0005U!A1\u0007\u0001B\u0001B\u0003%A\u0007C\u0003>\u0001\u0011\u0005a\bC\u0004C\u0001\u0001\u0007I\u0011B\"\t\u000f1\u0003\u0001\u0019!C\u0005\u001b\"11\u000b\u0001Q!\n\u0011CQ\u0001\u0016\u0001\u0005BUCQ!\u0017\u0001\u0005B\rCQA\u0017\u0001\u0005BmCQ!\u001a\u0001\u0005B\u0019DQa\u001c\u0001\u0005BA<Q!\u001d\u000b\t\u0002I4Qa\u0005\u000b\t\u0002MDQ!\u0010\b\u0005\u0002QDQ!\u001e\b\u0005\u0002YDq!a\u0005\u000f\t\u0003\t)\u0002C\u0004\u0002$9!\t!!\n\u0003#)\u001bxN\\*fGJ,Go\u0015;pe\u0006<WM\u0003\u0002\u0016-\u000591/Z2sKR\u001c(BA\f\u0019\u0003\u00199\u0018\r\u001c7fi*\u0011\u0011DG\u0001\rKJ<w\u000e\u001d7bi\u001a|'/\u001c\u0006\u00027\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\b\u0013\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g!\t)c%D\u0001\u0015\u0013\t9CCA\u0007TK\u000e\u0014X\r^*u_J\fw-Z\u0001\u000bg\u0016\u001c'/\u001a;GS2,W#\u0001\u0016\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013AA5p\u0015\u0005y\u0013\u0001\u00026bm\u0006L!!\r\u0017\u0003\t\u0019KG.Z\u0001\fg\u0016\u001c'/\u001a;GS2,\u0007%\u0001\nf]\u000e\u0014\u0018\u0010\u001d;j_:\u001cV\r\u001e;j]\u001e\u001c\bCA\u001b<\u001b\u00051$BA\u001c9\u0003!\u0019X\r\u001e;j]\u001e\u001c(BA\f:\u0015\tQ\u0004$A\u0002tI.L!\u0001\u0010\u001c\u0003%\u0015s7M]=qi&|gnU3ui&twm]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007}\u0002\u0015\t\u0005\u0002&\u0001!)\u0001\u0006\u0002a\u0001U!)1\u0007\u0002a\u0001i\u0005qQO\u001c7pG.,GmU3de\u0016$X#\u0001#\u0011\u0007})u)\u0003\u0002GA\t1q\n\u001d;j_:\u0004\"\u0001\u0013&\u000e\u0003%S!!\u0006\u001d\n\u0005-K%!E#yi\u0016tG-\u001a3TK\u000e\u0014X\r^&fs\u0006\u0011RO\u001c7pG.,GmU3de\u0016$x\fJ3r)\tq\u0015\u000b\u0005\u0002 \u001f&\u0011\u0001\u000b\t\u0002\u0005+:LG\u000fC\u0004S\r\u0005\u0005\t\u0019\u0001#\u0002\u0007a$\u0013'A\bv]2|7m[3e'\u0016\u001c'/\u001a;!\u0003!I7\u000fT8dW\u0016$W#\u0001,\u0011\u0005}9\u0016B\u0001-!\u0005\u001d\u0011un\u001c7fC:\faa]3de\u0016$\u0018!C2iK\u000e\\7+Z3e)\r1FL\u0019\u0005\u0006;*\u0001\rAX\u0001\t[:,Wn\u001c8jGB\u0011q\fY\u0007\u0002s%\u0011\u0011-\u000f\u0002\r'\u0016\u001c'/\u001a;TiJLgn\u001a\u0005\u0006G*\u0001\r\u0001Z\u0001\u0010[:,Wn\u001c8jGB\u000b7o](qiB\u0019q$\u00120\u0002\rUtGn\\2l)\t9W\u000eE\u0002iW:k\u0011!\u001b\u0006\u0003U\u0002\nA!\u001e;jY&\u0011A.\u001b\u0002\u0004)JL\b\"\u00028\f\u0001\u0004q\u0016\u0001\u00029bgN\fA\u0001\\8dWR\ta*A\tKg>t7+Z2sKR\u001cFo\u001c:bO\u0016\u0004\"!\n\b\u0014\u00059qB#\u0001:\u0002\t%t\u0017\u000e\u001e\u000b\u0007oz\fi!a\u0004\u0015\u0005}B\b\"B\u001c\u0011\u0001\u0004I\bC\u0001>}\u001b\u0005Y(BA\u001c\u0017\u0013\ti8PA\u000bTK\u000e\u0014X\r^*u_J\fw-Z*fiRLgnZ:\t\r}\u0004\u0002\u0019AA\u0001\u0003\u0011\u0019X-\u001a3\u0011\u000b}\t\u0019!a\u0002\n\u0007\u0005\u0015\u0001EA\u0003BeJ\f\u0017\u0010E\u0002 \u0003\u0013I1!a\u0003!\u0005\u0011\u0011\u0015\u0010^3\t\u000b9\u0004\u0002\u0019\u00010\t\r\u0005E\u0001\u00031\u0001W\u0003])8/\u001a)sKF2$gN&fs\u0012+'/\u001b<bi&|g.A\u0004sKN$xN]3\u0015\u0017}\n9\"!\u0007\u0002\u001c\u0005}\u0011\u0011\u0005\u0005\u0006;F\u0001\rA\u0018\u0005\u0006GF\u0001\r\u0001\u001a\u0005\u0007\u0003;\t\u0002\u0019\u00010\u0002\u001d\u0015t7M]=qi&|g\u000eU1tg\")q'\u0005a\u0001s\"1\u0011\u0011C\tA\u0002Y\u000b\u0001B]3bI\u001aKG.\u001a\u000b\u0005\u0003O\tI\u0003E\u0002iW~BQa\u000e\nA\u0002e\u0004")
public final class JsonSecretStorage
implements SecretStorage {
    private final File secretFile;
    private final EncryptionSettings encryptionSettings;
    private Option<ExtendedSecretKey> unlockedSecret;

    public static Try<JsonSecretStorage> readFile(SecretStorageSettings secretStorageSettings) {
        return JsonSecretStorage$.MODULE$.readFile(secretStorageSettings);
    }

    public static JsonSecretStorage restore(SecretString secretString, Option<SecretString> option, SecretString secretString2, SecretStorageSettings secretStorageSettings, boolean bl) {
        return JsonSecretStorage$.MODULE$.restore(secretString, option, secretString2, secretStorageSettings, bl);
    }

    public static JsonSecretStorage init(byte[] byArray, SecretString secretString, boolean bl, SecretStorageSettings secretStorageSettings) {
        return JsonSecretStorage$.MODULE$.init(byArray, secretString, bl, secretStorageSettings);
    }

    @Override
    public File secretFile() {
        return this.secretFile;
    }

    private Option<ExtendedSecretKey> unlockedSecret() {
        return this.unlockedSecret;
    }

    private void unlockedSecret_$eq(Option<ExtendedSecretKey> x$1) {
        this.unlockedSecret = x$1;
    }

    @Override
    public boolean isLocked() {
        return this.unlockedSecret().isEmpty();
    }

    @Override
    public Option<ExtendedSecretKey> secret() {
        return this.unlockedSecret();
    }

    @Override
    public boolean checkSeed(SecretString mnemonic, Option<SecretString> mnemonicPassOpt) {
        return BoxesRunTime.unboxToBoolean((Object)this.unlockedSecret().fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1 & Serializable & scala.Serializable)uSecret -> BoxesRunTime.boxToBoolean((boolean)JsonSecretStorage.$anonfun$checkSeed$2(mnemonic, mnemonicPassOpt, uSecret))));
    }

    @Override
    public Try<BoxedUnit> unlock(SecretString pass) {
        String secretFileRaw = Source$.MODULE$.fromFile(this.secretFile(), "UTF-8").getLines().mkString();
        return ((Try)package$.MODULE$.decode(secretFileRaw, (Decoder)EncryptedSecret$EncryptedSecretDecoder$.MODULE$).right().map((Function1 & Serializable & scala.Serializable)encryptedSecret -> Base16$.MODULE$.decode(encryptedSecret.cipherText()).flatMap((Function1 & Serializable & scala.Serializable)txt -> Base16$.MODULE$.decode(encryptedSecret.salt()).flatMap((Function1 & Serializable & scala.Serializable)salt -> Base16$.MODULE$.decode(encryptedSecret.iv()).flatMap((Function1 & Serializable & scala.Serializable)iv -> Base16$.MODULE$.decode(encryptedSecret.authTag()).map((Function1 & Serializable & scala.Serializable)tag -> new Tuple5(txt, salt, iv, tag, encryptedSecret.usePre1627KeyDerivation()))))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple5 tuple5 = x0$1;
            if (tuple5 != null) {
                byte[] cipherText = (byte[])tuple5._1();
                byte[] salt = (byte[])tuple5._2();
                byte[] iv = (byte[])tuple5._3();
                byte[] tag = (byte[])tuple5._4();
                Option usePre1627KeyDerivation = (Option)tuple5._5();
                Try<byte[]> res = AES$.MODULE$.decrypt(cipherText, pass.getData(), salt, iv, tag, $this.encryptionSettings);
                return res.map((Function1 & Serializable & scala.Serializable)seed -> {
                    this.unlockedSecret_$eq((Option<ExtendedSecretKey>)new Some((Object)ExtendedSecretKey$.MODULE$.deriveMasterKey(seed, BoxesRunTime.unboxToBoolean((Object)usePre1627KeyDerivation.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true)))));
                    return BoxedUnit.UNIT;
                });
            }
            throw new MatchError((Object)tuple5);
        })).fold((Function1 & Serializable & scala.Serializable)x$1 -> new Failure((Throwable)x$1), (Function1 & Serializable & scala.Serializable)x$2 -> new Success(x$2))).flatten(Predef$.MODULE$.$conforms());
    }

    @Override
    public void lock() {
        this.unlockedSecret().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.zeroSecret();
            return BoxedUnit.UNIT;
        });
        this.unlockedSecret_$eq((Option<ExtendedSecretKey>)None$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$checkSeed$2(SecretString mnemonic$1, Option mnemonicPassOpt$1, ExtendedSecretKey uSecret) {
        byte[] seed = Mnemonic$.MODULE$.toSeed(mnemonic$1, (Option<SecretString>)mnemonicPassOpt$1);
        ExtendedSecretKey secret = ExtendedSecretKey$.MODULE$.deriveMasterKey(seed, uSecret.usePre1627KeyDerivation());
        return secret.equals((Object)uSecret);
    }

    public JsonSecretStorage(File secretFile, EncryptionSettings encryptionSettings) {
        this.secretFile = secretFile;
        this.encryptionSettings = encryptionSettings;
        this.unlockedSecret = None$.MODULE$;
    }
}

