/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.wallet.crypto;

import java.math.BigInteger;
import java.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scorex.crypto.hash.Blake2b256$;
import scorex.util.encode.Base16$;
import sigmastate.basics.CryptoConstants$;
import sigmastate.crypto.Platform;
import sigmastate.serialization.GroupElementSerializer$;

public final class ErgoSignature$ {
    public static final ErgoSignature$ MODULE$ = new ErgoSignature$();

    public byte[] sign(byte[] msg, BigInt sk) {
        BigInt y = this.genSecret();
        Platform.Ecp pk = CryptoConstants$.MODULE$.dlogGroup().exponentiate(CryptoConstants$.MODULE$.dlogGroup().generator(), sk.bigInteger());
        Platform.Ecp w = CryptoConstants$.MODULE$.dlogGroup().exponentiate(CryptoConstants$.MODULE$.dlogGroup().generator(), y.bigInteger());
        byte[] s = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.byteArrayOps(this.genCommitment(pk, w)), (Object)msg, (ClassTag)ClassTag$.MODULE$.Byte());
        BigInt c = package$.MODULE$.BigInt().apply(BigIntegers.fromUnsignedByteArray((byte[])this.hf(s)));
        BigInt z = sk.$times(c).$plus(y).$percent(BigInt$.MODULE$.javaBigInteger2bigInt(CryptoConstants$.MODULE$.groupOrder()));
        return (byte[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.byteArrayOps(BigIntegers.asUnsignedByteArray((int)24, (BigInteger)c.bigInteger())), (Object)BigIntegers.asUnsignedByteArray((int)32, (BigInteger)z.bigInteger()), (ClassTag)ClassTag$.MODULE$.Byte());
    }

    public boolean verify(byte[] msg, byte[] signature, Platform.Ecp pk) {
        byte[] cBytes = (byte[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.byteArrayOps(signature), 24);
        BigInt c = package$.MODULE$.BigInt().apply(BigIntegers.fromUnsignedByteArray((byte[])cBytes));
        BigInt z = package$.MODULE$.BigInt().apply(BigIntegers.fromUnsignedByteArray((byte[])((byte[])ArrayOps$.MODULE$.takeRight$extension(Predef$.MODULE$.byteArrayOps(signature), 32))));
        Platform.Ecp a1 = CryptoConstants$.MODULE$.dlogGroup().exponentiate(CryptoConstants$.MODULE$.dlogGroup().generator(), z.bigInteger());
        Platform.Ecp a2 = CryptoConstants$.MODULE$.dlogGroup().exponentiate(pk, c.bigInteger().negate());
        Platform.Ecp w = CryptoConstants$.MODULE$.dlogGroup().multiplyGroupElements(a1, a2);
        byte[] s = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.byteArrayOps(this.genCommitment(pk, w)), (Object)msg, (ClassTag)ClassTag$.MODULE$.Byte());
        return Arrays.equals(this.hf(s), cBytes);
    }

    /*
     * WARNING - void declaration
     */
    public BigInt genSecret() {
        void var2_1;
        BigInt y;
        while (BoxesRunTime.equalsNumObject((Number)(y = package$.MODULE$.BigInt().apply(BigIntegers.fromUnsignedByteArray((byte[])CryptoConstants$.MODULE$.secureRandomBytes(32)))), (Object)BoxesRunTime.boxToInteger((int)0)) || y.$greater$eq((Object)BigInt$.MODULE$.javaBigInteger2bigInt(CryptoConstants$.MODULE$.groupOrder()))) {
        }
        return var2_1;
    }

    private byte[] hf(byte[] x) {
        return (byte[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.byteArrayOps(Blake2b256$.MODULE$.hash(x)), 24);
    }

    private byte[] genCommitment(Platform.Ecp pk, Platform.Ecp w) {
        byte[] prefix = (byte[])Base16$.MODULE$.decode("010027100108cd").get();
        byte[] postfix = (byte[])Base16$.MODULE$.decode("73000021").get();
        byte[] pkBytes = GroupElementSerializer$.MODULE$.toBytes((Object)pk);
        byte[] wBytes = GroupElementSerializer$.MODULE$.toBytes((Object)w);
        return (byte[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.byteArrayOps(prefix), (Object)pkBytes, (ClassTag)ClassTag$.MODULE$.Byte())), (Object)postfix, (ClassTag)ClassTag$.MODULE$.Byte())), (Object)wBytes, (ClassTag)ClassTag$.MODULE$.Byte());
    }

    private ErgoSignature$() {
    }
}

