/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.wallet.crypto;

import java.io.Serializable;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.ergoplatform.sdk.wallet.settings.EncryptionSettings;
import scala.Function0;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.util.Try;
import scala.util.Try$;

public final class AES$ {
    public static final AES$ MODULE$ = new AES$();
    private static final int AuthTagBitsLen = 128;
    private static final int NonceBitsLen;
    private static final String CipherAlgo;
    private static final String CipherAlgoInstance;
    private static volatile byte bitmap$init$0;

    static {
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        NonceBitsLen = 96;
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        CipherAlgo = "AES";
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
        CipherAlgoInstance = new StringBuilder(14).append(MODULE$.CipherAlgo()).append("/GCM/NoPadding").toString();
        bitmap$init$0 = (byte)(bitmap$init$0 | 8);
    }

    public int AuthTagBitsLen() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/ergo/ergo/ergo-wallet/src/main/scala/org/ergoplatform/wallet/crypto/AES.scala: 11");
        }
        return AuthTagBitsLen;
    }

    public int NonceBitsLen() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/ergo/ergo/ergo-wallet/src/main/scala/org/ergoplatform/wallet/crypto/AES.scala: 12");
        }
        return NonceBitsLen;
    }

    public String CipherAlgo() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/ergo/ergo/ergo-wallet/src/main/scala/org/ergoplatform/wallet/crypto/AES.scala: 14");
        }
        return CipherAlgo;
    }

    public String CipherAlgoInstance() {
        if ((byte)(bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/ergo/ergo/ergo-wallet/src/main/scala/org/ergoplatform/wallet/crypto/AES.scala: 15");
        }
        return CipherAlgoInstance;
    }

    public Tuple2<byte[], byte[]> encrypt(byte[] data, char[] pass, byte[] salt, byte[] iv, EncryptionSettings settings) {
        Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.byteArrayOps(data)), (Function0 & Serializable)() -> "Empty data encryption attempt");
        SecretKeySpec keySpec = this.deriveEncryptionKeySpec(pass, salt, settings);
        GCMParameterSpec paramsSpec = new GCMParameterSpec(this.AuthTagBitsLen(), iv);
        Cipher cipher = Cipher.getInstance(this.CipherAlgoInstance());
        cipher.init(1, (Key)keySpec, paramsSpec);
        Tuple2 tuple2 = ArrayOps$.MODULE$.splitAt$extension(Predef$.MODULE$.byteArrayOps(cipher.doFinal(data)), this.AuthTagBitsLen() / 8);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        byte[] authTag = (byte[])tuple2._1();
        byte[] ciphertext = (byte[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)authTag, (Object)ciphertext);
        Tuple2 tuple23 = tuple22;
        byte[] authTag2 = (byte[])tuple23._1();
        byte[] ciphertext2 = (byte[])tuple23._2();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ciphertext2), (Object)authTag2);
    }

    public Try<byte[]> decrypt(byte[] ciphertext, char[] pass, byte[] salt, byte[] iv, byte[] authTag, EncryptionSettings settings) {
        Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.byteArrayOps(ciphertext)), (Function0 & Serializable)() -> "Empty ciphertext decryption attempt");
        SecretKeySpec keySpec = this.deriveEncryptionKeySpec(pass, salt, settings);
        GCMParameterSpec paramsSpec = new GCMParameterSpec(this.AuthTagBitsLen(), iv);
        Cipher cipher = Cipher.getInstance(this.CipherAlgoInstance());
        cipher.init(2, (Key)keySpec, paramsSpec);
        return Try$.MODULE$.apply((Function0 & Serializable)() -> cipher.doFinal((byte[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.byteArrayOps(authTag), (Object)ciphertext, (ClassTag)ClassTag$.MODULE$.Byte())));
    }

    private SecretKeySpec deriveEncryptionKeySpec(char[] pass, byte[] salt, EncryptionSettings settings) {
        PBEKeySpec pbeSpec = new PBEKeySpec(pass, salt, settings.c(), settings.dkLen());
        SecretKeyFactory skf = SecretKeyFactory.getInstance(new StringBuilder(10).append("PBKDF2With").append(settings.prf()).toString());
        byte[] encryptionKey = skf.generateSecret(pbeSpec).getEncoded();
        return new SecretKeySpec(encryptionKey, this.CipherAlgo());
    }

    private AES$() {
    }
}

