/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.wallet.transactions;

import java.io.Serializable;
import java.util.List;
import java7.compat.Math$;
import org.ergoplatform.DataInput;
import org.ergoplatform.ErgoAddress;
import org.ergoplatform.ErgoBox;
import org.ergoplatform.ErgoBoxAssets;
import org.ergoplatform.ErgoBoxCandidate;
import org.ergoplatform.ErgoBoxCandidate$;
import org.ergoplatform.ErgoTreePredef$;
import org.ergoplatform.UnsignedErgoLikeTransaction;
import org.ergoplatform.UnsignedInput;
import org.ergoplatform.sdk.wallet.AssetUtils$;
import org.ergoplatform.wallet.boxes.BoxSelector;
import org.ergoplatform.wallet.boxes.DefaultBoxSelector;
import org.ergoplatform.wallet.boxes.ReemissionData;
import org.ergoplatform.wallet.transactions.TransactionBuilder;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapView;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;
import scorex.crypto.authds.package;
import scorex.util.encode.Base16$;
import scorex.util.package$;
import sigma.Coll;
import sigma.Extensions;
import sigma.data.RType$;
import sigmastate.Values;
import sigmastate.utils.Extensions;
import sigmastate.utils.Extensions$;
import supertagged.utils.Replace$;

public final class TransactionBuilder$ {
    public static final TransactionBuilder$ MODULE$ = new TransactionBuilder$();
    private static volatile byte bitmap$init$0;

    public UnsignedErgoLikeTransaction multiPaymentTransaction(String[] inputIds, long feeAmt, List<TransactionBuilder.Payment> payments, ErgoAddress changeAddress, long changeAmt, int currentHeight) {
        Vector vector;
        ErgoBoxCandidate feeBox = new ErgoBoxCandidate(feeAmt, ErgoTreePredef$.MODULE$.feeProposition(ErgoTreePredef$.MODULE$.feeProposition$default$1()), currentHeight, sigmastate.eval.Extensions$.MODULE$.EvalIterableOps((Iterable)scala.package$.MODULE$.Seq().empty(), RType$.MODULE$.pairRType(sigmastate.eval.package$.MODULE$.Digest32CollRType(), sigma.package$.MODULE$.LongType())).toColl(), (Map)Predef$.MODULE$.Map().empty());
        Vector paymentBoxes = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(payments).asScala()).map((Function1 & Serializable)x0$1 -> {
            TransactionBuilder.Payment payment = x0$1;
            if (payment == null) {
                throw new MatchError((Object)payment);
            }
            ErgoAddress recipientAddress = payment.recipientAddress();
            long transferAmt = payment.transferAmt();
            ErgoBoxCandidate ergoBoxCandidate = new ErgoBoxCandidate(transferAmt, recipientAddress.script(), currentHeight, sigmastate.eval.Extensions$.MODULE$.EvalIterableOps((Iterable)scala.package$.MODULE$.Seq().empty(), RType$.MODULE$.pairRType(sigmastate.eval.package$.MODULE$.Digest32CollRType(), sigma.package$.MODULE$.LongType())).toColl(), (Map)Predef$.MODULE$.Map().empty());
            return ergoBoxCandidate;
        })).toVector();
        if (changeAmt == 0L) {
            vector = (Vector)paymentBoxes.$colon$plus((Object)feeBox);
        } else {
            ErgoBoxCandidate changeBox = new ErgoBoxCandidate(changeAmt, changeAddress.script(), currentHeight, sigmastate.eval.Extensions$.MODULE$.EvalIterableOps((Iterable)scala.package$.MODULE$.Seq().empty(), RType$.MODULE$.pairRType(sigmastate.eval.package$.MODULE$.Digest32CollRType(), sigma.package$.MODULE$.LongType())).toColl(), (Map)Predef$.MODULE$.Map().empty());
            vector = (Vector)paymentBoxes.$plus$plus((IterableOnce)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ErgoBoxCandidate[]{feeBox, changeBox})));
        }
        Vector outputs = vector;
        IndexedSeq unsignedInputs = ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])inputIds), (Function1 & Serializable)id -> Base16$.MODULE$.decode(id).map((Function1 & Serializable)x -> new UnsignedInput((byte[])package.ADKey$.MODULE$.$at$at(x, Replace$.MODULE$.base()))).toOption(), ClassTag$.MODULE$.apply(UnsignedInput.class))));
        return new UnsignedErgoLikeTransaction(unsignedInputs, (IndexedSeq)scala.package$.MODULE$.IndexedSeq().empty(), (IndexedSeq)outputs);
    }

    public UnsignedErgoLikeTransaction paymentTransaction(ErgoAddress recipientAddress, ErgoAddress changeAddress, long transferAmt, long feeAmt, long changeAmt, String[] inputIds, int currentHeight) {
        ErgoBoxCandidate payTo = new ErgoBoxCandidate(transferAmt, recipientAddress.script(), currentHeight, sigmastate.eval.Extensions$.MODULE$.EvalIterableOps((Iterable)scala.package$.MODULE$.Seq().empty(), RType$.MODULE$.pairRType(sigmastate.eval.package$.MODULE$.Digest32CollRType(), sigma.package$.MODULE$.LongType())).toColl(), (Map)Predef$.MODULE$.Map().empty());
        ErgoBoxCandidate fee = new ErgoBoxCandidate(feeAmt, ErgoTreePredef$.MODULE$.feeProposition(ErgoTreePredef$.MODULE$.feeProposition$default$1()), currentHeight, sigmastate.eval.Extensions$.MODULE$.EvalIterableOps((Iterable)scala.package$.MODULE$.Seq().empty(), RType$.MODULE$.pairRType(sigmastate.eval.package$.MODULE$.Digest32CollRType(), sigma.package$.MODULE$.LongType())).toColl(), (Map)Predef$.MODULE$.Map().empty());
        ErgoBoxCandidate change = new ErgoBoxCandidate(changeAmt, changeAddress.script(), currentHeight, sigmastate.eval.Extensions$.MODULE$.EvalIterableOps((Iterable)scala.package$.MODULE$.Seq().empty(), RType$.MODULE$.pairRType(sigmastate.eval.package$.MODULE$.Digest32CollRType(), sigma.package$.MODULE$.LongType())).toColl(), (Map)Predef$.MODULE$.Map().empty());
        IndexedSeq unsignedInputs = ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])inputIds), (Function1 & Serializable)id -> Base16$.MODULE$.decode(id).map((Function1 & Serializable)x -> new UnsignedInput((byte[])package.ADKey$.MODULE$.$at$at(x, Replace$.MODULE$.base()))).toOption(), ClassTag$.MODULE$.apply(UnsignedInput.class))));
        IndexedSeq dataInputs = (IndexedSeq)scala.package$.MODULE$.IndexedSeq().empty();
        IndexedSeq outputs = changeAmt == 0L ? (IndexedSeq)scala.package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ErgoBoxCandidate[]{payTo, fee})) : (IndexedSeq)scala.package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ErgoBoxCandidate[]{payTo, change, fee}));
        return new UnsignedErgoLikeTransaction(unsignedInputs, dataInputs, outputs);
    }

    public scala.collection.immutable.Map<String, Object> collectOutputTokens(Seq<ErgoBoxCandidate> outputCandidates) {
        return AssetUtils$.MODULE$.mergeAssets(Predef$.MODULE$.Map().empty(), (Seq)outputCandidates.map((Function1 & Serializable)b -> MODULE$.collTokensToMap((Coll<Tuple2<Coll<Object>, Object>>)b.additionalTokens())));
    }

    public scala.collection.immutable.Map<String, Object> collTokensToMap(Coll<Tuple2<Coll<Object>, Object>> tokens) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])tokens.toArray()), (Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Extensions.CollBytesOps$.MODULE$.toModifierId$extension(sigma.Extensions$.MODULE$.CollBytesOps((Coll)t._1()))), (Object)BoxesRunTime.boxToLong((long)t._2$mcJ$sp())), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Coll<Tuple2<Coll<Object>, Object>> tokensMapToColl(scala.collection.immutable.Map<String, Object> tokens) {
        return sigmastate.eval.Extensions$.MODULE$.ArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])tokens.toArray(ClassTag$.MODULE$.apply(Tuple2.class))), (Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Extensions.ModifierIdOps$.MODULE$.toTokenId$extension(Extensions$.MODULE$.ModifierIdOps((String)t._1()))), (Object)BoxesRunTime.boxToLong((long)t._2$mcJ$sp())), ClassTag$.MODULE$.apply(Tuple2.class)), RType$.MODULE$.pairRType(sigmastate.eval.package$.MODULE$.Digest32CollRType(), sigma.package$.MODULE$.LongType())).toColl();
    }

    private void validateStatelessChecks(IndexedSeq<ErgoBox> inputs, IndexedSeq<DataInput> dataInputs, Seq<ErgoBoxCandidate> outputCandidates) {
        Predef$.MODULE$.require(inputs.nonEmpty(), (Function0 & Serializable)() -> "inputs cannot be empty");
        Predef$.MODULE$.require(outputCandidates.nonEmpty(), (Function0 & Serializable)() -> "outputCandidates cannot be empty");
        Predef$.MODULE$.require(inputs.size() <= Short.MAX_VALUE, (Function0 & Serializable)() -> new StringBuilder(40).append("too many inputs - ").append(inputs.size()).append(" (max ").append(Short.MAX_VALUE).append(")").toString());
        Predef$.MODULE$.require(dataInputs.size() <= Short.MAX_VALUE, (Function0 & Serializable)() -> new StringBuilder(44).append("too many dataInputs - ").append(dataInputs.size()).append(" (max ").append(Short.MAX_VALUE).append(")").toString());
        Predef$.MODULE$.require(outputCandidates.size() <= Short.MAX_VALUE, (Function0 & Serializable)() -> new StringBuilder(50).append("too many outputCandidates - ").append(outputCandidates.size()).append(" (max ").append(Short.MAX_VALUE).append(")").toString());
        Predef$.MODULE$.require(outputCandidates.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionBuilder$.$anonfun$validateStatelessChecks$6(x$1))), (Function0 & Serializable)() -> "outputCandidate.value must be >= 0");
        Try outputSumTry = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)((IterableOnceOps)outputCandidates.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.value()))).reduce((Function2)(JFunction2.mcJJJ.sp & Serializable)(x$3, x$4) -> Math$.MODULE$.addExact(x$3, x$4))));
        Predef$.MODULE$.require(outputSumTry.isSuccess(), (Function0 & Serializable)() -> new StringBuilder(80).append("Sum of transaction output values should not exceed ").append(Long.MAX_VALUE).toString());
        Predef$.MODULE$.require(((SeqOps)inputs.distinct()).size() == inputs.size(), (Function0 & Serializable)() -> "There should be no duplicate inputs");
    }

    public Try<UnsignedErgoLikeTransaction> buildUnsignedTx(IndexedSeq<ErgoBox> inputs, IndexedSeq<DataInput> dataInputs, Seq<ErgoBoxCandidate> outputCandidates, int currentHeight, Option<Object> createFeeOutput, ErgoAddress changeAddress, long minChangeValue, int minerRewardDelay, scala.collection.immutable.Map<String, Object> burnTokens, BoxSelector boxSelector) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Seq seq;
            BoxSelector.BoxSelectionResult v;
            MODULE$.validateStatelessChecks(inputs, dataInputs, outputCandidates);
            long feeAmount = BoxesRunTime.unboxToLong((Object)createFeeOutput.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
            Predef$.MODULE$.require(BoxesRunTime.unboxToBoolean((Object)createFeeOutput.fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> true, (Function1)(JFunction1.mcZJ.sp & Serializable)x$5 -> x$5 > 0L)), (Function0 & Serializable)() -> new StringBuilder(29).append("expected fee amount > 0, got ").append(feeAmount).toString());
            long inputTotal = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)inputs.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.value()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            long outputSum = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)outputCandidates.map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.value()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            long outputTotal = outputSum + feeAmount;
            long changeAmt = inputTotal - outputTotal;
            Predef$.MODULE$.require(changeAmt >= 0L, (Function0 & Serializable)() -> new StringBuilder(41).append("total inputs ").append(inputTotal).append(" is less then total outputs ").append(outputTotal).toString());
            String firstInputBoxId = package$.MODULE$.bytesToId(((ErgoBox)inputs.apply(0)).id());
            scala.collection.immutable.Map<String, Object> tokensOut = MODULE$.collectOutputTokens(outputCandidates);
            MapView tokensOutNoMinted = tokensOut.filterKeys((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TransactionBuilder$.$anonfun$buildUnsignedTx$9(firstInputBoxId, x$8)));
            int mintedTokensNum = tokensOut.size() - tokensOutNoMinted.size();
            Predef$.MODULE$.require(mintedTokensNum <= 1, (Function0 & Serializable)() -> new StringBuilder(40).append("Only one token can be minted, but found ").append(mintedTokensNum).toString());
            Predef$.MODULE$.require(burnTokens.values().forall((Function1)(JFunction1.mcZJ.sp & Serializable)x$9 -> x$9 > 0L), (Function0 & Serializable)() -> new StringBuilder(66).append("Incorrect burnTokens specification, positive values are expected: ").append(burnTokens).toString());
            scala.collection.immutable.Map tokensOutWithBurned = AssetUtils$.MODULE$.mergeAssets(tokensOutNoMinted.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{burnTokens}));
            Either either = boxSelector.select(inputs.toIterator(), outputTotal, (scala.collection.immutable.Map<String, Object>)tokensOutWithBurned);
            if (either instanceof Left) {
                Left left = (Left)either;
                BoxSelector.BoxSelectionError err = (BoxSelector.BoxSelectionError)left.value();
                throw new IllegalArgumentException(new StringBuilder(92).append("failed to calculate change for outputTotal: ").append(outputTotal).append(", \ntokens: ").append(tokensOut).append(", \nburnTokens: ").append(burnTokens).append(", \ninputs: ").append(inputs).append(", \nreason: ").append(err).toString());
            }
            if (!(either instanceof Right)) {
                throw new MatchError(either);
            }
            Right right = (Right)either;
            BoxSelector.BoxSelectionResult boxSelectionResult = v = (BoxSelector.BoxSelectionResult)right.value();
            BoxSelector.BoxSelectionResult selection = boxSelectionResult;
            Seq seq2 = selection.inputBoxes();
            IndexedSeq indexedSeq = inputs;
            Predef$.MODULE$.assert(!(seq2 != null ? !seq2.equals(indexedSeq) : indexedSeq != null), (Function0 & Serializable)() -> new StringBuilder(43).append("unexpected selected boxes, expected: ").append(inputs).append(", got ").append(selection.inputBoxes()).toString());
            Seq<ErgoBoxAssets> changeBoxes = selection.changeBoxes();
            boolean changeBoxesHaveTokens = changeBoxes.exists((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TransactionBuilder$.$anonfun$buildUnsignedTx$14(x$10)));
            boolean changeGoesToFee = changeAmt < minChangeValue && !changeBoxesHaveTokens;
            Predef$.MODULE$.require(!changeGoesToFee || changeAmt == 0L || createFeeOutput.isDefined(), (Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(124).append("When change=").append(changeAmt).append(" < minChangeValue=").append(minChangeValue).append(" it is added to miner's fee,\n        |in this case createFeeOutput should be defined\n        |").toString())));
            Option feeOutOpt = createFeeOutput.map((Function1 & Serializable)fee -> TransactionBuilder$.$anonfun$buildUnsignedTx$16(changeGoesToFee, changeAmt, minerRewardDelay, currentHeight, BoxesRunTime.unboxToLong((Object)fee)));
            if (!changeGoesToFee) {
                Values.ErgoTree script = changeAddress.script();
                seq = (Seq)changeBoxes.map((Function1 & Serializable)cb -> new ErgoBoxCandidate(cb.value(), script, currentHeight, MODULE$.tokensMapToColl((scala.collection.immutable.Map<String, Object>)cb.tokens()), ErgoBoxCandidate$.MODULE$.$lessinit$greater$default$5()));
            } else {
                seq = (Seq)scala.package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$);
            }
            Seq addedChangeOut = seq;
            Seq finalOutputCandidates = (Seq)((IterableOps)outputCandidates.$plus$plus((IterableOnce)feeOutOpt)).$plus$plus((IterableOnce)addedChangeOut);
            return new UnsignedErgoLikeTransaction((IndexedSeq)inputs.map((Function1 & Serializable)b -> new UnsignedInput(b.id())), dataInputs, finalOutputCandidates.toIndexedSeq());
        });
    }

    public scala.collection.immutable.Map<String, Object> buildUnsignedTx$default$9() {
        return Predef$.MODULE$.Map().empty();
    }

    public BoxSelector buildUnsignedTx$default$10() {
        return new DefaultBoxSelector((Option<ReemissionData>)None$.MODULE$);
    }

    public <A, B> Either<A, B> EitherOpsFor211(Either<A, B> source) {
        return source;
    }

    public static final /* synthetic */ boolean $anonfun$validateStatelessChecks$6(ErgoBoxCandidate x$1) {
        return x$1.value() >= 0L;
    }

    public static final /* synthetic */ boolean $anonfun$buildUnsignedTx$9(String firstInputBoxId$1, String x$8) {
        String string = x$8;
        String string2 = firstInputBoxId$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$buildUnsignedTx$14(ErgoBoxAssets x$10) {
        return x$10.tokens().nonEmpty();
    }

    public static final /* synthetic */ ErgoBoxCandidate $anonfun$buildUnsignedTx$16(boolean changeGoesToFee$1, long changeAmt$1, int minerRewardDelay$1, int currentHeight$2, long fee) {
        long actualFee = changeGoesToFee$1 ? fee + changeAmt$1 : fee;
        return new ErgoBoxCandidate(actualFee, ErgoTreePredef$.MODULE$.feeProposition(minerRewardDelay$1), currentHeight$2, ErgoBoxCandidate$.MODULE$.$lessinit$greater$default$4(), ErgoBoxCandidate$.MODULE$.$lessinit$greater$default$5());
    }

    private TransactionBuilder$() {
    }
}

