/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.wallet.secrets;

import io.circe.Decoder;
import io.circe.parser.package$;
import java.io.File;
import java.io.Serializable;
import org.ergoplatform.wallet.crypto.AES$;
import org.ergoplatform.wallet.interface4j.SecretString;
import org.ergoplatform.wallet.mnemonic.Mnemonic$;
import org.ergoplatform.wallet.secrets.EncryptedSecret$EncryptedSecretDecoder$;
import org.ergoplatform.wallet.secrets.ExtendedSecretKey;
import org.ergoplatform.wallet.secrets.ExtendedSecretKey$;
import org.ergoplatform.wallet.secrets.JsonSecretStorage$;
import org.ergoplatform.wallet.secrets.SecretStorage;
import org.ergoplatform.wallet.settings.EncryptionSettings;
import org.ergoplatform.wallet.settings.SecretStorageSettings;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple5;
import scala.UninitializedFieldError;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scorex.util.encode.Base16$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005b\u0001B\n\u0015\u0005uA\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\te\u0001\u0011\t\u0011)A\u0005U!A1\u0007\u0001B\u0001B\u0003%A\u0007C\u0003;\u0001\u0011\u00051\bC\u0004@\u0001\u0001\u0007I\u0011\u0002!\t\u000f\u001d\u0003\u0001\u0019!C\u0005\u0011\"1a\n\u0001Q!\n\u0005CQa\u0014\u0001\u0005BACQ\u0001\u0016\u0001\u0005B\u0001CQ!\u0016\u0001\u0005BYCQA\u0019\u0001\u0005B\rDQ\u0001\u001c\u0001\u0005B5<QA\u001c\u000b\t\u0002=4Qa\u0005\u000b\t\u0002ADQA\u000f\b\u0005\u0002EDQA\u001d\b\u0005\u0002MDq!!\u0003\u000f\t\u0003\tY\u0001C\u0004\u0002\u001a9!\t!a\u0007\u0003#)\u001bxN\\*fGJ,Go\u0015;pe\u0006<WM\u0003\u0002\u0016-\u000591/Z2sKR\u001c(BA\f\u0019\u0003\u00199\u0018\r\u001c7fi*\u0011\u0011DG\u0001\rKJ<w\u000e\u001d7bi\u001a|'/\u001c\u0006\u00027\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\b\u0013\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g!\t)c%D\u0001\u0015\u0013\t9CCA\u0007TK\u000e\u0014X\r^*u_J\fw-Z\u0001\u000bg\u0016\u001c'/\u001a;GS2,W#\u0001\u0016\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013AA5p\u0015\u0005y\u0013\u0001\u00026bm\u0006L!!\r\u0017\u0003\t\u0019KG.Z\u0001\fg\u0016\u001c'/\u001a;GS2,\u0007%\u0001\nf]\u000e\u0014\u0018\u0010\u001d;j_:\u001cV\r\u001e;j]\u001e\u001c\bCA\u001b9\u001b\u00051$BA\u001c\u0017\u0003!\u0019X\r\u001e;j]\u001e\u001c\u0018BA\u001d7\u0005I)en\u0019:zaRLwN\\*fiRLgnZ:\u0002\rqJg.\u001b;?)\raTH\u0010\t\u0003K\u0001AQ\u0001\u000b\u0003A\u0002)BQa\r\u0003A\u0002Q\na\"\u001e8m_\u000e\\W\rZ*fGJ,G/F\u0001B!\ry\"\tR\u0005\u0003\u0007\u0002\u0012aa\u00149uS>t\u0007CA\u0013F\u0013\t1ECA\tFqR,g\u000eZ3e'\u0016\u001c'/\u001a;LKf\f!#\u001e8m_\u000e\\W\rZ*fGJ,Go\u0018\u0013fcR\u0011\u0011\n\u0014\t\u0003?)K!a\u0013\u0011\u0003\tUs\u0017\u000e\u001e\u0005\b\u001b\u001a\t\t\u00111\u0001B\u0003\rAH%M\u0001\u0010k:dwnY6fIN+7M]3uA\u0005A\u0011n\u001d'pG.,G-F\u0001R!\ty\"+\u0003\u0002TA\t9!i\\8mK\u0006t\u0017AB:fGJ,G/A\u0005dQ\u0016\u001c7nU3fIR\u0019\u0011kV0\t\u000baS\u0001\u0019A-\u0002\u00115tW-\\8oS\u000e\u0004\"AW/\u000e\u0003mS!\u0001\u0018\f\u0002\u0017%tG/\u001a:gC\u000e,GG[\u0005\u0003=n\u0013AbU3de\u0016$8\u000b\u001e:j]\u001eDQ\u0001\u0019\u0006A\u0002\u0005\fq\"\u001c8f[>t\u0017n\u0019)bgN|\u0005\u000f\u001e\t\u0004?\tK\u0016AB;oY>\u001c7\u000e\u0006\u0002eUB\u0019Q\r[%\u000e\u0003\u0019T!a\u001a\u0011\u0002\tU$\u0018\u000e\\\u0005\u0003S\u001a\u00141\u0001\u0016:z\u0011\u0015Y7\u00021\u0001Z\u0003\u0011\u0001\u0018m]:\u0002\t1|7m\u001b\u000b\u0002\u0013\u0006\t\"j]8o'\u0016\u001c'/\u001a;Ti>\u0014\u0018mZ3\u0011\u0005\u0015r1C\u0001\b\u001f)\u0005y\u0017\u0001B5oSR$b\u0001^=\u0002\u0004\u0005\u0015AC\u0001\u001fv\u0011\u00159\u0004\u00031\u0001w!\t)t/\u0003\u0002ym\t)2+Z2sKR\u001cFo\u001c:bO\u0016\u001cV\r\u001e;j]\u001e\u001c\b\"\u0002>\u0011\u0001\u0004Y\u0018\u0001B:fK\u0012\u00042a\b?\u007f\u0013\ti\bEA\u0003BeJ\f\u0017\u0010\u0005\u0002 \u007f&\u0019\u0011\u0011\u0001\u0011\u0003\t\tKH/\u001a\u0005\u0006WB\u0001\r!\u0017\u0005\u0007\u0003\u000f\u0001\u0002\u0019A)\u0002/U\u001cX\r\u0015:fcY\u0012tgS3z\t\u0016\u0014\u0018N^1uS>t\u0017a\u0002:fgR|'/\u001a\u000b\fy\u00055\u0011qBA\t\u0003+\t9\u0002C\u0003Y#\u0001\u0007\u0011\fC\u0003a#\u0001\u0007\u0011\r\u0003\u0004\u0002\u0014E\u0001\r!W\u0001\u000fK:\u001c'/\u001f9uS>t\u0007+Y:t\u0011\u00159\u0014\u00031\u0001w\u0011\u0019\t9!\u0005a\u0001#\u0006A!/Z1e\r&dW\r\u0006\u0003\u0002\u001e\u0005}\u0001cA3iy!)qG\u0005a\u0001m\u0002")
public final class JsonSecretStorage
implements SecretStorage {
    private final File secretFile;
    private final EncryptionSettings encryptionSettings;
    private Option<ExtendedSecretKey> unlockedSecret;
    private volatile boolean bitmap$init$0;

    public static Try<JsonSecretStorage> readFile(SecretStorageSettings settings) {
        return JsonSecretStorage$.MODULE$.readFile(settings);
    }

    public static JsonSecretStorage restore(SecretString mnemonic, Option<SecretString> mnemonicPassOpt, SecretString encryptionPass, SecretStorageSettings settings, boolean usePre1627KeyDerivation) {
        return JsonSecretStorage$.MODULE$.restore(mnemonic, mnemonicPassOpt, encryptionPass, settings, usePre1627KeyDerivation);
    }

    public static JsonSecretStorage init(byte[] seed, SecretString pass, boolean usePre1627KeyDerivation, SecretStorageSettings settings) {
        return JsonSecretStorage$.MODULE$.init(seed, pass, usePre1627KeyDerivation, settings);
    }

    @Override
    public File secretFile() {
        return this.secretFile;
    }

    private Option<ExtendedSecretKey> unlockedSecret() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/ergo/ergo/ergo-wallet/src/main/scala/org/ergoplatform/wallet/secrets/JsonSecretStorage.scala: 25");
        }
        return this.unlockedSecret;
    }

    private void unlockedSecret_$eq(Option<ExtendedSecretKey> x$1) {
        this.unlockedSecret = x$1;
        this.bitmap$init$0 = true;
    }

    @Override
    public boolean isLocked() {
        return this.unlockedSecret().isEmpty();
    }

    @Override
    public Option<ExtendedSecretKey> secret() {
        return this.unlockedSecret();
    }

    @Override
    public boolean checkSeed(SecretString mnemonic, Option<SecretString> mnemonicPassOpt) {
        return BoxesRunTime.unboxToBoolean((Object)this.unlockedSecret().fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1 & Serializable)uSecret -> BoxesRunTime.boxToBoolean((boolean)JsonSecretStorage.$anonfun$checkSeed$2(mnemonic, mnemonicPassOpt, uSecret))));
    }

    @Override
    public Try<BoxedUnit> unlock(SecretString pass) {
        String secretFileRaw = Source$.MODULE$.fromFile(this.secretFile(), "UTF-8").getLines().mkString();
        return ((Try)package$.MODULE$.decode(secretFileRaw, (Decoder)EncryptedSecret$EncryptedSecretDecoder$.MODULE$).right().map((Function1 & Serializable)encryptedSecret -> Base16$.MODULE$.decode(encryptedSecret.cipherText()).flatMap((Function1 & Serializable)txt -> Base16$.MODULE$.decode(encryptedSecret.salt()).flatMap((Function1 & Serializable)salt -> Base16$.MODULE$.decode(encryptedSecret.iv()).flatMap((Function1 & Serializable)iv -> Base16$.MODULE$.decode(encryptedSecret.authTag()).map((Function1 & Serializable)tag -> new Tuple5(txt, salt, iv, tag, encryptedSecret.usePre1627KeyDerivation()))))).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple5 tuple5 = x0$1;
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            byte[] cipherText = (byte[])tuple5._1();
            byte[] salt = (byte[])tuple5._2();
            byte[] iv = (byte[])tuple5._3();
            byte[] tag = (byte[])tuple5._4();
            Option usePre1627KeyDerivation = (Option)tuple5._5();
            Try<byte[]> res = AES$.MODULE$.decrypt(cipherText, pass.getData(), salt, iv, tag, $this.encryptionSettings);
            Try try_ = res.map((Function1 & Serializable)seed -> {
                this.unlockedSecret_$eq((Option<ExtendedSecretKey>)new Some((Object)ExtendedSecretKey$.MODULE$.deriveMasterKey(seed, BoxesRunTime.unboxToBoolean((Object)usePre1627KeyDerivation.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true)))));
                return BoxedUnit.UNIT;
            });
            return try_;
        })).fold((Function1 & Serializable)x$1 -> new Failure((Throwable)x$1), (Function1 & Serializable)x$2 -> new Success(x$2))).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public void lock() {
        this.unlockedSecret().foreach((Function1 & Serializable)x$3 -> {
            x$3.zeroSecret();
            return BoxedUnit.UNIT;
        });
        this.unlockedSecret_$eq((Option<ExtendedSecretKey>)None$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$checkSeed$2(SecretString mnemonic$1, Option mnemonicPassOpt$1, ExtendedSecretKey uSecret) {
        byte[] seed = Mnemonic$.MODULE$.toSeed(mnemonic$1, (Option<SecretString>)mnemonicPassOpt$1);
        ExtendedSecretKey secret = ExtendedSecretKey$.MODULE$.deriveMasterKey(seed, uSecret.usePre1627KeyDerivation());
        return secret.equals(uSecret);
    }

    public JsonSecretStorage(File secretFile, EncryptionSettings encryptionSettings) {
        this.secretFile = secretFile;
        this.encryptionSettings = encryptionSettings;
        this.unlockedSecret = None$.MODULE$;
        this.bitmap$init$0 = true;
    }
}

