/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.wallet.interface4j;

import java.util.Arrays;

public final class SecretString {
    private final char[] _data;
    private boolean _erased;

    private void checkErased() {
        if (this._erased) {
            throw new RuntimeException("SecretString already erased");
        }
    }

    SecretString(char[] cArray) {
        this._data = cArray;
        this._erased = false;
    }

    public boolean isEmpty() {
        this.checkErased();
        return this._data == null || this._data.length == 0;
    }

    public char[] getData() {
        this.checkErased();
        return this._data;
    }

    public void erase() {
        Arrays.fill(this._data, ' ');
        this._erased = true;
    }

    public boolean isErased() {
        return this._erased;
    }

    public int hashCode() {
        this.checkErased();
        return Arrays.hashCode(this._data);
    }

    public boolean equals(Object object) {
        this.checkErased();
        if (this == object) {
            return true;
        }
        if (object instanceof SecretString) {
            SecretString secretString = (SecretString)object;
            int n = this._data.length;
            if (n == secretString._data.length) {
                char[] cArray = this._data;
                char[] cArray2 = secretString._data;
                int n2 = 0;
                while (n-- != 0) {
                    if (cArray[n2] != cArray2[n2]) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        }
        return false;
    }

    public static SecretString create(char[] cArray) {
        return new SecretString(cArray);
    }

    public static SecretString create(String string) {
        return new SecretString(string.toCharArray());
    }

    public static SecretString empty() {
        return new SecretString(new char[0]);
    }

    public String toStringUnsecure() {
        this.checkErased();
        return String.valueOf(this._data);
    }
}

