package org.eroq.pathmatcher;

public class PathKey {
	
	private Object name;
	private String prefix;
	private String delimiter;
	private boolean optional;
	private boolean repeat;
	private String pattern;
	
	public PathKey(Object name, String prefix, String delimiter, boolean optional, boolean repeat, String pattern) {
		this.name = name;
		this.prefix = prefix;
		this.delimiter = delimiter;
		this.optional = optional;
		this.repeat = repeat;
		this.pattern = pattern;
	}
	public Object getName() {
		return name;
	}
	public void setName(Object name) {
		this.name = name;
	}
	public String getPrefix() {
		return prefix;
	}
	public void setPrefix(String prefix) {
		this.prefix = prefix;
	}
	public String getDelimiter() {
		return delimiter;
	}
	public void setDelimiter(String delimiter) {
		this.delimiter = delimiter;
	}
	public boolean isOptional() {
		return optional;
	}
	public void setOptional(boolean optional) {
		this.optional = optional;
	}
	public boolean isRepeat() {
		return repeat;
	}
	public void setRepeat(boolean repeat) {
		this.repeat = repeat;
	}
	public String getPattern() {
		return pattern;
	}
	public void setPattern(String pattern) {
		this.pattern = pattern;
	}
	
	@Override
	public String toString() {
		return "Key [name=" + name + ", prefix=" + prefix + ", delimiter=" + delimiter + ", optional=" + optional
				+ ", repeat=" + repeat + ", pattern=" + pattern + "]";
	}
	@Override
	public boolean equals(Object obj) {
		if(!(obj instanceof PathKey)) {
			return false;
		}
		PathKey pathKeyObj = (PathKey) obj;
		boolean result = true;
		result &= name.equals(pathKeyObj.name);
		result &= prefix.equals(pathKeyObj.prefix);
		result &= delimiter.equals(pathKeyObj.delimiter);
		result &= optional == pathKeyObj.optional;
		result &= repeat == pathKeyObj.repeat;
		result &= pattern.equals(pathKeyObj.pattern);
		return result;
	}

	
	
	
}