/*
 * Decompiled with CFR 0.152.
 */
package org.eroq.pathmatcher;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eroq.pathmatcher.PathKey;

public class PathMatcher {
    private Pattern pattern;
    private List<PathKey> keys = new ArrayList<PathKey>();
    private static final Pattern PATH_REGEXP = Pattern.compile("(\\\\.)|([\\/.])?(?:(?:\\:(\\w+)(?:\\(((?:\\\\.|[^()])+)\\))?|\\(((?:\\\\.|[^()])+)\\))([+*?])?|(\\*))");

    public PathMatcher(String path, boolean sensitive, boolean strict, boolean end) {
        List<Object> tokens = this.parse(path);
        this.pattern = this.tokensToRegExp(tokens, sensitive, strict, end);
        for (Object token : tokens) {
            if (token instanceof String) continue;
            this.keys.add((PathKey)token);
        }
    }

    public PathMatcher(Pattern pattern) {
        this.pattern = pattern;
        Pattern p = Pattern.compile("\\((?!\\?)");
        Matcher m = p.matcher(pattern.pattern());
        Integer key = 0;
        while (m.find()) {
            Integer n = key;
            Integer n2 = key = Integer.valueOf(key + 1);
            this.keys.add(new PathKey(n, null, null, false, false, null));
        }
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public List<PathKey> getKeys() {
        return this.keys;
    }

    private Pattern tokensToRegExp(List<Object> tokens, boolean sensitive, boolean strict, boolean end) {
        String route = "";
        Object lastToken = tokens.get(tokens.size() - 1);
        boolean endsWithSlash = lastToken instanceof String && Pattern.matches("\\/$", (String)lastToken);
        for (Object token : tokens) {
            if (token instanceof String) {
                String stringToken = (String)token;
                route = route + this.escapeString(stringToken);
                continue;
            }
            PathKey keyToken = (PathKey)token;
            String prefix = this.escapeString(keyToken.getPrefix());
            String capture = keyToken.getPattern();
            if (keyToken.isRepeat()) {
                capture = capture + "(?:" + prefix + capture + ")*";
            }
            capture = keyToken.isOptional() ? (!prefix.isEmpty() ? "(?:" + prefix + "(" + capture + "))?" : "(" + capture + ")?") : prefix + "(" + capture + ")";
            route = route + capture;
        }
        if (!strict) {
            route = (endsWithSlash ? route.substring(0, route.length() - 1) : route) + "(?:\\/(?=$))?";
        }
        route = end ? route + "$" : route + (strict && endsWithSlash ? "" : "(?=\\/|$)");
        return Pattern.compile("^" + route, sensitive ? 0 : 2);
    }

    private List<Object> parse(String string) {
        ArrayList<Object> tokens = new ArrayList<Object>();
        int key = 0;
        int index = 0;
        String path = "";
        Matcher matcher = PATH_REGEXP.matcher(string);
        while (matcher.find()) {
            String delimiter;
            String escaped = matcher.group(1);
            int offset = matcher.start();
            path = path + string.substring(index, offset);
            index = matcher.end();
            if (escaped != null && !escaped.isEmpty()) {
                path = path + escaped.charAt(1);
                continue;
            }
            if (!path.isEmpty()) {
                tokens.add(path);
                path = "";
            }
            String prefix = matcher.group(2);
            String name = matcher.group(3);
            String capture = matcher.group(4);
            String group = matcher.group(5);
            String suffix = matcher.group(6);
            String asterisk = matcher.group(7);
            boolean repeat = suffix != null && (suffix.equals("+") || suffix.equals("*"));
            boolean optional = suffix != null && (suffix.equals("?") || suffix.equals("*"));
            String string2 = delimiter = prefix != null ? prefix : "/";
            String pattern = capture != null ? capture : (group != null ? group : (asterisk != null ? ".*" : "[^" + delimiter + "]+?"));
            tokens.add(new PathKey(name != null ? name : Integer.valueOf(key++), prefix != null ? prefix : "", delimiter, optional, repeat, this.escapeGroup(pattern)));
        }
        if (index < string.length()) {
            path = path + string.substring(index);
        }
        if (!path.isEmpty()) {
            tokens.add(path);
        }
        return tokens;
    }

    private String escapeString(String string) {
        return string.replace("([.+*?=^!:${}()[\\]|\\/])", "\\$1");
    }

    private String escapeGroup(String group) {
        return group.replace("([=!:$\\/()])", "\\$1");
    }

    public String toString() {
        StringBuilder repr = new StringBuilder();
        repr.append("Pattern: ");
        repr.append(this.pattern);
        repr.append(" Keys: [");
        for (PathKey key : this.keys) {
            repr.append(key);
        }
        repr.append("]");
        return repr.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PathMatcher)) {
            return false;
        }
        PathMatcher pathMatcherObj = (PathMatcher)obj;
        boolean result = true;
        result &= this.pattern.pattern().equals(pathMatcherObj.pattern.pattern());
        if (!(result &= this.keys.size() == pathMatcherObj.keys.size())) {
            return false;
        }
        for (int i = 0; i < this.keys.size() && (result &= this.keys.get(i).equals(pathMatcherObj.keys.get(i))); ++i) {
        }
        return result;
    }
}

