package org.eroq.router;

import java.net.URLConnection;
import java.util.List;

import org.eroq.http.HttpContext;

public class AppHttpContext extends HttpContext implements Cloneable {

	public AppHttpContext(HttpContext ctx, App app) {
		super(ctx);
		setAttribute("app", app);
		setResponseHeader("Content-Type", "text/html; charset=utf-8");
	}
	
	public AppHttpContext createTemporaryContext() {
		AppHttpContext temporaryContext = null;
		try {
			temporaryContext = (AppHttpContext) this.clone();
		} catch (CloneNotSupportedException e) {
			e.printStackTrace();
		}
		return temporaryContext;
	}
	
	public App getApp() {
		return (App)getAttribute("app");
	}

	public RouteParams getParams() {
		return (RouteParams)getAttribute("params");
	}
	
	private String guessContentTypeFromType(String type) {
		String guessedContentType = URLConnection.guessContentTypeFromName("x."+type);
		if(guessedContentType != null) {
			return guessedContentType;
		}
		return type;
	}

	public boolean is(String type) {
		String requestBodyContentType = getFirstValueForRequestHeader("Content-Type");
		if(requestBodyContentType == null) {
			return false;
		}
		String contentType = guessContentTypeFromType(type);
		return requestBodyContentType.equalsIgnoreCase(contentType);
	}

	public boolean accepts(String type) {
		List<String> acceptedResponseTypes = getAllValuesForRequestHeader("Accept");
		if(acceptedResponseTypes == null) {
			return false;
		}
		String contentType = guessContentTypeFromType(type);
		for(String acceptedResponseType: acceptedResponseTypes) {
			if(acceptedResponseType.toLowerCase().contains(contentType.toLowerCase())) {
				return true;
			}
		}
		return false;
	}

}
