package org.eroq.router;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RouteParams {
	
	public static interface RouteParamsForEachCallback {
		void call(Object key, List<String> values);
	}
	
	List<Object> keys = new ArrayList<>();
	Map<Object, List<String>> items = new HashMap<>();

	public void add(Object key, String value) {
		List<String> itemsForKey = items.get(key);
		if(itemsForKey == null) {
			itemsForKey = new ArrayList<>();
			items.put(key, itemsForKey);
			keys.add(key);
		}
		itemsForKey.add(value);
	}
	
	public List<String> getAll(String key) {
		return getAll((Object)key);		
	}
	public List<String> getAll(Integer key) {
		return getAll((Object)key);
	}
	public List<String> getAll(Object key) {
		return items.get(key);
	}
	public String getFirst(String key) {
		return getFirst((Object)key);		
	}
	public String getFirst(Integer key) {
		return getFirst((Object)key);
	}
	public String getFirst(Object key) {
		List<String> itemsForKey = items.get(key);
		if(itemsForKey == null) {
			return null;
		}
		return itemsForKey.get(0);
	}
	public String getLast(String key) {
		return getLast((Object)key);		
	}
	public String getLast(Integer key) {
		return getLast((Object)key);
	}
	public String getLast(Object key) {
		List<String> itemsForKey = items.get(key);
		if(itemsForKey == null) {
			return null;
		}
		return itemsForKey.get(itemsForKey.size()-1);
	}
	public List<Object> keys() {
		return keys;
	}

	@Override
	public String toString() {
		return "RouteParams [items=" + items + "]";
	}
	
}
