/*
 * Decompiled with CFR 0.152.
 */
package org.eroq.router;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.eroq.http.Http;
import org.eroq.http.HttpStatus;
import org.eroq.router.AppHttpContext;
import org.eroq.router.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class App
extends Router {
    private static Logger logger = LoggerFactory.getLogger(App.class);
    private long startTime;

    public App() {
        this.init();
        this.loadDefaultProperties();
        this.initProperties("app.properties");
        this.printCurrentProperties();
    }

    public App(String propertiesFile) {
        this.init();
        this.loadDefaultProperties();
        this.initProperties(propertiesFile);
        this.printCurrentProperties();
    }

    public App(URL propertiesFileURL) {
        this.init();
        this.loadDefaultProperties();
        this.initProperties(propertiesFileURL);
        this.printCurrentProperties();
    }

    public App(InputStream propertiesInputStream) {
        this.init();
        this.loadDefaultProperties();
        this.initProperties(propertiesInputStream);
        this.printCurrentProperties();
    }

    private void init() {
        this.startTime = System.nanoTime();
        logger.info("App starting");
    }

    private void done(Http.HttpServer server) {
        int durationInMicroSeconds = Math.round((float)(System.nanoTime() - this.startTime) / 1000.0f);
        logger.info("App started in {}s at http://{}:{}", new Object[]{String.format("%.3f", Float.valueOf((float)durationInMicroSeconds / 1000000.0f)), server.getHost(), server.getPort()});
    }

    private void loadDefaultProperties() {
        logger.debug("Set default properties");
        this.properties = new Properties();
        this.properties.setProperty("eroq.profile", "development");
        this.properties.setProperty("eroq.server.host", "127.0.0.1");
        this.properties.setProperty("eroq.server.port", "1980");
    }

    private void initProperties(String propertiesFileName) {
        if (propertiesFileName != null) {
            logger.debug("Looking in the classpath for a file named '" + propertiesFileName + "'");
            this.initProperties(Thread.currentThread().getContextClassLoader().getResource(propertiesFileName));
        } else {
            logger.debug("No file name provided");
        }
    }

    private void initProperties(URL propertiesFileURL) {
        InputStream propertiesInputStream = null;
        if (propertiesFileURL != null) {
            logger.debug("Found properties at " + propertiesFileURL.toString());
            try {
                propertiesInputStream = propertiesFileURL.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.initProperties(propertiesInputStream);
        } else {
            logger.debug("Could not find properties");
        }
    }

    private void initProperties(InputStream propertiesInputStream) {
        if (propertiesInputStream != null) {
            logger.debug("Opened properties input stream");
            try {
                this.properties.load(propertiesInputStream);
                logger.debug("Loaded properties successfully");
            }
            catch (IOException e) {
                throw new Error("Could not load properties", e);
            }
        } else {
            logger.debug("Could not open properties input stream");
        }
    }

    private void printCurrentProperties() {
        logger.debug("Active application properties:");
        for (Object key : this.properties.keySet()) {
            Object value = this.properties.get(key);
            logger.debug("\t{} = {}", key, value);
        }
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    private void request(AppHttpContext ctx) throws Exception {
        this.run(ctx, () -> {
            ctx.setStatus(HttpStatus.NOT_FOUND);
            ctx.setBody("Cannot " + ctx.getMethod() + " " + ctx.getPath());
        });
    }

    public void listen(Integer port, String host, Http.HttpServerListenCallback listenCallback) {
        Http.HttpServer httpServer = Http.createServer(ctx -> {
            AppHttpContext appCtx = new AppHttpContext(ctx, this);
            try {
                this.request(appCtx);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        httpServer.listen(port, host, server -> {
            this.done(server);
            if (listenCallback != null) {
                listenCallback.call(server);
            }
        });
    }

    public void listen(Http.HttpServerListenCallback listenCallback) {
        String host = this.properties.getProperty("eroq.server.host");
        Integer port = Integer.valueOf(this.properties.getProperty("eroq.server.port"));
        this.listen(port, host, listenCallback);
    }

    public void listen(Integer port, String host) {
        this.listen(port, host, null);
    }

    public void listen() {
        this.listen(null);
    }
}

