/*
 * Decompiled with CFR 0.152.
 */
package org.eroq.router;

import java.net.URLConnection;
import java.util.List;
import org.eroq.http.HttpContext;
import org.eroq.router.App;
import org.eroq.router.RouteParams;

public class AppHttpContext
extends HttpContext
implements Cloneable {
    public AppHttpContext(HttpContext ctx, App app) {
        super(ctx);
        this.setAttribute("app", app);
        this.setResponseHeader("Content-Type", "text/html; charset=utf-8");
    }

    public AppHttpContext createTemporaryContext() {
        AppHttpContext temporaryContext = null;
        try {
            temporaryContext = (AppHttpContext)this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return temporaryContext;
    }

    public App getApp() {
        return (App)this.getAttribute("app");
    }

    public RouteParams getParams() {
        return (RouteParams)this.getAttribute("params");
    }

    private String guessContentTypeFromType(String type) {
        String guessedContentType = URLConnection.guessContentTypeFromName("x." + type);
        if (guessedContentType != null) {
            return guessedContentType;
        }
        return type;
    }

    public boolean is(String type) {
        String requestBodyContentType = this.getFirstValueForRequestHeader("Content-Type");
        if (requestBodyContentType == null) {
            return false;
        }
        String contentType = this.guessContentTypeFromType(type);
        return requestBodyContentType.equalsIgnoreCase(contentType);
    }

    public boolean accepts(String type) {
        List acceptedResponseTypes = this.getAllValuesForRequestHeader("Accept");
        if (acceptedResponseTypes == null) {
            return false;
        }
        String contentType = this.guessContentTypeFromType(type);
        for (String acceptedResponseType : acceptedResponseTypes) {
            if (!acceptedResponseType.toLowerCase().contains(contentType.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

