/*
 * Decompiled with CFR 0.152.
 */
package org.eroq.router;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eroq.http.HttpVerb;
import org.eroq.router.AppHttpContext;
import org.eroq.router.AppNextMiddlewareHandler;
import org.eroq.router.EndpointMiddleware;
import org.eroq.router.Middleware;
import org.eroq.router.ParamMiddleware;
import org.eroq.router.RouteMatch;
import org.eroq.router.RouteMatcher;
import org.eroq.router.RouteParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Router
implements Middleware {
    private static Logger logger = LoggerFactory.getLogger(Router.class);
    protected Properties properties;
    private List<Middleware> usedMiddleware = new ArrayList<Middleware>();
    private List<String> registeredParameters = new ArrayList<String>();
    private Map<String, List<ParamMiddleware>> registeredParametersMapping = new HashMap<String, List<ParamMiddleware>>();

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void run(AppHttpContext ctx, AppNextMiddlewareHandler next) {
        if (this.usedMiddleware.size() == 0) {
            next.handle();
            return;
        }
        this.runMiddleware(ctx, 0, next);
    }

    private void runMiddleware(AppHttpContext ctx, int middlewareIndex, AppNextMiddlewareHandler last) {
        if (middlewareIndex >= this.usedMiddleware.size()) {
            last.handle();
        }
        Middleware middleware = this.usedMiddleware.get(middlewareIndex);
        middleware.run(ctx, () -> this.runMiddleware(ctx, middlewareIndex + 1, last));
    }

    public void use(Middleware ... middlewares) {
        this.usedMiddleware.addAll(Arrays.asList(middlewares));
    }

    public Middleware router(String path, Middleware middleware) {
        RouteMatcher routeMatcher = RouteMatcher.Builder.createWithPath(path).end(false).build();
        logger.debug("ROUTER: {}", (Object)path);
        return (ctx, next) -> {
            RouteMatch routeMatch = routeMatcher.match(ctx.getPath());
            if (routeMatch != null) {
                String subPath;
                String subBaseUrl;
                logger.debug("Matched: ROUTER @ {} with params:", (Object)routeMatcher.getPathMatcher().getPattern());
                RouteParams routeParams = routeMatch.getParams();
                for (Object key : routeParams.keys()) {
                    logger.debug("\t{}: {}", key, routeParams.getAll(key));
                }
                AppHttpContext tmpCtx = ctx.createTemporaryContext();
                tmpCtx.setAttribute("params", routeParams);
                this.processParams(tmpCtx, routeMatch.getParams());
                String currentPath = (String)tmpCtx.getAttribute("path");
                String currentBaseUrl = (String)tmpCtx.getAttribute("baseUrl");
                if (currentBaseUrl == null) {
                    currentBaseUrl = "";
                }
                if ((subBaseUrl = currentBaseUrl + currentPath.substring(0, routeMatch.getMatcher().end())).endsWith("/")) {
                    subBaseUrl = subBaseUrl.substring(0, subBaseUrl.length() - 1);
                }
                if ((subPath = currentPath.substring(routeMatch.getMatcher().end())).length() == 0) {
                    subPath = "/";
                }
                tmpCtx.setAttribute("baseUrl", subBaseUrl);
                tmpCtx.setAttribute("path", subPath);
                tmpCtx.setAttribute("originalUrl", subBaseUrl + subPath);
                logger.debug("--> baseUrl={} path={} ", (Object)subBaseUrl, (Object)subPath);
                middleware.run(tmpCtx, next);
                logger.debug("<-- baseUrl={} path={} ", (Object)currentBaseUrl, (Object)currentPath);
            } else {
                next.handle();
            }
        };
    }

    public void route(String path, Middleware middleware) {
        this.use(this.router(path, middleware));
    }

    public Middleware endpoint(String method, String path, EndpointMiddleware middleware) {
        RouteMatcher routeMatcher = RouteMatcher.Builder.createWithPath(path).build();
        logger.debug("ENPOINT: {} @ {}", (Object)(method != null ? method : "ALL"), (Object)path);
        return (ctx, next) -> {
            RouteMatch routeMatch;
            if ((method == null || method.equalsIgnoreCase(ctx.getMethod())) && (routeMatch = routeMatcher.match(ctx.getPath())) != null) {
                logger.debug("Matched: {} @ {} with params:", (Object)(method != null ? method : "ALL"), (Object)routeMatcher.getPathMatcher().getPattern());
                RouteParams routeParams = routeMatch.getParams();
                for (Object key : routeParams.keys()) {
                    logger.debug("\t{}: {}", key, routeParams.getAll(key));
                }
                AppHttpContext tmpCtx = ctx.createTemporaryContext();
                tmpCtx.setAttribute("params", routeParams);
                this.processParams(tmpCtx, routeMatch.getParams());
                middleware.run(tmpCtx);
                return;
            }
            logger.trace("Did not match: {} @ {}", (Object)(method != null ? method : "ALL"), (Object)routeMatcher);
            next.handle();
        };
    }

    public void all(String path, EndpointMiddleware middleware) {
        this.use(this.endpoint(null, path, middleware));
    }

    public void get(String path, EndpointMiddleware middleware) {
        this.use(this.endpoint(HttpVerb.GET.value(), path, middleware));
    }

    public void post(String path, EndpointMiddleware middleware) {
        this.use(this.endpoint(HttpVerb.POST.value(), path, middleware));
    }

    public void put(String path, EndpointMiddleware middleware) {
        this.use(this.endpoint(HttpVerb.PUT.value(), path, middleware));
    }

    public void patch(String path, EndpointMiddleware middleware) {
        this.use(this.endpoint(HttpVerb.PATCH.value(), path, middleware));
    }

    public void delete(String path, EndpointMiddleware middleware) {
        this.use(this.endpoint(HttpVerb.DELETE.value(), path, middleware));
    }

    public void head(String path, EndpointMiddleware middleware) {
        this.use(this.endpoint(HttpVerb.HEAD.value(), path, middleware));
    }

    public void options(String path, EndpointMiddleware middleware) {
        this.use(this.endpoint(HttpVerb.OPTIONS.value(), path, middleware));
    }

    public void param(String parameter, ParamMiddleware paramMiddleware) {
        List<ParamMiddleware> registeredParamMiddlewares = this.registeredParametersMapping.get(parameter);
        if (registeredParamMiddlewares == null) {
            registeredParamMiddlewares = new ArrayList<ParamMiddleware>();
            this.registeredParametersMapping.put(parameter, registeredParamMiddlewares);
            this.registeredParameters.add(parameter);
            logger.debug("PARAM: {}", (Object)parameter);
        }
        registeredParamMiddlewares.add(paramMiddleware);
    }

    private void runParamMiddleware(AppHttpContext ctx, RouteParams params, Object paramId, int paramMiddlewareIndex) {
        List<ParamMiddleware> registeredParametersForName = this.registeredParametersMapping.get(paramId);
        if (paramMiddlewareIndex >= registeredParametersForName.size()) {
            return;
        }
        ParamMiddleware paramMiddleware = registeredParametersForName.get(paramMiddlewareIndex);
        paramMiddleware.run(ctx, () -> this.runParamMiddleware(ctx, params, paramId, paramMiddlewareIndex + 1), params.getLast(paramId));
    }

    private void processParams(AppHttpContext ctx, RouteParams params) {
        HashSet<Object> processedParametersMapping = (HashSet<Object>)ctx.getAttribute("_processedParametersMapping");
        if (processedParametersMapping == null) {
            processedParametersMapping = new HashSet<Object>();
            ctx.setAttribute("_processedParametersMapping", processedParametersMapping);
        }
        for (Object paramId : params.keys()) {
            if (processedParametersMapping.contains(paramId)) continue;
            processedParametersMapping.add(paramId);
            logger.debug("Processing param: {}", paramId);
            this.runParamMiddleware(ctx, params, paramId, 0);
        }
    }
}

