/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.kiwiproc.processor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ethelred.kiwiproc.processor.AssignmentConversion;
import org.ethelred.kiwiproc.processor.Conversion;
import org.ethelred.kiwiproc.processor.FromSqlArrayConversion;
import org.ethelred.kiwiproc.processor.InvalidConversion;
import org.ethelred.kiwiproc.processor.NullableSourceConversion;
import org.ethelred.kiwiproc.processor.StringFormatConversion;
import org.ethelred.kiwiproc.processor.ToSqlArrayConversion;
import org.ethelred.kiwiproc.processor.TypeMapping;
import org.ethelred.kiwiproc.processor.Util;
import org.ethelred.kiwiproc.processor.types.BasicType;
import org.ethelred.kiwiproc.processor.types.ContainerType;
import org.ethelred.kiwiproc.processor.types.KiwiType;
import org.ethelred.kiwiproc.processor.types.PrimitiveKiwiType;
import org.ethelred.kiwiproc.processor.types.SqlArrayType;
import org.jspecify.annotations.Nullable;

public class CoreTypes {
    public static final BasicType STRING_TYPE = new BasicType(String.class.getPackageName(), String.class.getSimpleName(), false);
    public static final Set<Class<?>> BASIC_TYPES = Set.of(String.class, BigInteger.class, BigDecimal.class, LocalDate.class, LocalTime.class, OffsetTime.class, LocalDateTime.class, OffsetDateTime.class);
    public static final Map<Class<?>, Class<?>> primitiveToBoxed = Map.ofEntries(Map.entry(Boolean.TYPE, Boolean.class), Map.entry(Byte.TYPE, Byte.class), Map.entry(Character.TYPE, Character.class), Map.entry(Short.TYPE, Short.class), Map.entry(Integer.TYPE, Integer.class), Map.entry(Long.TYPE, Long.class), Map.entry(Float.TYPE, Float.class), Map.entry(Double.TYPE, Double.class));
    public static final Map<String, String> primitiveToBoxedStrings = primitiveToBoxed.entrySet().stream().map(e -> Map.entry(((Class)e.getKey()).getSimpleName(), ((Class)e.getValue()).getSimpleName())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    private static final Map<Class<?>, Set<Class<?>>> assignableFrom = Map.of(Byte.TYPE, Set.of(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE), Character.TYPE, Set.of(Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE), Short.TYPE, Set.of(Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE), Integer.TYPE, Set.of(Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE), Long.TYPE, Set.of(Long.TYPE, Float.TYPE, Double.TYPE), Float.TYPE, Set.of(Float.TYPE, Double.TYPE));
    private static final Map<Class<?>, Set<Class<?>>> assignableTo = assignableFrom.entrySet().stream().flatMap(e -> ((Set)e.getValue()).stream().map(v -> new ClassEntry((Class<?>)v, (Class)e.getKey()))).collect(Collectors.groupingBy(ce -> ce.first, Collectors.mapping(ce -> ce.second, Collectors.toSet())));
    private final Conversion invalid = new InvalidConversion();
    Map<Class<?>, KiwiType> coreTypes = this.defineTypes();
    Map<TypeMapping, Conversion> simpleMappings = this.defineMappings();

    private static boolean isAssignable(Class<?> source, Class<?> target) {
        return assignableFrom.getOrDefault(source, Set.of()).contains(target);
    }

    private Map<TypeMapping, Conversion> defineMappings() {
        ArrayList<Map.Entry<TypeMapping, Conversion>> entries = new ArrayList<Map.Entry<TypeMapping, Conversion>>(200);
        this.addPrimitiveMappings(entries);
        this.addPrimitiveParseMappings(entries);
        this.addBigNumberMappings(entries);
        this.addDateTimeMappings(entries);
        return entries.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new));
    }

    private void addPrimitiveParseMappings(Collection<Map.Entry<TypeMapping, Conversion>> entries) {
        primitiveToBoxed.keySet().forEach(target -> {
            if (target.equals(Boolean.TYPE)) {
                return;
            }
            String warning = "possible NumberFormatException parsing String to %s".formatted(target.getName());
            Class<?> boxed = primitiveToBoxed.get(target);
            TypeMapping t = new TypeMapping(STRING_TYPE, this.coreTypes.get(target));
            StringFormatConversion c = new StringFormatConversion(warning, "$T.parse$L($N)", boxed, Util.capitalizeFirst(target.getSimpleName()));
            entries.add(Map.entry(t, c));
            t = new TypeMapping(STRING_TYPE, this.coreTypes.get(boxed));
            c = new StringFormatConversion(warning, "$T.valueOf($N)", boxed);
            entries.add(Map.entry(t, c));
        });
        TypeMapping t = new TypeMapping(STRING_TYPE, this.coreTypes.get(Boolean.TYPE));
        String format = "($1N.matches(\"\\d+\") && !\"0\".equals($1N)) || Boolean.parseBoolean($1N)\n";
        entries.add(Map.entry(t, new StringFormatConversion(null, format, new Object[0])));
    }

    private void addDateTimeMappings(Collection<Map.Entry<TypeMapping, Conversion>> entries) {
        String usesSystemDefaultZoneId = "uses system default ZoneId";
        List.of(LocalDate.class, LocalTime.class, OffsetTime.class, LocalDateTime.class, OffsetDateTime.class).forEach(dtClass -> {
            entries.add(this.mappingEntry(String.class, (Class<?>)dtClass, "possible DateTimeParseException parsing String to %s".formatted(dtClass.getSimpleName()), "$T.parse($N)", dtClass));
            entries.add(this.mappingEntry(Long.TYPE, (Class<?>)dtClass, usesSystemDefaultZoneId, "$1T.ofInstant($2T.ofEpochMilli($4N), $3T.systemDefault())", dtClass, Instant.class, ZoneId.class));
        });
        entries.add(this.mappingEntry(OffsetDateTime.class, Long.TYPE, null, "$N.toInstant().toEpochMilli()", new Object[0]));
        entries.add(this.mappingEntry(OffsetDateTime.class, LocalDateTime.class, null, "$N.toLocalDateTime()", new Object[0]));
        entries.add(this.mappingEntry(OffsetDateTime.class, OffsetTime.class, null, "$N.toOffsetTime()", new Object[0]));
        entries.add(this.mappingEntry(OffsetDateTime.class, LocalDate.class, null, "$N.toLocalDate()", new Object[0]));
        entries.add(this.mappingEntry(LocalDateTime.class, Long.TYPE, usesSystemDefaultZoneId, "$2N.atZone($1T.systemDefault()).toOffsetDateTime().toInstant().toEpochMilli()", ZoneId.class));
        entries.add(this.mappingEntry(LocalDateTime.class, LocalDate.class, null, "$N.toLocalDate()", new Object[0]));
        entries.add(this.mappingEntry(LocalDateTime.class, LocalTime.class, null, "$N.toLocalTime()", new Object[0]));
        entries.add(this.mappingEntry(LocalDate.class, Long.TYPE, usesSystemDefaultZoneId, "$2N.atStartOfDay().atZone($1T.systemDefault()).toOffsetDateTime().toInstant().toEpochMilli()", ZoneId.class));
        entries.add(this.mappingEntry(LocalDate.class, LocalDateTime.class, null, "$N.atStartOfDay()", new Object[0]));
        entries.add(this.mappingEntry(LocalDate.class, OffsetDateTime.class, null, "$2N.atStartOfDay().atZone($1T.systemDefault()).toOffsetDateTime()", ZoneId.class));
        entries.add(this.mappingEntry(OffsetTime.class, LocalTime.class, null, "$N.toLocalTime()", new Object[0]));
    }

    private void addBigNumberMappings(Collection<Map.Entry<TypeMapping, Conversion>> entries) {
        List.of(BigInteger.class, BigDecimal.class).forEach(big -> {
            Stream.of(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE).forEach(source -> entries.add(this.mappingEntry((Class<?>)source, (Class<?>)big, null, "$T.valueOf($N)", big)));
            String warning = "possible NumberFormatException parsing String to %s".formatted(big.getSimpleName());
            entries.add(this.mappingEntry(String.class, (Class<?>)big, warning, "new $T($N)", big));
            Stream.of(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE).forEach(target -> {
                String w = "possible lossy conversion from %s to %s".formatted(big.getName(), target.getName());
                entries.add(this.mappingEntry((Class<?>)big, (Class<?>)target, w, "$N.%sValue()".formatted(target.getName()), new Object[0]));
            });
        });
        entries.add(this.mappingEntry(BigInteger.class, Boolean.TYPE, null, "!$T.ZERO.equals($N)", BigInteger.class));
        entries.add(this.mappingEntry(Boolean.TYPE, BigInteger.class, null, "$2N ? $1T.ONE : $1T.ZERO", BigInteger.class));
        entries.add(this.mappingEntry(BigDecimal.class, BigInteger.class, "possible lossy conversion from BigDecimal to BigInteger", "$N.toBigInteger()", new Object[0]));
        entries.add(this.mappingEntry(BigInteger.class, BigDecimal.class, null, "new $T($N)", BigDecimal.class));
    }

    private void addPrimitiveMappings(Collection<Map.Entry<TypeMapping, Conversion>> entries) {
        assignableFrom.forEach((source, targets) -> targets.forEach(target -> entries.add(this.mappingEntry((Class<?>)source, (Class<?>)target, new AssignmentConversion()))));
        primitiveToBoxed.keySet().forEach(source -> primitiveToBoxed.keySet().forEach(target -> {
            if (!(source.equals(Boolean.TYPE) || target.equals(Boolean.TYPE) || source.equals(target) || CoreTypes.isAssignable(source, target))) {
                String warning = "possible lossy conversion from %s to %s".formatted(source.getName(), target.getName());
                entries.add(this.mappingEntry((Class<?>)source, (Class<?>)target, warning, "($T) $N", target));
            }
        }));
        Stream.of(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE).forEach(source -> {
            entries.add(this.mappingEntry((Class<?>)source, Boolean.TYPE, null, "$N != 0", new Object[0]));
            entries.add(this.mappingEntry(Boolean.TYPE, (Class<?>)source, null, "$2N ? 1 : 0", new Object[0]));
        });
        entries.add(this.mappingEntry(Character.TYPE, Boolean.TYPE, null, "Character.isDigit($1N) && $1N != '0'", new Object[0]));
        entries.add(this.mappingEntry(Boolean.TYPE, Character.TYPE, null, "$N ? '1' : '0'", new Object[0]));
    }

    private Map.Entry<TypeMapping, Conversion> mappingEntry(Class<?> source, Class<?> target, Conversion lookup) {
        KiwiType fromType = Objects.requireNonNull(this.coreTypes.get(source));
        KiwiType toType = Objects.requireNonNull(this.coreTypes.get(target));
        TypeMapping mapping = new TypeMapping(fromType, toType);
        return Map.entry(mapping, lookup);
    }

    private Map.Entry<TypeMapping, Conversion> mappingEntry(Class<?> source, Class<?> target, @Nullable String warning, String conversionFormat, Object ... defaultArgs) {
        return this.mappingEntry(source, target, new StringFormatConversion(warning, conversionFormat, defaultArgs));
    }

    private Map<Class<?>, KiwiType> defineTypes() {
        LinkedHashMap builder = new LinkedHashMap(32);
        primitiveToBoxed.forEach((key, value) -> {
            builder.put(key, new PrimitiveKiwiType(key.getSimpleName(), false));
            builder.put(value, new PrimitiveKiwiType(key.getSimpleName(), true));
        });
        BASIC_TYPES.forEach(c -> builder.put(c, new BasicType(c.getPackageName(), c.getSimpleName(), false)));
        return Map.copyOf(builder);
    }

    public KiwiType type(Class<?> aClass) {
        if (this.coreTypes.containsKey(aClass)) {
            return this.coreTypes.get(aClass);
        }
        return KiwiType.unsupported();
    }

    public Conversion lookup(TypeMapping mapper) {
        return this.lookup(mapper.source(), mapper.target());
    }

    public Conversion lookup(KiwiType source, KiwiType target) {
        Conversion result;
        if (source.equals(target) || source.withIsNullable(true).equals(target)) {
            return new AssignmentConversion();
        }
        if (source instanceof ContainerType) {
            ContainerType ct = (ContainerType)source;
            if (target instanceof SqlArrayType) {
                SqlArrayType sat = (SqlArrayType)target;
                return this.toSqlArray(ct, sat);
            }
        }
        if (source instanceof SqlArrayType) {
            SqlArrayType sat = (SqlArrayType)source;
            if (target instanceof ContainerType) {
                ContainerType ct = (ContainerType)target;
                return this.fromSqlArray(sat, ct);
            }
        }
        StringFormatConversion stringConversion = null;
        if (STRING_TYPE.equals(target) || STRING_TYPE.withIsNullable(true).equals(target)) {
            stringConversion = new StringFormatConversion(null, "String.valueOf($N)", new Object[0]);
        }
        if ((result = this.firstNonNull(stringConversion, this.simpleMappings.get(new TypeMapping(source, target)), this.simpleMappings.get(new TypeMapping(source, target.withIsNullable(false))), this.simpleMappings.get(new TypeMapping(source.withIsNullable(false), target.withIsNullable(false))), this.invalid)).isValid() && source.isNullable()) {
            result = new NullableSourceConversion(result);
        }
        return result;
    }

    private Conversion fromSqlArray(SqlArrayType sat, ContainerType ct) {
        Conversion elementConversion = this.lookup(sat.containedType(), ct.containedType());
        if (!elementConversion.isValid()) {
            return elementConversion;
        }
        return new FromSqlArrayConversion(sat, ct, elementConversion);
    }

    private Conversion toSqlArray(ContainerType ct, SqlArrayType sat) {
        Conversion elementConversion = this.lookup(ct.containedType().withIsNullable(false), sat.containedType());
        if (!elementConversion.isValid()) {
            return elementConversion;
        }
        return new ToSqlArrayConversion(ct, sat, elementConversion);
    }

    private Conversion firstNonNull(Conversion ... conversions) {
        for (Conversion c : conversions) {
            if (c == null) continue;
            return c;
        }
        throw new NullPointerException();
    }

    private record ClassEntry(Class<?> first, Class<?> second) {
    }
}

