/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.kiwiproc.processor;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.lang.model.element.TypeElement;
import org.ethelred.kiwiproc.processor.DAOClassInfo;
import org.ethelred.kiwiproc.processor.DAOMethodInfo;
import org.ethelred.kiwiproc.processor.DAOPrism;

public class DAOClassInfoBuilder {
    private final boolean[] _onceOnlyCheck = new boolean[5];
    private TypeElement element;
    private DAOPrism annotation;
    private String packageName;
    private String daoName;
    private List<DAOMethodInfo> methods;

    private DAOClassInfoBuilder() {
    }

    private DAOClassInfoBuilder(TypeElement element, DAOPrism annotation, String packageName, String daoName, List<DAOMethodInfo> methods) {
        this.element = element;
        this.annotation = annotation;
        this.packageName = packageName;
        this.daoName = daoName;
        this.methods = methods;
    }

    public static ElementStage builder() {
        DAOClassInfoBuilder r = new DAOClassInfoBuilder();
        return element -> {
            r.element(element);
            return annotation -> {
                r.annotation(annotation);
                return packageName -> {
                    r.packageName(packageName);
                    return daoName -> {
                        r.daoName(daoName);
                        return methods -> {
                            r.methods(methods);
                            return () -> r;
                        };
                    };
                };
            };
        };
    }

    public static DAOClassInfo DAOClassInfo(TypeElement element, DAOPrism annotation, String packageName, String daoName, List<DAOMethodInfo> methods) {
        methods = DAOClassInfoBuilder.__list(methods);
        return new DAOClassInfo(element, annotation, packageName, daoName, methods);
    }

    public static DAOClassInfoBuilder builder(DAOClassInfo from) {
        return new DAOClassInfoBuilder(from.element(), from.annotation(), from.packageName(), from.daoName(), from.methods());
    }

    public static With from(DAOClassInfo from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(DAOClassInfo record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, TypeElement>("element", record.element()), new AbstractMap.SimpleImmutableEntry<String, DAOPrism>("annotation", record.annotation()), new AbstractMap.SimpleImmutableEntry<String, String>("packageName", record.packageName()), new AbstractMap.SimpleImmutableEntry<String, String>("daoName", record.daoName()), new AbstractMap.SimpleImmutableEntry<String, List<DAOMethodInfo>>("methods", record.methods()));
    }

    public DAOClassInfo build() {
        this.methods = DAOClassInfoBuilder.__list(this.methods);
        return new DAOClassInfo(this.element, this.annotation, this.packageName, this.daoName, this.methods);
    }

    public String toString() {
        return "DAOClassInfoBuilder[element=" + this.element + ", annotation=" + this.annotation + ", packageName=" + this.packageName + ", daoName=" + this.daoName + ", methods=" + this.methods + "]";
    }

    public int hashCode() {
        return Objects.hash(this.element, this.annotation, this.packageName, this.daoName, this.methods);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DAOClassInfoBuilder)) return false;
        DAOClassInfoBuilder r = (DAOClassInfoBuilder)o;
        if (!Objects.equals(this.element, r.element)) return false;
        if (!Objects.equals(this.annotation, r.annotation)) return false;
        if (!Objects.equals(this.packageName, r.packageName)) return false;
        if (!Objects.equals(this.daoName, r.daoName)) return false;
        if (!Objects.equals(this.methods, r.methods)) return false;
        return true;
    }

    public DAOClassInfoBuilder element(TypeElement element) {
        if (this._onceOnlyCheck[0]) {
            throw new IllegalStateException("A value has already been set for: element");
        }
        this._onceOnlyCheck[0] = true;
        this.element = element;
        return this;
    }

    public TypeElement element() {
        return this.element;
    }

    public DAOClassInfoBuilder annotation(DAOPrism annotation) {
        if (this._onceOnlyCheck[1]) {
            throw new IllegalStateException("A value has already been set for: annotation");
        }
        this._onceOnlyCheck[1] = true;
        this.annotation = annotation;
        return this;
    }

    public DAOPrism annotation() {
        return this.annotation;
    }

    public DAOClassInfoBuilder packageName(String packageName) {
        if (this._onceOnlyCheck[2]) {
            throw new IllegalStateException("A value has already been set for: packageName");
        }
        this._onceOnlyCheck[2] = true;
        this.packageName = packageName;
        return this;
    }

    public String packageName() {
        return this.packageName;
    }

    public DAOClassInfoBuilder daoName(String daoName) {
        if (this._onceOnlyCheck[3]) {
            throw new IllegalStateException("A value has already been set for: daoName");
        }
        this._onceOnlyCheck[3] = true;
        this.daoName = daoName;
        return this;
    }

    public String daoName() {
        return this.daoName;
    }

    public DAOClassInfoBuilder methods(Collection<? extends DAOMethodInfo> methods) {
        if (this._onceOnlyCheck[4]) {
            throw new IllegalStateException("A value has already been set for: methods");
        }
        this._onceOnlyCheck[4] = true;
        this.methods = DAOClassInfoBuilder.__list(methods);
        return this;
    }

    public List<DAOMethodInfo> methods() {
        return DAOClassInfoBuilder.__list(this.methods);
    }

    public DAOClassInfoBuilder addMethods(DAOMethodInfo i) {
        this.methods = DAOClassInfoBuilder.__ensureListMutable(this.methods);
        this.methods.add(i);
        return this;
    }

    public DAOClassInfoBuilder addMethods(Stream<? extends DAOMethodInfo> i) {
        this.methods = DAOClassInfoBuilder.__ensureListMutable(this.methods);
        i.forEach(this.methods::add);
        return this;
    }

    public DAOClassInfoBuilder addMethods(Iterable<? extends DAOMethodInfo> i) {
        this.methods = DAOClassInfoBuilder.__ensureListMutable(this.methods);
        i.forEach(this.methods::add);
        return this;
    }

    private static <T> List<T> __list(Collection<? extends T> o) {
        return o != null ? List.copyOf(o) : List.of();
    }

    private static <T> List<T> __ensureListMutable(List<T> o) {
        if (o == null) {
            return new _MutableList();
        }
        if (o instanceof _MutableList) {
            return o;
        }
        return new _MutableList<T>(o);
    }

    public static interface ElementStage {
        public AnnotationStage element(TypeElement var1);
    }

    private static final class _FromWith
    implements With {
        private final DAOClassInfo from;

        private _FromWith(DAOClassInfo from) {
            this.from = from;
        }

        @Override
        public TypeElement element() {
            return this.from.element();
        }

        @Override
        public DAOPrism annotation() {
            return this.from.annotation();
        }

        @Override
        public String packageName() {
            return this.from.packageName();
        }

        @Override
        public String daoName() {
            return this.from.daoName();
        }

        @Override
        public List<DAOMethodInfo> methods() {
            return this.from.methods();
        }
    }

    private static class _MutableList<T>
    extends ArrayList<T> {
        public static final long serialVersionUID = 1L;

        _MutableList() {
        }

        _MutableList(List<T> o) {
            super(o);
        }
    }

    public static interface AnnotationStage {
        public PackageNameStage annotation(DAOPrism var1);
    }

    public static interface PackageNameStage {
        public DaoNameStage packageName(String var1);
    }

    public static interface DaoNameStage {
        public MethodsStage daoName(String var1);
    }

    public static interface MethodsStage {
        public DAOClassInfoBuilderStage methods(List<DAOMethodInfo> var1);
    }

    public static interface DAOClassInfoBuilderStage {
        default public DAOClassInfo build() {
            return this.builder().build();
        }

        public DAOClassInfoBuilder builder();
    }

    public static interface With {
        public TypeElement element();

        public DAOPrism annotation();

        public String packageName();

        public String daoName();

        public List<DAOMethodInfo> methods();

        default public DAOClassInfoBuilder with() {
            return new DAOClassInfoBuilder(this.element(), this.annotation(), this.packageName(), this.daoName(), this.methods());
        }

        default public DAOClassInfo with(java.util.function.Consumer<DAOClassInfoBuilder> consumer) {
            DAOClassInfoBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public DAOClassInfo withElement(TypeElement element) {
            return new DAOClassInfo(element, this.annotation(), this.packageName(), this.daoName(), this.methods());
        }

        default public DAOClassInfo withAnnotation(DAOPrism annotation) {
            return new DAOClassInfo(this.element(), annotation, this.packageName(), this.daoName(), this.methods());
        }

        default public DAOClassInfo withPackageName(String packageName) {
            return new DAOClassInfo(this.element(), this.annotation(), packageName, this.daoName(), this.methods());
        }

        default public DAOClassInfo withDaoName(String daoName) {
            return new DAOClassInfo(this.element(), this.annotation(), this.packageName(), daoName, this.methods());
        }

        default public DAOClassInfo withMethods(List<DAOMethodInfo> methods) {
            return new DAOClassInfo(this.element(), this.annotation(), this.packageName(), this.daoName(), DAOClassInfoBuilder.__list(methods));
        }

        default public <R> R map(Function<R> proc) {
            return proc.apply(this.element(), this.annotation(), this.packageName(), this.daoName(), this.methods());
        }

        default public void accept(Consumer proc) {
            proc.apply(this.element(), this.annotation(), this.packageName(), this.daoName(), this.methods());
        }

        @FunctionalInterface
        public static interface Function<R> {
            public R apply(TypeElement var1, DAOPrism var2, String var3, String var4, List<DAOMethodInfo> var5);
        }

        @FunctionalInterface
        public static interface Consumer {
            public void apply(TypeElement var1, DAOPrism var2, String var3, String var4, List<DAOMethodInfo> var5);
        }
    }
}

