/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.kiwiproc.processor;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.lang.model.element.ExecutableElement;
import org.ethelred.kiwiproc.meta.ParsedQuery;
import org.ethelred.kiwiproc.processor.DAOMethodInfo;
import org.ethelred.kiwiproc.processor.DAOParameterInfo;
import org.ethelred.kiwiproc.processor.DAOResultColumn;
import org.ethelred.kiwiproc.processor.QueryMethodKind;
import org.ethelred.kiwiproc.processor.Signature;

public class DAOMethodInfoBuilder {
    private final boolean[] _onceOnlyCheck = new boolean[7];
    private ExecutableElement methodElement;
    private Signature signature;
    private QueryMethodKind kind;
    private ParsedQuery parsedSql;
    private List<DAOParameterInfo> parameterMapping;
    private List<DAOResultColumn> multipleColumns;
    private DAOResultColumn singleColumn;

    private DAOMethodInfoBuilder() {
    }

    private DAOMethodInfoBuilder(ExecutableElement methodElement, Signature signature, QueryMethodKind kind, ParsedQuery parsedSql, List<DAOParameterInfo> parameterMapping, List<DAOResultColumn> multipleColumns, DAOResultColumn singleColumn) {
        this.methodElement = methodElement;
        this.signature = signature;
        this.kind = kind;
        this.parsedSql = parsedSql;
        this.parameterMapping = parameterMapping;
        this.multipleColumns = multipleColumns;
        this.singleColumn = singleColumn;
    }

    public static MethodElementStage builder() {
        DAOMethodInfoBuilder r = new DAOMethodInfoBuilder();
        return methodElement -> {
            r.methodElement(methodElement);
            return signature -> {
                r.signature(signature);
                return kind -> {
                    r.kind(kind);
                    return parsedSql -> {
                        r.parsedSql(parsedSql);
                        return parameterMapping -> {
                            r.parameterMapping(parameterMapping);
                            return multipleColumns -> {
                                r.multipleColumns(multipleColumns);
                                return singleColumn -> {
                                    r.singleColumn(singleColumn);
                                    return () -> r;
                                };
                            };
                        };
                    };
                };
            };
        };
    }

    public static DAOMethodInfo DAOMethodInfo(ExecutableElement methodElement, Signature signature, QueryMethodKind kind, ParsedQuery parsedSql, List<DAOParameterInfo> parameterMapping, List<DAOResultColumn> multipleColumns, DAOResultColumn singleColumn) {
        parameterMapping = DAOMethodInfoBuilder.__list(parameterMapping);
        multipleColumns = DAOMethodInfoBuilder.__list(multipleColumns);
        return new DAOMethodInfo(methodElement, signature, kind, parsedSql, parameterMapping, multipleColumns, singleColumn);
    }

    public static DAOMethodInfoBuilder builder(DAOMethodInfo from) {
        return new DAOMethodInfoBuilder(from.methodElement(), from.signature(), from.kind(), from.parsedSql(), from.parameterMapping(), from.multipleColumns(), from.singleColumn());
    }

    public static With from(DAOMethodInfo from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(DAOMethodInfo record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, ExecutableElement>("methodElement", record.methodElement()), new AbstractMap.SimpleImmutableEntry<String, Signature>("signature", record.signature()), new AbstractMap.SimpleImmutableEntry<String, QueryMethodKind>("kind", record.kind()), new AbstractMap.SimpleImmutableEntry<String, ParsedQuery>("parsedSql", record.parsedSql()), new AbstractMap.SimpleImmutableEntry<String, List<DAOParameterInfo>>("parameterMapping", record.parameterMapping()), new AbstractMap.SimpleImmutableEntry<String, List<DAOResultColumn>>("multipleColumns", record.multipleColumns()), new AbstractMap.SimpleImmutableEntry<String, DAOResultColumn>("singleColumn", record.singleColumn()));
    }

    public DAOMethodInfo build() {
        this.parameterMapping = DAOMethodInfoBuilder.__list(this.parameterMapping);
        this.multipleColumns = DAOMethodInfoBuilder.__list(this.multipleColumns);
        return new DAOMethodInfo(this.methodElement, this.signature, this.kind, this.parsedSql, this.parameterMapping, this.multipleColumns, this.singleColumn);
    }

    public String toString() {
        return "DAOMethodInfoBuilder[methodElement=" + this.methodElement + ", signature=" + this.signature + ", kind=" + this.kind + ", parsedSql=" + this.parsedSql + ", parameterMapping=" + this.parameterMapping + ", multipleColumns=" + this.multipleColumns + ", singleColumn=" + this.singleColumn + "]";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.methodElement, this.signature, this.kind, this.parsedSql, this.parameterMapping, this.multipleColumns, this.singleColumn});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DAOMethodInfoBuilder)) return false;
        DAOMethodInfoBuilder r = (DAOMethodInfoBuilder)o;
        if (!Objects.equals(this.methodElement, r.methodElement)) return false;
        if (!Objects.equals(this.signature, r.signature)) return false;
        if (!Objects.equals((Object)this.kind, (Object)r.kind)) return false;
        if (!Objects.equals(this.parsedSql, r.parsedSql)) return false;
        if (!Objects.equals(this.parameterMapping, r.parameterMapping)) return false;
        if (!Objects.equals(this.multipleColumns, r.multipleColumns)) return false;
        if (!Objects.equals(this.singleColumn, r.singleColumn)) return false;
        return true;
    }

    public DAOMethodInfoBuilder methodElement(ExecutableElement methodElement) {
        if (this._onceOnlyCheck[0]) {
            throw new IllegalStateException("A value has already been set for: methodElement");
        }
        this._onceOnlyCheck[0] = true;
        this.methodElement = methodElement;
        return this;
    }

    public ExecutableElement methodElement() {
        return this.methodElement;
    }

    public DAOMethodInfoBuilder signature(Signature signature) {
        if (this._onceOnlyCheck[1]) {
            throw new IllegalStateException("A value has already been set for: signature");
        }
        this._onceOnlyCheck[1] = true;
        this.signature = signature;
        return this;
    }

    public Signature signature() {
        return this.signature;
    }

    public DAOMethodInfoBuilder kind(QueryMethodKind kind) {
        if (this._onceOnlyCheck[2]) {
            throw new IllegalStateException("A value has already been set for: kind");
        }
        this._onceOnlyCheck[2] = true;
        this.kind = kind;
        return this;
    }

    public QueryMethodKind kind() {
        return this.kind;
    }

    public DAOMethodInfoBuilder parsedSql(ParsedQuery parsedSql) {
        if (this._onceOnlyCheck[3]) {
            throw new IllegalStateException("A value has already been set for: parsedSql");
        }
        this._onceOnlyCheck[3] = true;
        this.parsedSql = parsedSql;
        return this;
    }

    public ParsedQuery parsedSql() {
        return this.parsedSql;
    }

    public DAOMethodInfoBuilder parameterMapping(Collection<? extends DAOParameterInfo> parameterMapping) {
        if (this._onceOnlyCheck[4]) {
            throw new IllegalStateException("A value has already been set for: parameterMapping");
        }
        this._onceOnlyCheck[4] = true;
        this.parameterMapping = DAOMethodInfoBuilder.__list(parameterMapping);
        return this;
    }

    public List<DAOParameterInfo> parameterMapping() {
        return DAOMethodInfoBuilder.__list(this.parameterMapping);
    }

    public DAOMethodInfoBuilder addParameterMapping(DAOParameterInfo i) {
        this.parameterMapping = DAOMethodInfoBuilder.__ensureListMutable(this.parameterMapping);
        this.parameterMapping.add(i);
        return this;
    }

    public DAOMethodInfoBuilder addParameterMapping(Stream<? extends DAOParameterInfo> i) {
        this.parameterMapping = DAOMethodInfoBuilder.__ensureListMutable(this.parameterMapping);
        i.forEach(this.parameterMapping::add);
        return this;
    }

    public DAOMethodInfoBuilder addParameterMapping(Iterable<? extends DAOParameterInfo> i) {
        this.parameterMapping = DAOMethodInfoBuilder.__ensureListMutable(this.parameterMapping);
        i.forEach(this.parameterMapping::add);
        return this;
    }

    public DAOMethodInfoBuilder multipleColumns(Collection<? extends DAOResultColumn> multipleColumns) {
        if (this._onceOnlyCheck[5]) {
            throw new IllegalStateException("A value has already been set for: multipleColumns");
        }
        this._onceOnlyCheck[5] = true;
        this.multipleColumns = DAOMethodInfoBuilder.__list(multipleColumns);
        return this;
    }

    public List<DAOResultColumn> multipleColumns() {
        return DAOMethodInfoBuilder.__list(this.multipleColumns);
    }

    public DAOMethodInfoBuilder addMultipleColumns(DAOResultColumn i) {
        this.multipleColumns = DAOMethodInfoBuilder.__ensureListMutable(this.multipleColumns);
        this.multipleColumns.add(i);
        return this;
    }

    public DAOMethodInfoBuilder addMultipleColumns(Stream<? extends DAOResultColumn> i) {
        this.multipleColumns = DAOMethodInfoBuilder.__ensureListMutable(this.multipleColumns);
        i.forEach(this.multipleColumns::add);
        return this;
    }

    public DAOMethodInfoBuilder addMultipleColumns(Iterable<? extends DAOResultColumn> i) {
        this.multipleColumns = DAOMethodInfoBuilder.__ensureListMutable(this.multipleColumns);
        i.forEach(this.multipleColumns::add);
        return this;
    }

    public DAOMethodInfoBuilder singleColumn(DAOResultColumn singleColumn) {
        if (this._onceOnlyCheck[6]) {
            throw new IllegalStateException("A value has already been set for: singleColumn");
        }
        this._onceOnlyCheck[6] = true;
        this.singleColumn = singleColumn;
        return this;
    }

    public DAOResultColumn singleColumn() {
        return this.singleColumn;
    }

    private static <T> List<T> __list(Collection<? extends T> o) {
        return o != null ? List.copyOf(o) : List.of();
    }

    private static <T> List<T> __ensureListMutable(List<T> o) {
        if (o == null) {
            return new _MutableList();
        }
        if (o instanceof _MutableList) {
            return o;
        }
        return new _MutableList<T>(o);
    }

    public static interface MethodElementStage {
        public SignatureStage methodElement(ExecutableElement var1);
    }

    private static final class _FromWith
    implements With {
        private final DAOMethodInfo from;

        private _FromWith(DAOMethodInfo from) {
            this.from = from;
        }

        @Override
        public ExecutableElement methodElement() {
            return this.from.methodElement();
        }

        @Override
        public Signature signature() {
            return this.from.signature();
        }

        @Override
        public QueryMethodKind kind() {
            return this.from.kind();
        }

        @Override
        public ParsedQuery parsedSql() {
            return this.from.parsedSql();
        }

        @Override
        public List<DAOParameterInfo> parameterMapping() {
            return this.from.parameterMapping();
        }

        @Override
        public List<DAOResultColumn> multipleColumns() {
            return this.from.multipleColumns();
        }

        @Override
        public DAOResultColumn singleColumn() {
            return this.from.singleColumn();
        }
    }

    private static class _MutableList<T>
    extends ArrayList<T> {
        public static final long serialVersionUID = 1L;

        _MutableList() {
        }

        _MutableList(List<T> o) {
            super(o);
        }
    }

    public static interface SignatureStage {
        public KindStage signature(Signature var1);
    }

    public static interface KindStage {
        public ParsedSqlStage kind(QueryMethodKind var1);
    }

    public static interface ParsedSqlStage {
        public ParameterMappingStage parsedSql(ParsedQuery var1);
    }

    public static interface ParameterMappingStage {
        public MultipleColumnsStage parameterMapping(List<DAOParameterInfo> var1);
    }

    public static interface MultipleColumnsStage {
        public SingleColumnStage multipleColumns(List<DAOResultColumn> var1);
    }

    public static interface SingleColumnStage {
        public DAOMethodInfoBuilderStage singleColumn(DAOResultColumn var1);
    }

    public static interface DAOMethodInfoBuilderStage {
        default public DAOMethodInfo build() {
            return this.builder().build();
        }

        public DAOMethodInfoBuilder builder();
    }

    public static interface With {
        public ExecutableElement methodElement();

        public Signature signature();

        public QueryMethodKind kind();

        public ParsedQuery parsedSql();

        public List<DAOParameterInfo> parameterMapping();

        public List<DAOResultColumn> multipleColumns();

        public DAOResultColumn singleColumn();

        default public DAOMethodInfoBuilder with() {
            return new DAOMethodInfoBuilder(this.methodElement(), this.signature(), this.kind(), this.parsedSql(), this.parameterMapping(), this.multipleColumns(), this.singleColumn());
        }

        default public DAOMethodInfo with(java.util.function.Consumer<DAOMethodInfoBuilder> consumer) {
            DAOMethodInfoBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public DAOMethodInfo withMethodElement(ExecutableElement methodElement) {
            return new DAOMethodInfo(methodElement, this.signature(), this.kind(), this.parsedSql(), this.parameterMapping(), this.multipleColumns(), this.singleColumn());
        }

        default public DAOMethodInfo withSignature(Signature signature) {
            return new DAOMethodInfo(this.methodElement(), signature, this.kind(), this.parsedSql(), this.parameterMapping(), this.multipleColumns(), this.singleColumn());
        }

        default public DAOMethodInfo withKind(QueryMethodKind kind) {
            return new DAOMethodInfo(this.methodElement(), this.signature(), kind, this.parsedSql(), this.parameterMapping(), this.multipleColumns(), this.singleColumn());
        }

        default public DAOMethodInfo withParsedSql(ParsedQuery parsedSql) {
            return new DAOMethodInfo(this.methodElement(), this.signature(), this.kind(), parsedSql, this.parameterMapping(), this.multipleColumns(), this.singleColumn());
        }

        default public DAOMethodInfo withParameterMapping(List<DAOParameterInfo> parameterMapping) {
            return new DAOMethodInfo(this.methodElement(), this.signature(), this.kind(), this.parsedSql(), DAOMethodInfoBuilder.__list(parameterMapping), this.multipleColumns(), this.singleColumn());
        }

        default public DAOMethodInfo withMultipleColumns(List<DAOResultColumn> multipleColumns) {
            return new DAOMethodInfo(this.methodElement(), this.signature(), this.kind(), this.parsedSql(), this.parameterMapping(), DAOMethodInfoBuilder.__list(multipleColumns), this.singleColumn());
        }

        default public DAOMethodInfo withSingleColumn(DAOResultColumn singleColumn) {
            return new DAOMethodInfo(this.methodElement(), this.signature(), this.kind(), this.parsedSql(), this.parameterMapping(), this.multipleColumns(), singleColumn);
        }

        default public <R> R map(Function<R> proc) {
            return proc.apply(this.methodElement(), this.signature(), this.kind(), this.parsedSql(), this.parameterMapping(), this.multipleColumns(), this.singleColumn());
        }

        default public void accept(Consumer proc) {
            proc.apply(this.methodElement(), this.signature(), this.kind(), this.parsedSql(), this.parameterMapping(), this.multipleColumns(), this.singleColumn());
        }

        @FunctionalInterface
        public static interface Function<R> {
            public R apply(ExecutableElement var1, Signature var2, QueryMethodKind var3, ParsedQuery var4, List<DAOParameterInfo> var5, List<DAOResultColumn> var6, DAOResultColumn var7);
        }

        @FunctionalInterface
        public static interface Consumer {
            public void apply(ExecutableElement var1, Signature var2, QueryMethodKind var3, ParsedQuery var4, List<DAOParameterInfo> var5, List<DAOResultColumn> var6, DAOResultColumn var7);
        }
    }
}

