/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.kiwiproc.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.VariableElement;
import org.ethelred.kiwiproc.meta.ColumnMetaData;
import org.ethelred.kiwiproc.processor.MethodParameterInfo;
import org.ethelred.kiwiproc.processor.SqlTypeMapping;
import org.ethelred.kiwiproc.processor.TypeMapping;
import org.ethelred.kiwiproc.processor.TypeUtils;
import org.jspecify.annotations.Nullable;

public record DAOParameterInfo(int index, String javaAccessor, String setter, int sqlType, TypeMapping mapper, VariableElement element, @Nullable String arrayComponent) {
    public static List<DAOParameterInfo> from(TypeUtils typeUtils, Map<ColumnMetaData, MethodParameterInfo> parameterMapping) {
        ArrayList<DAOParameterInfo> result = new ArrayList<DAOParameterInfo>(parameterMapping.size());
        parameterMapping.forEach((columnMetaData, methodParameterInfo) -> {
            SqlTypeMapping sqlTypeMapping;
            String accessor = methodParameterInfo.name().name();
            if (methodParameterInfo.isRecordComponent()) {
                accessor = "%s.%s()".formatted(methodParameterInfo.recordParameterName(), methodParameterInfo.name());
            }
            if ((sqlTypeMapping = SqlTypeMapping.get(columnMetaData)).specialCase()) {
                // empty if block
            }
            String setter = "set" + sqlTypeMapping.accessorSuffix();
            TypeMapping mapper = new TypeMapping(methodParameterInfo.type(), sqlTypeMapping.kiwiType());
            result.add(new DAOParameterInfo(columnMetaData.index(), accessor, setter, columnMetaData.sqlType().getVendorTypeNumber(), mapper, methodParameterInfo.variableElement(), null));
        });
        return result;
    }
}

