/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.kiwiproc.processor;

import com.karuslabs.utilitary.AnnotationProcessor;
import io.avaje.jsonb.JsonType;
import io.avaje.jsonb.Jsonb;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.ethelred.kiwiproc.annotation.DAO;
import org.ethelred.kiwiproc.meta.ColumnMetaData;
import org.ethelred.kiwiproc.meta.DatabaseWrapper;
import org.ethelred.kiwiproc.meta.ParsedQuery;
import org.ethelred.kiwiproc.meta.QueryMetaData;
import org.ethelred.kiwiproc.meta.SqlName;
import org.ethelred.kiwiproc.processor.DAOClassInfo;
import org.ethelred.kiwiproc.processor.DAOClassInfoBuilder;
import org.ethelred.kiwiproc.processor.DAOMethodInfo;
import org.ethelred.kiwiproc.processor.DAOParameterInfo;
import org.ethelred.kiwiproc.processor.DAOPrism;
import org.ethelred.kiwiproc.processor.DAOResultColumn;
import org.ethelred.kiwiproc.processor.MethodParameterInfo;
import org.ethelred.kiwiproc.processor.QueryMethodKind;
import org.ethelred.kiwiproc.processor.Signature;
import org.ethelred.kiwiproc.processor.SqlTypeMapping;
import org.ethelred.kiwiproc.processor.TypeUtils;
import org.ethelred.kiwiproc.processor.TypeValidator;
import org.ethelred.kiwiproc.processor.generator.PoetDAOGenerator;
import org.ethelred.kiwiproc.processor.types.ContainerType;
import org.ethelred.kiwiproc.processor.types.KiwiType;
import org.ethelred.kiwiproc.processor.types.RecordType;
import org.ethelred.kiwiproc.processorconfig.DataSourceConfig;
import org.ethelred.kiwiproc.processorconfig.DataSourceConfigJsonAdapter;
import org.ethelred.kiwiproc.processorconfig.ProcessorConfig;
import org.ethelred.kiwiproc.processorconfig.ProcessorConfigJsonAdapter;
import org.jspecify.annotations.Nullable;

@SupportedAnnotationTypes(value={"org.ethelred.kiwiproc.annotation.DAO", "org.ethelred.kiwiproc.annotation.ResultQuery", "org.ethelred.kiwiproc.annotation.UpdateQuery"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@SupportedOptions(value={"org.ethelred.kiwiproc.configuration"})
public class KiwiProcessor
extends AnnotationProcessor {
    public static final String CONFIGURATION_OPTION = "org.ethelred.kiwiproc.configuration";
    private ProcessorConfig config = ProcessorConfig.EMPTY;
    private @Nullable TypeUtils typeUtils;
    private final Map<String, DatabaseWrapper> databases = new HashMap<String, DatabaseWrapper>();
    private @Nullable PoetDAOGenerator poet;
    private final Set<String> generatedTransactionManagers = new HashSet<String>();
    Jsonb jsonb = Jsonb.builder().add(ProcessorConfig.class, ProcessorConfigJsonAdapter::new).add(DataSourceConfig.class, DataSourceConfigJsonAdapter::new).build();
    JsonType<ProcessorConfig> configType = this.jsonb.type(ProcessorConfig.class);

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        String configPath = processingEnv.getOptions().get(CONFIGURATION_OPTION);
        this.config = this.loadConfig(configPath);
        this.typeUtils = new TypeUtils(this.elements, (Types)this.types, this.logger);
        this.poet = new PoetDAOGenerator(this.logger, processingEnv.getFiler(), this.config.dependencyInjectionStyle());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ProcessorConfig loadConfig(@Nullable String configPath) {
        if (configPath == null || configPath.isBlank()) {
            this.logger.error(null, (Object)"No config file specified.");
            return ProcessorConfig.EMPTY;
        }
        Path path = Path.of(configPath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            this.logger.error(null, (Object)"Config file '%s' not found.".formatted(path));
            return ProcessorConfig.EMPTY;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            ProcessorConfig config = (ProcessorConfig)this.configType.fromJson((Reader)reader);
            if (config.dataSources().isEmpty()) {
                this.logger.error(null, (Object)"No datasources in config file '%s'.".formatted(path));
                return ProcessorConfig.EMPTY;
            }
            ProcessorConfig processorConfig = config;
            return processorConfig;
        }
        catch (Exception e) {
            this.logger.error(null, (Object)"Exception reading config file '%s'. %s%n%s".formatted(path, e.getMessage(), this.stackTrace(e)));
        }
        return ProcessorConfig.EMPTY;
    }

    private String stackTrace(Exception e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private DatabaseWrapper getDatabase(String name) {
        return this.databases.computeIfAbsent(name, n -> new DatabaseWrapper(n, (DataSourceConfig)this.config.dataSources().getOrDefault(n, null)));
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            for (Element element : roundEnv.getElementsAnnotatedWith(DAO.class)) {
                if (element.getKind() == ElementKind.INTERFACE) {
                    this.processInterface((TypeElement)element);
                    continue;
                }
                this.logger.error(element, (Object)"@DAO is only permitted on interfaces");
            }
        }
        catch (SQLException e) {
            this.logger.error(null, (Object)("Exception while processing. " + e));
        }
        return true;
    }

    private @Nullable DAOMethodInfo processMethod(String daoName, QueryMethodKind kind, DatabaseWrapper databaseWrapper, ExecutableElement methodElement) throws SQLException {
        KiwiType returnComponentType;
        QueryMetaData queryMetaData;
        ParsedQuery parsedSql = ParsedQuery.parse((String)kind.getSql(methodElement));
        try {
            queryMetaData = databaseWrapper.getQueryMetaData(parsedSql.parsedSql());
        }
        catch (SQLException e) {
            this.logger.error((Element)methodElement, (Object)("\n" + e.getMessage()));
            return null;
        }
        Set<MethodParameterInfo> parameterInfo = MethodParameterInfo.fromElements(Objects.requireNonNull(this.typeUtils), methodElement.getParameters());
        Map<ColumnMetaData, MethodParameterInfo> parameterMapping = this.mapParameters(methodElement, parsedSql.parameterNames(), queryMetaData.parameters(), parameterInfo);
        TypeValidator typeValidator = new TypeValidator(this.logger, methodElement, this.config.debug());
        if (!typeValidator.validateParameters(parameterMapping, kind)) {
            return null;
        }
        List<DAOParameterInfo> templateParameterMapping = DAOParameterInfo.from(this.typeUtils, parameterMapping);
        KiwiType returnType = this.typeUtils.kiwiType(methodElement.getReturnType());
        if (!typeValidator.validateReturn(queryMetaData.resultColumns(), returnType, kind)) {
            this.logger.error((Element)methodElement, (Object)"Invalid return type");
            return null;
        }
        ArrayList<DAOResultColumn> multipleColumnResults = new ArrayList<DAOResultColumn>();
        DAOResultColumn singleColumnResult = null;
        if (returnType instanceof ContainerType) {
            ContainerType containerType = (ContainerType)returnType;
            v0 = containerType.containedType();
        } else {
            v0 = returnComponentType = returnType;
        }
        if (kind == QueryMethodKind.QUERY && queryMetaData.resultColumns().size() > 1) {
            if (returnComponentType instanceof RecordType) {
                RecordType recordType = (RecordType)returnComponentType;
                recordType.components().forEach(component -> {
                    Optional<ColumnMetaData> colOpt = queryMetaData.resultColumns().stream().filter(c -> component.name().equivalent(c.name())).findFirst();
                    colOpt.ifPresentOrElse(col -> multipleColumnResults.add(new DAOResultColumn(col.name(), SqlTypeMapping.get(col), component.type())), () -> this.logger.error((Element)methodElement, (Object)"No matching column found for record '%s' component '%s'".formatted(recordType.className(), component.name())));
                });
            } else {
                this.logger.error((Element)methodElement, (Object)"A query with multiple columns must be mapped to a Record type");
            }
        } else if (queryMetaData.resultColumns().size() == 1) {
            ColumnMetaData col = (ColumnMetaData)queryMetaData.resultColumns().get(0);
            singleColumnResult = new DAOResultColumn(col.name(), SqlTypeMapping.get(col), returnComponentType);
        }
        return new DAOMethodInfo(methodElement, Signature.fromMethod(this.typeUtils, methodElement), kind, parsedSql, templateParameterMapping, multipleColumnResults, singleColumnResult);
    }

    private Map<ColumnMetaData, MethodParameterInfo> mapParameters(ExecutableElement methodElement, List<String> parameterNames, List<ColumnMetaData> queryParameters, Set<MethodParameterInfo> methodParameters) {
        HashMap<ColumnMetaData, MethodParameterInfo> r = new HashMap<ColumnMetaData, MethodParameterInfo>();
        for (ColumnMetaData queryParameter : queryParameters) {
            String name = parameterNames.get(queryParameter.index() - 1);
            MethodParameterInfo methodParameter = methodParameters.stream().filter(mp -> mp.name().equivalent(new SqlName(name))).findFirst().orElse(null);
            if (methodParameter == null) {
                this.logger.error((Element)methodElement, (Object)"No method parameter found for query parameter '%s'".formatted(name));
                continue;
            }
            r.put(queryParameter, methodParameter);
        }
        return r;
    }

    private void processInterface(TypeElement interfaceElement) throws SQLException {
        Objects.requireNonNull(this.typeUtils, "processInterface called before init?");
        Objects.requireNonNull(this.poet, "processInterface called before init?");
        DAOPrism daoAnn = DAOPrism.getInstanceOn(interfaceElement);
        String dataSourceName = daoAnn.dataSourceName();
        DatabaseWrapper databaseWrapper = this.getDatabase(dataSourceName);
        if (!databaseWrapper.isValid()) {
            this.logger.error((Element)interfaceElement, (Object)"Could not get valid datasource for methodName '%s'. %s".formatted(dataSourceName, databaseWrapper.getError().getMessage()));
            return;
        }
        DAOClassInfoBuilder.ElementStage elementStage = DAOClassInfoBuilder.builder();
        String daoName = interfaceElement.getSimpleName().toString();
        String packageName = this.typeUtils.packageName(interfaceElement);
        DAOClassInfoBuilder builderStage = elementStage.element(interfaceElement).annotation(daoAnn).packageName(packageName).daoName(daoName).methods(new ArrayList<DAOMethodInfo>()).builder();
        for (ExecutableElement methodElement : ElementFilter.methodsIn(Set.copyOf(interfaceElement.getEnclosedElements()))) {
            DAOMethodInfo methodInfo;
            QueryMethodKind kind;
            Set<QueryMethodKind> kinds = QueryMethodKind.forMethod(methodElement);
            if (kinds.isEmpty()) {
                this.logger.error((Element)methodElement, (Object)"Must have a '@SqlQuery', '@SqlUpdate' or '@SqlBatch' annotation or a 'default' implementation.");
            } else if (kinds.size() > 1) {
                this.logger.error((Element)methodElement, (Object)"May only have one Sql annotation, or be default.");
            }
            if ((kind = kinds.iterator().next()) == QueryMethodKind.DEFAULT) continue;
            if (kind == QueryMethodKind.BATCH) {
                this.logger.error((Element)methodElement, (Object)"@SqlBatch is not supported yet. It is planned for Milestone 2.");
            }
            if ((methodInfo = this.processMethod(daoName, kinds.iterator().next(), databaseWrapper, methodElement)) == null) continue;
            builderStage.addMethods(methodInfo);
        }
        if (builderStage.methods().isEmpty()) {
            this.logger.error((Element)interfaceElement, (Object)"No valid Sql or default methods found.");
            return;
        }
        DAOClassInfo classInfo = builderStage.build();
        this.poet.generateImpl(classInfo);
        this.poet.generateProvider(classInfo);
    }
}

