/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.kiwiproc.processor;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor14;
import org.ethelred.kiwiproc.meta.JavaName;
import org.ethelred.kiwiproc.processor.CoreTypes;
import org.ethelred.kiwiproc.processor.TypeUtils;
import org.ethelred.kiwiproc.processor.types.BasicType;
import org.ethelred.kiwiproc.processor.types.ContainerType;
import org.ethelred.kiwiproc.processor.types.KiwiType;
import org.ethelred.kiwiproc.processor.types.PrimitiveKiwiType;
import org.ethelred.kiwiproc.processor.types.RecordType;
import org.ethelred.kiwiproc.processor.types.RecordTypeComponent;
import org.ethelred.kiwiproc.processor.types.ValidContainerType;
import org.ethelred.kiwiproc.processor.types.VoidType;

public class KiwiTypeVisitor
extends SimpleTypeVisitor14<KiwiType, Void> {
    private final TypeUtils utils;

    public KiwiTypeVisitor(TypeUtils utils) {
        this.utils = utils;
    }

    @Override
    public KiwiType visitPrimitive(PrimitiveType t, Void ignore) {
        return new PrimitiveKiwiType(t.toString(), false);
    }

    @Override
    public KiwiType visitArray(ArrayType t, Void ignore) {
        return new ContainerType(ValidContainerType.ARRAY, (KiwiType)this.visit(t.getComponentType()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public KiwiType visitDeclared(DeclaredType t, Void ignore) {
        try {
            PrimitiveType primitiveType2 = this.utils.unboxedType(t);
            return new PrimitiveKiwiType(primitiveType2.toString(), true);
        }
        catch (IllegalArgumentException primitiveType2) {
            void var5_9;
            if (CoreTypes.BASIC_TYPES.stream().anyMatch(bt -> this.utils.isSameType(t, this.utils.type((Class)bt)))) {
                return new BasicType(this.utils.packageName(t), this.utils.className(t), this.utils.isNullable(t));
            }
            ValidContainerType[] primitiveType2 = ValidContainerType.values();
            int n = primitiveType2.length;
            boolean bl = false;
            while (var5_9 < n) {
                ValidContainerType vct = primitiveType2[var5_9];
                if (this.utils.isSameType(this.utils.erasure(t), this.utils.erasure(vct.javaType()))) {
                    List<? extends TypeMirror> typeArguments = t.getTypeArguments();
                    return new ContainerType(vct, (KiwiType)this.visit(typeArguments.get(0)));
                }
                ++var5_9;
            }
            if (this.utils.isRecord(t)) {
                ArrayList<RecordTypeComponent> componentTypes = new ArrayList<RecordTypeComponent>();
                for (RecordComponentElement recordComponentElement : this.utils.recordComponents(t)) {
                    componentTypes.add(new RecordTypeComponent(new JavaName(recordComponentElement.getSimpleName().toString()), (KiwiType)this.visit(recordComponentElement.asType())));
                }
                return new RecordType(this.utils.packageName(t), this.utils.className(t), List.copyOf(componentTypes));
            }
            return KiwiType.unsupported();
        }
    }

    @Override
    public KiwiType visitNoType(NoType t, Void unused) {
        if (t.getKind().equals((Object)TypeKind.VOID)) {
            return new VoidType();
        }
        return KiwiType.unsupported();
    }
}

