/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.kiwiproc.processor;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.ethelred.kiwiproc.meta.JavaName;
import org.ethelred.kiwiproc.processor.MethodParameterInfoBuilder;
import org.ethelred.kiwiproc.processor.TypeUtils;
import org.ethelred.kiwiproc.processor.types.KiwiType;
import org.jspecify.annotations.Nullable;

public record MethodParameterInfo(VariableElement variableElement, JavaName name, KiwiType type, boolean isRecordComponent, @Nullable String recordParameterName) {
    static Set<MethodParameterInfo> fromElements(TypeUtils types, List<? extends VariableElement> variableElements) {
        return variableElements.stream().flatMap(variableElement -> MethodParameterInfo.fromElement(types, variableElement).stream()).collect(Collectors.toSet());
    }

    static Set<MethodParameterInfo> fromElement(TypeUtils types, VariableElement variableElement) {
        if (types.isRecord(variableElement.asType())) {
            return MethodParameterInfo.fromRecord(types, variableElement);
        }
        return MethodParameterInfo.fromSingle(types, variableElement);
    }

    private static Set<MethodParameterInfo> fromSingle(TypeUtils types, VariableElement variableElement) {
        MethodParameterInfo info = MethodParameterInfoBuilder.builder().variableElement(variableElement).name(new JavaName(variableElement.getSimpleName().toString())).type(types.kiwiType(variableElement.asType())).isRecordComponent(false).recordParameterName(null).build();
        return Set.of(info);
    }

    private static Set<MethodParameterInfo> fromRecord(TypeUtils types, VariableElement variableElement) {
        TypeElement type = types.asTypeElement(variableElement.asType());
        List<? extends RecordComponentElement> components = Objects.requireNonNull(type).getRecordComponents();
        HashSet parameterInfos = components.stream().map(component -> MethodParameterInfoBuilder.builder().variableElement(variableElement).name(new JavaName(component.getSimpleName().toString())).type(types.kiwiType(component.asType())).isRecordComponent(true).recordParameterName(variableElement.getSimpleName().toString()).build()).collect(Collectors.toCollection(HashSet::new));
        parameterInfos.addAll(MethodParameterInfo.fromSingle(types, variableElement));
        return parameterInfos;
    }
}

