/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.kiwiproc.processor;

import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.ethelred.kiwiproc.processor.SqlBatchPrism;
import org.ethelred.kiwiproc.processor.SqlQueryPrism;
import org.ethelred.kiwiproc.processor.SqlUpdatePrism;
import org.ethelred.kiwiproc.processor.TypeUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum QueryMethodKind {
    DEFAULT(ExecutableElement::isDefault),
    QUERY(SqlQueryPrism::isPresent){

        @Override
        public String getSql(ExecutableElement element) {
            SqlQueryPrism prism = SqlQueryPrism.getInstanceOn(element);
            return prism.sql().isBlank() ? prism.value() : prism.sql();
        }
    }
    ,
    UPDATE(SqlUpdatePrism::isPresent){

        @Override
        public String getSql(ExecutableElement element) {
            SqlUpdatePrism prism = SqlUpdatePrism.getInstanceOn(element);
            return prism.sql().isBlank() ? prism.value() : prism.sql();
        }

        @Override
        public boolean validateReturn(TypeUtils typeUtils, TypeMirror returnType) {
            return true;
        }
    }
    ,
    BATCH(SqlBatchPrism::isPresent){

        @Override
        public String getSql(ExecutableElement element) {
            SqlBatchPrism prism = SqlBatchPrism.getInstanceOn(element);
            return prism.sql().isBlank() ? prism.value() : prism.sql();
        }

        @Override
        public boolean validateReturn(TypeUtils typeUtils, TypeMirror returnType) {
            return true;
        }
    };

    private final Predicate<ExecutableElement> isKind;

    private QueryMethodKind(Predicate<ExecutableElement> isKind) {
        this.isKind = isKind;
    }

    static Set<QueryMethodKind> forMethod(ExecutableElement methodElement) {
        return Stream.of(QueryMethodKind.values()).filter(p -> p.isKind.test(methodElement)).collect(Collectors.toSet());
    }

    public String getSql(ExecutableElement element) {
        throw new UnsupportedOperationException();
    }

    public boolean validateReturn(TypeUtils typeUtils, TypeMirror returnType) {
        return true;
    }
}

